/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.utils;

import com.alibaba.fastjson.JSON;
import com.timevale.esign.sdk.tech.bean.AbstractSignPdfBean;
import com.timevale.esign.sdk.tech.bean.OrganizeBean;
import com.timevale.esign.sdk.tech.bean.PersonBean;
import com.timevale.esign.sdk.tech.bean.PosBean;
import com.timevale.esign.sdk.tech.bean.SignPDFFileBean;
import com.timevale.esign.sdk.tech.bean.SignPDFStreamBean;
import com.timevale.esign.sdk.tech.bean.result.AddAccountResult;
import com.timevale.esign.sdk.tech.bean.result.AddSealResult;
import com.timevale.esign.sdk.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.GetAccountProfileResult;
import com.timevale.esign.sdk.tech.bean.result.Result;
import com.timevale.esign.sdk.tech.bean.seal.OrganizeTemplateType;
import com.timevale.esign.sdk.tech.bean.seal.PersonTemplateType;
import com.timevale.esign.sdk.tech.bean.seal.SealColor;
import com.timevale.esign.sdk.tech.impl.constants.LegalAreaType;
import com.timevale.esign.sdk.tech.impl.constants.LicenseQueryType;
import com.timevale.esign.sdk.tech.impl.constants.SignType;
import com.timevale.esign.sdk.tech.service.AccountService;
import com.timevale.esign.sdk.tech.service.EsignsdkService;
import com.timevale.esign.sdk.tech.service.SealService;
import com.timevale.esign.sdk.tech.service.SelfSignService;
import com.timevale.esign.sdk.tech.service.UserSignService;
import com.timevale.esign.sdk.tech.service.factory.AccountServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.EsignsdkServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.SealServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.SelfSignServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.UserSignServiceFactory;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import com.timevale.tech.sdk.constants.AlgorithmType;
import com.timevale.tech.sdk.constants.HttpType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final int DEFAULT_RETRY_TIME = 5;
    public static final int DEFAULT_USER_SIGN_WIDTH = 100;
    public static final int DEFAULT_PLAT_SIGN_WIDTH = 159;
    public static final int POS_TYPE_POSTION = 0;
    public static final int POS_TYPE_KEYWORD = 1;
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_ERROR_ACCOUNT_EXIST = 150016;
    public static final int DEFAULT_PLATFORM_SEAL_ID = 0;
    private static Logger logger = LoggerFactory.getLogger(SignUtils.class);

    public static int initProject(String projectId, String projectSecret, String apiUrl) {
        ProjectConfig proCfg = SignUtils.initProjectConfig(projectId, projectSecret, apiUrl);
        HttpConnectionConfig httpConCfg = SignUtils.initHttpConnectionConfig();
        SignatureConfig sCfg = SignUtils.initSignatureConfig();
        logger.info("eSign init...");
        EsignsdkService sdk = EsignsdkServiceFactory.instance();
        Result result = sdk.init(proCfg, httpConCfg, sCfg);
        if (0 != result.getErrCode()) {
            logger.error("eSign init failed\uff1aerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("eSign init success\uff1aerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        }
        return result.getErrCode();
    }

    public static PosBean getUserKeywordPosBean(String keyword) {
        return SignUtils.getKeywordPosBean(keyword, 100);
    }

    public static PosBean getOrganizeKeywordPosBean(String keyword) {
        return SignUtils.getKeywordPosBean(keyword, 100);
    }

    public static PosBean getPlatformKeywordPosBean(String keyword) {
        return SignUtils.getKeywordPosBean(keyword, 159);
    }

    public static PosBean getKeywordPosBean(String keyword, int width) {
        PosBean posBean = new PosBean();
        posBean.setPosType(1);
        posBean.setKey(keyword);
        posBean.setWidth((float)width);
        return posBean;
    }

    public static PosBean getUserXYPosBean(String page, int x, int y) {
        return SignUtils.getXYPosBean(page, x, y, 100);
    }

    public static PosBean getPlatXYPosBean(String page, int x, int y) {
        return SignUtils.getXYPosBean(page, x, y, 159);
    }

    public static PosBean getXYPosBean(String page, int x, int y, int width) {
        PosBean posBean = new PosBean();
        posBean.setPosType(0);
        posBean.setPosPage(page);
        posBean.setPosX((float)x);
        posBean.setPosY((float)y);
        posBean.setWidth((float)width);
        return posBean;
    }

    private static SignPDFStreamBean setSignPDFStreamBean(byte[] pdfData) {
        SignPDFStreamBean signPDFStreamBean = new SignPDFStreamBean();
        signPDFStreamBean.setStream(pdfData);
        return signPDFStreamBean;
    }

    public static SignPDFFileBean setSignPDFFileBean(String srcPdfFile, String signedPdfFile, String signedPdfFileName) {
        SignPDFFileBean signPDFFileBean = new SignPDFFileBean();
        signPDFFileBean.setSrcPdfFile(srcPdfFile);
        signPDFFileBean.setDstPdfFile(signedPdfFile);
        signPDFFileBean.setFileName(signedPdfFileName);
        signPDFFileBean.setOwnerPassword(null);
        return signPDFFileBean;
    }

    public static FileDigestSignResult customerDigestSign(byte[] pdfData, String accountId, String sealData, String page, int x, int y) {
        SignPDFStreamBean signPDFStreamBean = SignUtils.setSignPDFStreamBean(pdfData);
        PosBean posBean = SignUtils.getUserXYPosBean(page, x, y);
        SignType signType = SignType.Single;
        if (StringUtils.containsAny((CharSequence)page, (char[])new char[]{'-', ','})) {
            signType = SignType.Multi;
        }
        return SignUtils.customerDigestSign(signPDFStreamBean, accountId, sealData, posBean, signType);
    }

    public static FileDigestSignResult customerDigestSign(byte[] pdfData, String accountId, String sealData, PosBean posBean, SignType signType) {
        SignPDFStreamBean signPDFStreamBean = SignUtils.setSignPDFStreamBean(pdfData);
        return SignUtils.customerDigestSign(signPDFStreamBean, accountId, sealData, posBean, signType);
    }

    public static FileDigestSignResult userOrganizeSignByFile(String srcPdfFile, String signedPdfFile, String signedPdfFileName, String accountId, String sealData, PosBean posBean, SignType signType) {
        SignPDFFileBean setSignPDFFileBean = SignUtils.setSignPDFFileBean(srcPdfFile, signedPdfFile, signedPdfFileName);
        return SignUtils.userOrganizeSignByStream(setSignPDFFileBean, accountId, sealData, posBean, signType);
    }

    public static FileDigestSignResult userOrganizeSignByStream(SignPDFFileBean signPDFFileBean, String accountId, String sealData, PosBean posBean, SignType signType) {
        logger.info("user sign start.");
        if (logger.isDebugEnabled()) {
            logger.debug("accountId: {},posBean: {},sealData: {},signType: {}", new Object[]{accountId, posBean, sealData, signType});
        }
        if (SignUtils.anyNullOrBlank(signPDFFileBean, accountId, sealData, posBean, signType)) {
            throw new IllegalArgumentException("one or more args are null");
        }
        UserSignService userSignService = UserSignServiceFactory.instance();
        FileDigestSignResult result = userSignService.localSignPDF(accountId, sealData, (AbstractSignPdfBean)signPDFFileBean, posBean, signType);
        if (logger.isDebugEnabled()) {
            logger.debug(JSON.toJSONString((Object)result));
        }
        return result;
    }

    public static FileDigestSignResult customerDigestSign(SignPDFStreamBean signPDFStreamBean, String accountId, String sealData, PosBean posBean, SignType signType) {
        logger.info("customer sign start.");
        if (logger.isDebugEnabled()) {
            logger.debug("accountId: {},posBean: {},sealData: {},signType: {}", new Object[]{accountId, posBean, sealData, signType});
        }
        if (SignUtils.anyNullOrBlank(signPDFStreamBean, accountId, sealData, posBean, signType)) {
            throw new IllegalArgumentException("one or more args are null");
        }
        UserSignService userSignService = UserSignServiceFactory.instance();
        FileDigestSignResult result = userSignService.localSignPDF(accountId, sealData, (AbstractSignPdfBean)signPDFStreamBean, posBean, signType);
        if (logger.isDebugEnabled()) {
            logger.debug(JSON.toJSONString((Object)result));
        }
        return result;
    }

    public static FileDigestSignResult platformSignByStreamm(byte[] pdfData, String page, int x, int y) {
        SignPDFStreamBean signPDFStreamBean = SignUtils.setSignPDFStreamBean(pdfData);
        PosBean posBean = SignUtils.getPlatXYPosBean(page, x, y);
        SignType signType = SignType.Single;
        if (StringUtils.containsAny((CharSequence)page, (char[])new char[]{'-', ','})) {
            signType = SignType.Multi;
        }
        int sealId = 0;
        logger.info("platform self sign use default seal");
        if (logger.isDebugEnabled()) {
            logger.debug("page:{},x:{},y:{}", new Object[]{page, x, y});
        }
        logger.info("----platform self sign by digest start...");
        SelfSignService selfSignService = SelfSignServiceFactory.instance();
        FileDigestSignResult result = selfSignService.localSignPdf((AbstractSignPdfBean)signPDFStreamBean, posBean, sealId, signType);
        if (0 != result.getErrCode()) {
            logger.info("platform self sign by digest failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("platform self sign by digest success, SignServiceId ={} ", (Object)result.getSignServiceId());
        }
        return result;
    }

    public static FileDigestSignResult platformSignByStreamm(byte[] pdfData, PosBean posBean, SignType signType) {
        SignPDFStreamBean signPDFStreamBean = SignUtils.setSignPDFStreamBean(pdfData);
        return SignUtils.platformSignByStreamm(signPDFStreamBean, posBean, signType);
    }

    public static FileDigestSignResult platformSignByStreamm(SignPDFStreamBean pdfData, PosBean posBean, SignType signType) {
        logger.info("----platform self sign by digest start...");
        SelfSignService selfSignService = SelfSignServiceFactory.instance();
        FileDigestSignResult result = selfSignService.localSignPdf((AbstractSignPdfBean)pdfData, posBean, 0, signType);
        if (0 != result.getErrCode()) {
            logger.info("platform self sign by digest failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("platform self sign by digest success, SignServiceId ={} ", (Object)result.getSignServiceId());
        }
        return result;
    }

    public static FileDigestSignResult platformSignByStreamm(SignPDFStreamBean pdfData, PosBean posBean, SignType signType, int sealId) {
        logger.info("----platform self sign by digest start...");
        SelfSignService selfSignService = SelfSignServiceFactory.instance();
        FileDigestSignResult result = selfSignService.localSignPdf((AbstractSignPdfBean)pdfData, posBean, sealId, signType);
        if (0 != result.getErrCode()) {
            logger.info("platform self sign by digest failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("platform self sign by digest success, SignServiceId ={} ", (Object)result.getSignServiceId());
        }
        return result;
    }

    public static GetAccountProfileResult getExistUserAccount(String idNo) {
        return SignUtils.getExistUserAccount(idNo, LicenseQueryType.MAINLAND);
    }

    public static GetAccountProfileResult getExistUserAccount(String idNo, LicenseQueryType area) {
        AccountService accountService = AccountServiceFactory.instance();
        return accountService.getAccountInfoByIdNo(idNo, area);
    }

    public static AddAccountResult addPersonAccount(String name, String idNo, int area, String email, String mobile, String organ, String title, String address) {
        PersonBean personBean = new PersonBean();
        personBean.setEmail(email);
        personBean.setMobile(mobile);
        personBean.setName(name);
        personBean.setIdNo(idNo);
        personBean.setPersonArea(LegalAreaType.of((Integer)area));
        personBean.setOrgan(organ);
        personBean.setTitle(title);
        personBean.setAddress(address);
        logger.info("creating user account");
        AccountService accountService = AccountServiceFactory.instance();
        AddAccountResult result = accountService.addAccount(personBean);
        if (0 != result.getErrCode()) {
            logger.info("create user account failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("create user account success\uff01accountId = {}", (Object)result.getAccountId());
        }
        return result;
    }

    public static AddAccountResult addPersonAccount(PersonBean bean) {
        logger.info("creating user account");
        AccountService accountService = AccountServiceFactory.instance();
        AddAccountResult result = accountService.addAccount(bean);
        if (0 != result.getErrCode()) {
            logger.info("create user account failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("create user account success\uff01accountId = {}", (Object)result.getAccountId());
        }
        return result;
    }

    public static AddAccountResult addOrganizeAccount(OrganizeBean bean) {
        logger.info("creating user account");
        AccountService accountService = AccountServiceFactory.instance();
        AddAccountResult result = accountService.addAccount(bean);
        if (0 != result.getErrCode()) {
            logger.info("create organize account failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("create organize account success\uff01accountId = {}", (Object)result.getAccountId());
        }
        return result;
    }

    public static AddSealResult addPersonTemplateSeal(String accountId) {
        return SignUtils.addPersonTemplateSeal(accountId, PersonTemplateType.RECTANGLE, SealColor.RED);
    }

    public static AddSealResult addPersonTemplateSeal(String accountId, PersonTemplateType type, SealColor color) {
        logger.info("creating personal template,accountId:{},type:{},color:{}", new Object[]{accountId, type, color});
        SealService sealService = SealServiceFactory.instance();
        AddSealResult result = sealService.addTemplateSeal(accountId, type, color);
        if (0 != result.getErrCode()) {
            logger.info("create personal template failed\uff0cerrCode={},msg={}", (Object)result.getErrCode(), (Object)result.getMsg());
        } else {
            logger.info("create personal template success\uff01sealData = {}", (Object)result.getSealData());
        }
        return result;
    }

    public static AddSealResult addOrganizeTemplateSeal(String accountId, OrganizeTemplateType type, SealColor color, String hText, String qText) {
        logger.info("creating organize template,accountId:{},type:{},color:{},hText:{},qText:{}", new Object[]{accountId, type, color, hText, qText});
        SealService sealService = SealServiceFactory.instance();
        AddSealResult addSealResult = sealService.addTemplateSeal(accountId, type, color, hText, qText);
        if (0 != addSealResult.getErrCode()) {
            logger.info("create organize template failed\uff0cerrCode={},msg={}", (Object)addSealResult.getErrCode(), (Object)addSealResult.getMsg());
        } else {
            logger.info("create organize template success\uff01sealData = {}", (Object)addSealResult.getSealData());
        }
        return addSealResult;
    }

    private static SignatureConfig initSignatureConfig() {
        SignatureConfig sCfg = new SignatureConfig();
        sCfg.setAlgorithm(AlgorithmType.HMACSHA256);
        sCfg.setEsignPublicKey("");
        sCfg.setPrivateKey("");
        return sCfg;
    }

    private static HttpConnectionConfig initHttpConnectionConfig() {
        HttpConnectionConfig httpConCfg = new HttpConnectionConfig();
        httpConCfg.setHttpType(HttpType.HTTPS);
        httpConCfg.setRetry(Integer.valueOf(5));
        httpConCfg.setProxyIp(null);
        httpConCfg.setProxyPort(Integer.valueOf(0));
        return httpConCfg;
    }

    private static HttpConnectionConfig initHttpConnectionConfig(String proxyId, Integer port) {
        HttpConnectionConfig httpConCfg = new HttpConnectionConfig();
        httpConCfg.setHttpType(HttpType.HTTPS);
        httpConCfg.setRetry(Integer.valueOf(5));
        httpConCfg.setProxyIp(proxyId);
        httpConCfg.setProxyPort(port);
        return httpConCfg;
    }

    private static ProjectConfig initProjectConfig(String projectId, String projectSecret, String apiUrl) {
        ProjectConfig proCfg = new ProjectConfig();
        proCfg.setProjectId(projectId);
        proCfg.setProjectSecret(projectSecret);
        proCfg.setItsmApiUrl(apiUrl);
        return proCfg;
    }

    private static boolean anyNull(Object ... objects) {
        if (objects != null) {
            for (Object o : objects) {
                if (o != null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean anyNullOrBlank(Object ... objects) {
        if (objects != null) {
            for (Object o : objects) {
                if (o == null) {
                    return true;
                }
                if (!(o instanceof String)) continue;
                String s = (String)o;
                return StringUtils.isBlank((CharSequence)s);
            }
        }
        return false;
    }
}

