/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.utils;

import com.hand.app.esign.utils.FileHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFHelper {
    private static Logger LOG = LoggerFactory.getLogger(PDFHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pdf2Image(String PdfFilePath, String dstImgFolder, int dpi) {
        File file = new File(PdfFilePath);
        int pages = 0;
        try {
            String imgPDFPath = file.getParent();
            int dot = file.getName().lastIndexOf(46);
            String imagePDFName = file.getName().substring(0, dot);
            String imgFolderPath = null;
            imgFolderPath = dstImgFolder.equals("") ? imgPDFPath + File.separator + imagePDFName : dstImgFolder + File.separator + imagePDFName;
            if (FileHelper.createDirectory(imgFolderPath)) {
                PDDocument pdDocument = PDDocument.load((File)file);
                PDFRenderer renderer = new PDFRenderer(pdDocument);
                pages = pdDocument.getNumberOfPages();
                StringBuffer imgFilePath = null;
                for (int i = 0; i < pages; ++i) {
                    String imgFilePathPrefix = imgFolderPath + File.separator + imagePDFName;
                    imgFilePath = new StringBuffer();
                    imgFilePath.append(imgFilePathPrefix);
                    imgFilePath.append("_");
                    imgFilePath.append(String.valueOf(i + 1));
                    imgFilePath.append(".png");
                    File dstFile = new File(imgFilePath.toString());
                    BufferedImage image = renderer.renderImageWithDPI(i, (float)dpi);
                    ImageIO.write((RenderedImage)image, "png", dstFile);
                }
                LOG.info("PDF\u6587\u6863\u8f6cPNG\u56fe\u7247\u6210\u529f\uff01");
            }
            LOG.info("PDF\u6587\u6863\u8f6cPNG\u56fe\u7247\u5931\u8d25\uff1a\u521b\u5efa" + imgFolderPath + "\u5931\u8d25");
        }
        catch (IOException e) {
            LOG.info("PDF\u6587\u6863\u8f6cPNG\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            return pages;
        }
    }
}

