/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static Logger LOG = LoggerFactory.getLogger(FileHelper.class);

    public static Map<String, String> getFileInfo(String filePath) {
        LinkedHashMap<String, String> fileInfos = new LinkedHashMap<String, String>();
        File file = new File(filePath);
        fileInfos.put("FileName", file.getName());
        fileInfos.put("FileLength", String.valueOf(file.length()));
        return fileInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(String filePath) {
        File file = new File(filePath);
        FileInputStream fis = null;
        byte[] buffer = null;
        try {
            fis = new FileInputStream(file);
            buffer = new byte[(int)file.length()];
            fis.read(buffer);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOG.info("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.info("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.info("FileInputStream \u5173\u95ed\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> saveFileByStream(byte[] bytes, String folder, String fileName) {
        HashMap<String, String> fileResult = new HashMap<String, String>();
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(folder);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(folder + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
            fileResult.put("errCode", "0");
            fileResult.put("msg", "\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.info("\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            fileResult.put("errCode", "0");
            fileResult.put("msg", "\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u6210\u529f");
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    LOG.info("\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u5931\u8d25\uff1a" + e1.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    LOG.info("\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u5931\u8d25\uff1a" + e1.getMessage());
                }
            }
        }
        return fileResult;
    }

    public static String getFileMD5(String filePath) {
        FileInputStream fis = null;
        BigInteger bigInt = null;
        try {
            File file = new File(filePath);
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = fis.read(buffer, 0, 1024)) != -1) {
                md.update(buffer, 0, length);
            }
            bigInt = new BigInteger(1, md.digest());
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOG.info(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.info(e.getMessage());
        }
        return bigInt.toString(16);
    }

    public static boolean createDirectory(String folderPath) {
        boolean isSuccess = false;
        File file = new File(folderPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdir();
            isSuccess = true;
        } else {
            isSuccess = true;
        }
        return isSuccess;
    }

    public static String GetImageStr(String imgFilePath) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            LOG.info("\u4e0a\u4f20\u7684\u5370\u7ae0\u56fe\u7247\u8f6csealData\u9519\u8bef\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        byte[] en = Base64.encodeBase64((byte[])data);
        return new String(en);
    }
}

