/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign;

import com.hand.app.esign.utils.FileHelper;
import com.timevale.esign.sdk.tech.bean.AbstractSignPdfBean;
import com.timevale.esign.sdk.tech.bean.OrganizeBean;
import com.timevale.esign.sdk.tech.bean.PersonBean;
import com.timevale.esign.sdk.tech.bean.PosBean;
import com.timevale.esign.sdk.tech.bean.SignPDFFileBean;
import com.timevale.esign.sdk.tech.bean.SignPDFStreamBean;
import com.timevale.esign.sdk.tech.bean.UpdateOrganizeBean;
import com.timevale.esign.sdk.tech.bean.UpdatePersonBean;
import com.timevale.esign.sdk.tech.bean.result.AddAccountResult;
import com.timevale.esign.sdk.tech.bean.result.AddSealResult;
import com.timevale.esign.sdk.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.Result;
import com.timevale.esign.sdk.tech.bean.seal.OrganizeTemplateType;
import com.timevale.esign.sdk.tech.bean.seal.PersonTemplateType;
import com.timevale.esign.sdk.tech.bean.seal.SealColor;
import com.timevale.esign.sdk.tech.impl.constants.OrganRegType;
import com.timevale.esign.sdk.tech.impl.constants.SignType;
import com.timevale.esign.sdk.tech.service.AccountService;
import com.timevale.esign.sdk.tech.service.EsignsdkService;
import com.timevale.esign.sdk.tech.service.SealService;
import com.timevale.esign.sdk.tech.service.SelfSignService;
import com.timevale.esign.sdk.tech.service.UserSignService;
import com.timevale.esign.sdk.tech.service.factory.AccountServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.EsignsdkServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.SealServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.SelfSignServiceFactory;
import com.timevale.esign.sdk.tech.service.factory.UserSignServiceFactory;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import com.timevale.tech.sdk.constants.AlgorithmType;
import com.timevale.tech.sdk.constants.HttpType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignHelper {
    private static Logger LOG = LoggerFactory.getLogger(SignHelper.class);

    public static void initProject() {
        ProjectConfig proCfg = new ProjectConfig();
        proCfg.setProjectId("1111563517");
        proCfg.setProjectSecret("95439b0863c241c63a861b87d1e647b7");
        proCfg.setItsmApiUrl("http://121.40.164.61:8080/tgmonitor/rest/app!getAPIInfo2");
        HttpConnectionConfig httpConCfg = new HttpConnectionConfig();
        httpConCfg.setHttpType(HttpType.HTTPS);
        httpConCfg.setRetry(Integer.valueOf(5));
        SignatureConfig sCfg = new SignatureConfig();
        sCfg.setAlgorithm(AlgorithmType.HMACSHA256);
        sCfg.setEsignPublicKey("");
        sCfg.setPrivateKey("");
        System.out.println("--\u9879\u76ee\u521d\u59cb\u5316...");
        EsignsdkService sdk = EsignsdkServiceFactory.instance();
        Result result = sdk.init(proCfg, httpConCfg, sCfg);
        if (0 != result.getErrCode()) {
            LOG.info("--\u9879\u76ee\u521d\u59cb\u5316\u5931\u8d25\uff1aerrCode=" + result.getErrCode() + " msg=" + result.getMsg());
        } else {
            System.out.println("--\u9879\u76ee\u521d\u59cb\u5316\u6210\u529f\uff01errCode=" + result.getErrCode() + " msg=" + result.getMsg());
        }
    }

    public static PosBean setXYPosBean(String page, int x, int y) {
        PosBean posBean = new PosBean();
        posBean.setPosType(0);
        posBean.setPosPage(page);
        posBean.setPosX((float)x);
        posBean.setPosY((float)y);
        posBean.setWidth(159.0f);
        return posBean;
    }

    public static PosBean setKeyPosBean(String key, int x, int y, int width) {
        PosBean posBean = new PosBean();
        posBean.setPosType(1);
        posBean.setKey(key);
        posBean.setPosX((float)x);
        posBean.setPosY((float)y);
        posBean.setWidth((float)width);
        return posBean;
    }

    public static SignPDFStreamBean setSignPDFStreamBean(byte[] pdfFileStream) {
        SignPDFStreamBean signPDFStreamBean = new SignPDFStreamBean();
        signPDFStreamBean.setStream(pdfFileStream);
        return signPDFStreamBean;
    }

    public static SignPDFFileBean setSignPDFFileBean(String srcPdfFile, String signedPdfFile) {
        SignPDFFileBean signPDFFileBean = new SignPDFFileBean();
        signPDFFileBean.setSrcPdfFile(srcPdfFile);
        signPDFFileBean.setDstPdfFile(signedPdfFile);
        signPDFFileBean.setFileName("pdf\u6587\u4ef6\u540d");
        signPDFFileBean.setOwnerPassword(null);
        return signPDFFileBean;
    }

    public static FileDigestSignResult platformSignByStreamm(String srcPdfFile) {
        SignPDFStreamBean signPDFStreamBean = SignHelper.setSignPDFStreamBean(FileHelper.getBytes(srcPdfFile));
        PosBean posBean = SignHelper.setXYPosBean("1", 170, 714);
        SignType signType = SignType.Single;
        int sealId = 0;
        System.out.println("----\u5f00\u59cb\u5e73\u53f0\u81ea\u8eabPDF\u6458\u8981\u7b7e\u7f72...");
        SelfSignService selfSignService = SelfSignServiceFactory.instance();
        FileDigestSignResult fileDigestSignResult = selfSignService.localSignPdf((AbstractSignPdfBean)signPDFStreamBean, posBean, sealId, signType);
        if (0 != fileDigestSignResult.getErrCode()) {
            LOG.info("\u5e73\u53f0\u81ea\u8eabPDF\u6458\u8981\u7b7e\u7f72\uff08\u6587\u4ef6\u6d41\uff09\u5931\u8d25\uff0cerrCode=" + fileDigestSignResult.getErrCode() + " msg=" + fileDigestSignResult.getMsg());
        } else {
            System.out.println("----\u5e73\u53f0\u81ea\u8eabPDF\u6458\u8981\u7b7e\u7f72\u6210\u529f\uff01\u7b7e\u7f72\u8bb0\u5f55SignServiceId = " + fileDigestSignResult.getSignServiceId() + ", \u8bf7\u4fdd\u5b58\u8be5\u7b7e\u7f72\u8bb0\u5f55Id\uff01");
        }
        return fileDigestSignResult;
    }

    public static FileDigestSignResult platformSignByFile(String srcPdfFile, String signedPdfFile) {
        SignPDFFileBean signPDFFileBean = SignHelper.setSignPDFFileBean(srcPdfFile, signedPdfFile);
        PosBean posBean = SignHelper.setXYPosBean("1", 170, 714);
        SignType signType = SignType.Single;
        int sealId = 0;
        System.out.println("----\u5f00\u59cb\u5e73\u53f0\u81ea\u8eabPDF\u6458\u8981\u7b7e\u7f72...");
        SelfSignService selfSignService = SelfSignServiceFactory.instance();
        FileDigestSignResult fileDigestSignResult = selfSignService.localSignPdf((AbstractSignPdfBean)signPDFFileBean, posBean, sealId, signType);
        if (0 != fileDigestSignResult.getErrCode()) {
            LOG.info("\u5e73\u53f0\u81ea\u8eabPDF\u6458\u8981\u7b7e\u7f72\uff08\u6587\u4ef6\uff09\u5931\u8d25\uff0cerrCode=" + fileDigestSignResult.getErrCode() + " msg=" + fileDigestSignResult.getMsg());
        } else {
            System.out.println("----\u5e73\u53f0\u81ea\u8eabPDF\u6458\u8981\u7b7e\u7f72\u6210\u529f\uff01SignServiceId = " + fileDigestSignResult.getSignServiceId());
        }
        return fileDigestSignResult;
    }

    public static FileDigestSignResult userPersonSignByStream(byte[] pdfFileStream, String accountId, String sealData) {
        SignPDFStreamBean signPDFStreamBean = SignHelper.setSignPDFStreamBean(pdfFileStream);
        PosBean posBean = SignHelper.setKeyPosBean("\u4e59\u65b9\u7b7e\u540d", 110, 0, 90);
        SignType signType = SignType.Key;
        System.out.println("----\u5f00\u59cb\u5e73\u53f0\u4e2a\u4eba\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72...");
        UserSignService userSignService = UserSignServiceFactory.instance();
        FileDigestSignResult fileDigestSignResult = userSignService.localSignPDF(accountId, sealData, (AbstractSignPdfBean)signPDFStreamBean, posBean, signType);
        if (0 != fileDigestSignResult.getErrCode()) {
            LOG.info("\u5e73\u53f0\u4e2a\u4eba\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72\u5931\u8d25\uff0cerrCode=" + fileDigestSignResult.getErrCode() + " msg=" + fileDigestSignResult.getMsg());
        } else {
            System.out.println("\u5e73\u53f0\u4e2a\u4eba\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72\u6210\u529f\uff01\u7b7e\u7f72\u8bb0\u5f55SignServiceId = " + fileDigestSignResult.getSignServiceId() + ", \u8bf7\u4fdd\u5b58\u8be5\u7b7e\u7f72\u8bb0\u5f55Id\uff01");
        }
        return fileDigestSignResult;
    }

    public static FileDigestSignResult userPersonSignByFile(String srcPdf, String signedPdf, String accountId, String sealData) {
        SignPDFFileBean signPDFFileBean = SignHelper.setSignPDFFileBean(srcPdf, signedPdf);
        PosBean posBean = SignHelper.setKeyPosBean("\u4e59\u65b9\u7b7e\u540d", 0, 0, 159);
        SignType signType = SignType.Key;
        System.out.println("----\u5f00\u59cb\u5e73\u53f0\u4e2a\u4eba\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72...");
        UserSignService userSignService = UserSignServiceFactory.instance();
        FileDigestSignResult fileDigestSignResult = userSignService.localSignPDF(accountId, sealData, (AbstractSignPdfBean)signPDFFileBean, posBean, signType);
        if (0 != fileDigestSignResult.getErrCode()) {
            LOG.info("\u5e73\u53f0\u4e2a\u4eba\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72\u5931\u8d25\uff0cerrCode=" + fileDigestSignResult.getErrCode() + " msg=" + fileDigestSignResult.getMsg());
        } else {
            System.out.println("\u5e73\u53f0\u4e2a\u4eba\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72\u6210\u529f\uff01SignServiceId = " + fileDigestSignResult.getSignServiceId());
        }
        return fileDigestSignResult;
    }

    public static FileDigestSignResult userOrganizeSignByStream(byte[] pdfFileStream, String accountId, String sealData) {
        SignPDFStreamBean signPDFStreamBean = SignHelper.setSignPDFStreamBean(pdfFileStream);
        PosBean posBean = SignHelper.setXYPosBean("1", 120, 100);
        SignType signType = SignType.Single;
        System.out.println("----\u5f00\u59cb\u5e73\u53f0\u4f01\u4e1a\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72...");
        UserSignService userSignService = UserSignServiceFactory.instance();
        FileDigestSignResult fileDigestSignResult = userSignService.localSignPDF(accountId, sealData, (AbstractSignPdfBean)signPDFStreamBean, posBean, signType);
        if (0 != fileDigestSignResult.getErrCode()) {
            LOG.info("\u5e73\u53f0\u4f01\u4e1a\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72\u5931\u8d25\uff0cerrCode=" + fileDigestSignResult.getErrCode() + " msg=" + fileDigestSignResult.getMsg());
        } else {
            System.out.println("\u5e73\u53f0\u4f01\u4e1a\u5ba2\u6237\u7684PDF\u6458\u8981\u7b7e\u7f72\u6210\u529f\uff01\u7b7e\u7f72\u8bb0\u5f55SignServiceId = " + fileDigestSignResult.getSignServiceId() + ", \u8bf7\u4fdd\u5b58\u8be5\u7b7e\u7f72\u8bb0\u5f55Id\uff01");
        }
        return fileDigestSignResult;
    }

    public static String addPersonAccount() {
        PersonBean personBean = new PersonBean();
        personBean.setName("\u6b23\u54f2");
        personBean.setIdNo("220301198704140010");
        personBean.setPersonArea(0);
        System.out.println("----\u5f00\u59cb\u521b\u5efa\u4e2a\u4eba\u8d26\u6237...");
        AccountService accountService = AccountServiceFactory.instance();
        AddAccountResult addAccountResult = accountService.addAccount(personBean);
        if (0 != addAccountResult.getErrCode()) {
            LOG.info("\u521b\u5efa\u4e2a\u4eba\u8d26\u6237\u5931\u8d25\uff0cerrCode=" + addAccountResult.getErrCode() + " msg=" + addAccountResult.getMsg());
        } else {
            System.out.println("\u521b\u5efa\u4e2a\u4eba\u8d26\u6237\u6210\u529f\uff01accountId = " + addAccountResult.getAccountId());
        }
        return addAccountResult.getAccountId();
    }

    public static String addOrganizeAccount() {
        OrganizeBean organizeBean = new OrganizeBean();
        organizeBean.setName("\u5929\u4e4b\u4e91\u4fe1\u606f\u79d1\u6280\u6709\u9650\u516c\u53f8");
        organizeBean.setOrganType(0);
        organizeBean.setRegType(OrganRegType.MERGE);
        organizeBean.setOrganCode("52227058XT51M4AL62");
        organizeBean.setAddress("\u676d\u5dde\u57ce\u843d\u971e\u5cf07\u53f7");
        organizeBean.setUserType(1);
        organizeBean.setAgentName("\u827e\u5229");
        organizeBean.setAgentIdNo("220301198705170035");
        System.out.println("----\u5f00\u59cb\u521b\u5efa\u4f01\u4e1a\u8d26\u6237...");
        AccountService accountService = AccountServiceFactory.instance();
        AddAccountResult addAccountResult = accountService.addAccount(organizeBean);
        if (0 != addAccountResult.getErrCode()) {
            LOG.info("\u521b\u5efa\u4f01\u4e1a\u8d26\u6237\u5931\u8d25\uff0cerrCode=" + addAccountResult.getErrCode() + " msg=" + addAccountResult.getMsg());
        } else {
            System.out.println("\u521b\u5efa\u4f01\u4e1a\u8d26\u6237\u6210\u529f\uff01accountId = " + addAccountResult.getAccountId());
        }
        return addAccountResult.getAccountId();
    }

    public static void deleteAccount(String accountId) {
        AccountService accountService = AccountServiceFactory.instance();
        Result result = accountService.deleteAccount(accountId);
        if (0 != result.getErrCode()) {
            LOG.info("\u6ce8\u9500\u4e2a\u4eba\u8d26\u6237\u5931\u8d25\uff0cerrCode=" + result.getErrCode() + " msg=" + result.getMsg());
        } else {
            System.out.println("\u6ce8\u9500\u4e2a\u4eba\u8d26\u6237\u6210\u529f\uff01accountId = " + accountId + " \u5df2\u88ab\u6ce8\u9500");
        }
    }

    public static void updatePersonAccount(String accountId, String mobile) {
        UpdatePersonBean updatePersonBean = new UpdatePersonBean();
        updatePersonBean.setMobile(mobile);
        AccountService accountService = AccountServiceFactory.instance();
        Result result = accountService.updateAccount(accountId, updatePersonBean, null);
        if (0 != result.getErrCode()) {
            LOG.info("\u66f4\u65b0\u4e2a\u4eba\u8d26\u6237\u5931\u8d25\uff0cerrCode=" + result.getErrCode() + " msg=" + result.getMsg());
        } else {
            System.out.println("\u66f4\u65b0\u4e2a\u4eba\u8d26\u6237\u6210\u529f\uff01accountId = " + accountId + " \u5df2\u88ab\u66f4\u65b0");
        }
    }

    public static void updateOrganizeAccount(String accountId, String mobile) {
        UpdateOrganizeBean updateOrganizeBean = new UpdateOrganizeBean();
        updateOrganizeBean.setMobile(mobile);
        AccountService accountService = AccountServiceFactory.instance();
        Result result = accountService.updateAccount(accountId, updateOrganizeBean, null);
        if (0 != result.getErrCode()) {
            LOG.info("\u66f4\u65b0\u4f01\u4e1a\u8d26\u6237\u5931\u8d25\uff0cerrCode=" + result.getErrCode() + " msg=" + result.getMsg());
        } else {
            System.out.println("\u66f4\u65b0\u4f01\u4e1a\u8d26\u6237\u6210\u529f\uff01accountId = " + accountId + " \u5df2\u88ab\u66f4\u65b0");
        }
    }

    public static AddSealResult addPersonTemplateSeal(String accountId) {
        PersonTemplateType personTemplateType = PersonTemplateType.RECTANGLE;
        SealColor sealColor = SealColor.RED;
        System.out.println("----\u5f00\u59cb\u521b\u5efa\u4e2a\u4eba\u8d26\u6237\u7684\u5370\u7ae0...");
        SealService sealService = SealServiceFactory.instance();
        AddSealResult addSealResult = sealService.addTemplateSeal(accountId, personTemplateType, sealColor);
        if (0 != addSealResult.getErrCode()) {
            LOG.info("\u521b\u5efa\u4e2a\u4eba\u6a21\u677f\u5370\u7ae0\u5931\u8d25\uff0cerrCode=" + addSealResult.getErrCode() + " msg=" + addSealResult.getMsg());
        } else {
            System.out.println("\u521b\u5efa\u4e2a\u4eba\u6a21\u677f\u5370\u7ae0\u6210\u529f\uff01SealData = " + addSealResult.getSealData());
        }
        return addSealResult;
    }

    public static AddSealResult addOrganizeTemplateSeal(String accountId) {
        OrganizeTemplateType organizeTemplateType = OrganizeTemplateType.STAR;
        SealColor sealColor = SealColor.RED;
        String hText = "\u5408\u540c\u4e13\u7528\u7ae0";
        String qText = "91010086135601";
        System.out.println("----\u5f00\u59cb\u521b\u5efa\u4f01\u4e1a\u8d26\u6237\u7684\u5370\u7ae0...");
        SealService sealService = SealServiceFactory.instance();
        AddSealResult addSealResult = sealService.addTemplateSeal(accountId, organizeTemplateType, sealColor, hText, qText);
        if (0 != addSealResult.getErrCode()) {
            LOG.info("\u521b\u5efa\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u5931\u8d25\uff0cerrCode=" + addSealResult.getErrCode() + " msg=" + addSealResult.getMsg());
        } else {
            System.out.println("\u521b\u5efa\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u6210\u529f\uff01SealData = " + addSealResult.getSealData());
        }
        return addSealResult;
    }

    public static String getSealDataByImage(String imgFilePath) {
        System.out.println("----\u5f00\u59cb\u5c06\u4e0a\u4f20\u7684\u5370\u7ae0\u56fe\u7247\u8f6c\u6210SealData\u6570\u636e...");
        String sealData = FileHelper.GetImageStr(imgFilePath);
        System.out.println("----\u4e0a\u4f20\u7684\u5370\u7ae0\u56fe\u7247\u8f6c\u6210SealData\u6570\u636e\u5b8c\u6210\uff01sealData:" + sealData);
        return sealData;
    }

    public static boolean saveSignedByStream(byte[] signedStream, String signedFolder, String signedFileName) {
        System.out.println("----\u5f00\u59cb\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6...");
        boolean isSuccess = false;
        Map<String, String> fileResult = FileHelper.saveFileByStream(signedStream, signedFolder, signedFileName);
        if (0 != Integer.parseInt(fileResult.get("errCode"))) {
            LOG.info("\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u5931\u8d25\uff0cerrCode=" + fileResult.get("errCode") + " msg=" + fileResult.get("msg"));
        } else {
            isSuccess = true;
            System.out.println("\u4fdd\u5b58\u7b7e\u7f72\u540e\u6587\u4ef6\u6210\u529f\uff01errCode=" + fileResult.get("errCode") + " msg=" + fileResult.get("msg"));
        }
        return isSuccess;
    }
}

