/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.electronicSignature.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.hand.app.electronicSignature.dto.EleSignAuth;
import com.hand.app.electronicSignature.dto.EleSignContract;
import com.hand.app.electronicSignature.dto.EleSignSeal;
import com.hand.app.electronicSignature.dto.EleSignUser;
import com.hand.app.electronicSignature.dto.EleSignVerify;
import com.hand.app.electronicSignature.service.IElectronicSignatureAuth;
import com.hand.app.electronicSignature.service.IElectronicSignatureContract;
import com.hand.app.electronicSignature.service.IElectronicSignatureSeal;
import com.hand.app.electronicSignature.service.IElectronicSignatureService;
import com.hand.app.electronicSignature.service.IElectronicSignatureVerify;
import com.hand.app.hms.service.IHmsThirdpartyAppService;
import com.hand.hap.system.controllers.BaseController;
import java.io.InputStream;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import service.SignAPI;

@Controller
@RequestMapping(value={"/r/api"})
public class ElectronicSignatureController
extends BaseController {
    @Autowired
    IElectronicSignatureService electronicSignatureService;
    @Autowired
    IHmsThirdpartyAppService thirdpartyAppService;
    @Value(value="${electronic.signature.path}")
    private static String APIConfigPath;
    @Autowired
    IElectronicSignatureSeal electronicSignatureSeal;
    @Autowired
    IElectronicSignatureAuth electronicSignatureAuth;
    @Autowired
    IElectronicSignatureContract electronicSignatureContract;
    @Autowired
    IElectronicSignatureVerify electronicSignatureVerify;

    @RequestMapping(value={"/electronicSignature/personalAccountOpen"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject personalAccountOpen(HttpServletRequest requests, @RequestBody(required=false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureService.personalAccountOpen(params);
            params.setUserId(response.get((Object)"userId").toString());
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignUser result = this.electronicSignatureService.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/firmAccountOpen"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject firmAccountOpen(HttpServletRequest requests, @RequestBody(required=false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureService.firmAccountOpen(params);
            params.setUserId(response.get((Object)"userId").toString());
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignUser result = this.electronicSignatureService.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/addSeal"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject addSeal(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        EleSignSeal params = new EleSignSeal();
        Enumeration str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = (String)str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, (Object)value);
            }
        }
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            SignAPI.initAPI((String)APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)requests);
            if (!isMultipart) {
                response.put("code", (Object)"E");
                response.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (requests instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)requests).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    fileName = filePart.getOriginalFilename();
                    InputStream inputStream = filePart.getInputStream();
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    filePath = Base64.getEncoder().encodeToString(bytes);
                }
            }
            param.put("imageData", filePath);
            response = this.electronicSignatureSeal.addSeal(param);
            params.setSealId(response.get((Object)"sealId").toString());
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
            params.setImageData(fileName);
            params.setUserId(param.getString("userId"));
            EleSignSeal eleSignSeal = this.electronicSignatureSeal.insertSelective(this.createRequestContext(requests), params);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        return response;
    }

    @RequestMapping(value={"/electronicSignature/deleteSeal"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject deleteSeal(HttpServletRequest requests, @RequestBody(required=false) EleSignSeal params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureSeal.deleteSeal(params);
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        int result = this.electronicSignatureSeal.deleteBySealId(params.getSealId());
        return response;
    }

    @RequestMapping(value={"/electronicSignature/alterSeal"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject alterSeal(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        EleSignSeal params = new EleSignSeal();
        Enumeration str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = (String)str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, (Object)value);
            }
        }
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            SignAPI.initAPI((String)APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)requests);
            if (!isMultipart) {
                response.put("code", (Object)"E");
                response.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (requests instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)requests).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    fileName = filePart.getOriginalFilename();
                    InputStream inputStream = filePart.getInputStream();
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    filePath = Base64.getEncoder().encodeToString(bytes);
                }
            }
            param.put("imageData", filePath);
            response = this.electronicSignatureSeal.alterSeal(param);
            params.setImageData(fileName);
            params.setUserId(param.getString("userId"));
            params.setSealId(param.getString("sealId"));
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        int result = this.electronicSignatureSeal.updateBySealId(params.getSealId(), params.getImageData());
        return response;
    }

    @RequestMapping(value={"/electronicSignature/querySeal"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject querySeal(HttpServletRequest requests, @RequestBody(required=false) EleSignSeal params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureSeal.querySeal(params);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        return response;
    }

    @RequestMapping(value={"/electronicSignature/postAuthCode"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject postAuthCode(HttpServletRequest requests, @RequestBody(required=false) EleSignAuth params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureAuth.postAuthCode(params);
            params.setTxId(response.getString("txId"));
            params.setResponseDesc(response.getString("ResponseDesc"));
            params.setResponseCode(response.getString("ResponseCode"));
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignAuth result = this.electronicSignatureAuth.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/verifyAuthCode"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject verifyAuthCode(HttpServletRequest requests, @RequestBody(required=false) EleSignAuth params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            response = this.electronicSignatureAuth.verifyAuthCode(params);
            params.setTxId(response.getString("txId"));
            params.setResponseDesc(response.getString("ResponseDesc"));
            params.setResponseCode(response.getString("ResponseCode"));
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignAuth result = this.electronicSignatureAuth.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/faceAuth"}, method={RequestMethod.POST})
    @Timed
    public JSONObject faceAuth(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        EleSignAuth params = new EleSignAuth();
        Enumeration str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = (String)str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, (Object)value);
            }
        }
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            SignAPI.initAPI((String)APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)requests);
            if (!isMultipart) {
                response.put("code", (Object)"E");
                response.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (requests instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)requests).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    fileName = filePart.getOriginalFilename();
                    InputStream inputStream = filePart.getInputStream();
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    filePath = Base64.getEncoder().encodeToString(bytes);
                }
            }
            param.put("selfieData", filePath);
            response = this.electronicSignatureAuth.faceAuth(param);
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
            params.setSelfieData(fileName);
            params.setSerialNumber(param.getString("serialNumber"));
            params.setUserId(param.getString("userId"));
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignAuth result = this.electronicSignatureAuth.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/createContractTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject createContractTemplate(HttpServletRequest requests, @RequestBody(required=false) EleSignContract params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureContract.createContractTemplate(params);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        return response;
    }

    @RequestMapping(value={"/electronicSignature/createContractFile"}, method={RequestMethod.POST})
    @Timed
    public JSONObject createContractFile(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        EleSignContract params = new EleSignContract();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        Enumeration str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = (String)str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, (Object)value);
            }
        }
        params.setContractType(param.getString("contractType"));
        params.setSerialNumber(param.getString("serialNumber"));
        params.setContractName(param.getString("contractName"));
        params.setKeyWord(param.getString("keyWord"));
        params.setSealId(param.getString("sealId"));
        params.setOffsetX(Integer.parseInt(param.getString("offsetX")));
        params.setOffsetY(Integer.parseInt(param.getString("offsetY")));
        params.setSealWith(Integer.parseInt(param.getString("sealWith")));
        params.setSealHeight(Integer.parseInt(param.getString("sealHeight")));
        params.setPlatformIsSignatory(Boolean.valueOf(param.getString("platformIsSignatory")));
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            SignAPI.initAPI((String)APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)requests);
            if (!isMultipart) {
                response.put("code", (Object)"E");
                response.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (requests instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)requests).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    fileName = filePart.getOriginalFilename();
                    InputStream inputStream = filePart.getInputStream();
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    filePath = Base64.getEncoder().encodeToString(bytes);
                }
            }
            params.setContractFile(filePath);
            response = this.electronicSignatureContract.createContractFile(params);
            params.setTxId(response.get((Object)"txId").toString());
            params.setContractId(response.get((Object)"contractId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
            params.setContractFile(fileName);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        this.electronicSignatureContract.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/downloadContract"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject downloadContract(HttpServletRequest requests, @RequestBody(required=false) EleSignContract params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureContract.downloadContract(params);
            params.setTxId(response.get((Object)"txId").toString());
            params.setContractFile(response.get((Object)"contractFile").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        this.electronicSignatureContract.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/userInfoQuery"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject userInfoQuery(HttpServletRequest requests, @RequestBody(required=false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureService.userInfoQuery(params);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        return response;
    }

    @RequestMapping(value={"/electronicSignature/alterUserInfo"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject alterUserInfo(HttpServletRequest requests, @RequestBody(required=false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureService.alterUserInfo(params);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        int res = this.electronicSignatureService.updateByUserId(params.getUserId(), params.getEmail(), params.getPhoneNumber());
        return response;
    }

    @RequestMapping(value={"/electronicSignature/bankVerified"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject bankVerified(HttpServletRequest requests, @RequestBody(required=false) EleSignVerify params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureVerify.bankVerified(params);
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setAuthResult(response.get((Object)"authResult").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignVerify result = this.electronicSignatureVerify.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/faceVerified"}, method={RequestMethod.POST})
    @Timed
    public JSONObject faceVerified(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        EleSignVerify params = new EleSignVerify();
        Enumeration str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = (String)str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, (Object)value);
            }
        }
        try {
            SignAPI.initAPI((String)APIConfigPath);
            boolean isMulti = ServletFileUpload.isMultipartContent((HttpServletRequest)requests);
            String[] fileName = new String[2];
            String[] filePath = new String[2];
            if (!isMulti) {
                response.put("code", (Object)"E");
                response.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (requests instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest)requests;
                Map fileMap = req.getFileMap();
                int i = 0;
                if (fileMap != null) {
                    for (Map.Entry next : fileMap.entrySet()) {
                        MultipartFile filePart = (MultipartFile)next.getValue();
                        fileName[i] = filePart.getOriginalFilename();
                        InputStream inputStream = filePart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                        filePath[i] = Base64.getEncoder().encodeToString(bytes);
                        ++i;
                    }
                }
            }
            param.put("identificationImage", (Object)filePath[0]);
            param.put("selfieData", (Object)filePath[1]);
            response = this.electronicSignatureVerify.faceVerified(param);
            params.setIdentificationImage(fileName[0]);
            params.setSelfieData(fileName[1]);
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setAuthResult(response.get((Object)"selfieVerifyCode").toString());
            params.setSelfieVerifyInfo(response.get((Object)"selfieVerifyInfo").toString());
            params.setSelfieCompareWithIdCode(response.get((Object)"selfieCompareWithIdCode").toString());
            params.setSelfieCompareWithIdInfo(response.get((Object)"selfieCompareWithIdInfo").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
            params.setPersonName(param.getString("personName"));
            params.setIdType(param.getString("idType"));
            params.setIdentificationNumber(param.getString("identificationNumber"));
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignVerify result = this.electronicSignatureVerify.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/getVerifyAddress"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject getVerifyAddress(HttpServletRequest requests, @RequestBody(required=false) EleSignVerify params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureVerify.getVerifyAddress(params);
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setUrl(response.get((Object)"url").toString());
            params.setBizToken(response.get((Object)"bizToken").toString());
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignVerify result = this.electronicSignatureVerify.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/getVerifyResult"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject getVerifyResult(HttpServletRequest requests, @RequestBody(required=false) EleSignVerify params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureVerify.getVerifyResult(params);
            params.setTxId(response.get((Object)"txId").toString());
            params.setResponseCode(response.get((Object)"ResponseCode").toString());
            params.setDetectInfo(response.getString("detectInfo"));
            params.setResponseDesc(response.get((Object)"ResponseDesc").toString());
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        EleSignVerify result = this.electronicSignatureVerify.insertSelective(this.createRequestContext(requests), params);
        return response;
    }

    @RequestMapping(value={"/electronicSignature/queryAuthCode"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject queryAuthCode(HttpServletRequest requests, @RequestBody(required=false) EleSignAuth params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureAuth.queryAuthCode(params);
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        return response;
    }

    @RequestMapping(value={"/electronicSignature/testEmpty"}, method={RequestMethod.POST})
    @Timed
    public JSONObject testEmpty(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI((String)APIConfigPath);
            response = this.electronicSignatureService.testEmpty();
        }
        catch (Exception e) {
            response.put("message", (Object)e);
        }
        return response;
    }
}

