/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.cmb.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.dto.HlsEbankCcbTransaction;
import com.chinapay.mapper.HlsEbankCcbTransactionMapper;
import com.chinapay.secss.LogUtil;
import com.chinapay.service.IHlsEbankCcbTransactionService;
import com.chinapay.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.app.cmb.dto.Ld037;
import com.hand.app.cmb.mapper.Ld037Mapper;
import com.hand.app.cmb.service.HclcCmbPolyService;
import com.hand.app.cmb.util.MD5Utils;
import com.hand.app.cmb.util.SM2Util;
import com.hand.app.cmb.util.SignatureUtil;
import com.hand.app.cmb.util.Utils;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HclcCmbPolyServiceImpl
implements HclcCmbPolyService {
    private static final String url = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply";
    private static final String closeUrl = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply";
    public static final String privateKey = "D5F2AFA24E6BA9071B54A8C9AD735F9A1DE9C4657FA386C09B592694BC118B38";
    public static final String publicKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE6Q+fktsnY9OFP+LpSR5Udbxf5zHCFO0PmOKlFNTxDIGl8jsPbbB/9ET23NV+acSz4FEkzD74sW2iiNVHRLiKHg==";
    public static final String appId = "8ab74856-8772-45c9-96db-54cb30ab9f74";
    public static final String appSecret = "5b96f20a-011f-4254-8be8-9a5ceb2f317f";
    public static final String getQrCode = "GET_QR_CODE";
    public static final String transNew = "NEW";
    public static final String transDeal = "DEAL";
    public static final String transFail = "FAIL";
    public static final String transClose = "CLOSED";
    public static final String cmbSuccess = "SUCCESS";
    public static final String cmbFail = "FAIL";
    @Value(value="${cmb.version}")
    private String version;
    @Value(value="${cmb.encoding}")
    private String encoding;
    @Value(value="${cmb.signMethod}")
    private String signMethod;
    @Value(value="${cmb.currencyCode}")
    private String currencyCode;
    @Autowired
    private HlsEbankCcbTransactionMapper hlsEbankCcbTransactionMapper;
    @Autowired
    private IHlsEbankCcbTransactionService hlsEbankCcbTransactionService;
    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private Ld037Mapper ld037Mapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public JSONObject getQrcode(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        String resultType = null;
        String errorCd = null;
        if (Objects.isNull(params.get((Object)"recamt_id"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570recamt_id\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = (Ld037)this.ld037Mapper.selectByPrimaryKey(ld037);
        if (Objects.nonNull(ld037.getReceiptstatus())) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        HlsEbankCcbTransaction hlsEbankCcbTransaction = this.createTransaction(iRequest, ld037);
        ld037.setTransactionId(hlsEbankCcbTransaction.getTransactionId());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(new Date());
        hlsEbankCcbTransaction.setTransactionNumber(dateString + String.format("%08d", hlsEbankCcbTransaction.getTransactionId()));
        String signResult = this.getQrRequestParams(hlsEbankCcbTransaction, ld037);
        if (Objects.isNull(signResult)) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u6536\u6b3e\u7801\u7533\u8bf7\u52a0\u7b7e\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        Map<String, String> response = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map signResultMap = (Map)mapper.readValue(signResult, Map.class);
            long currentTimeMills = System.currentTimeMillis() / 1000L;
            TreeMap<String, String> apiSign = new TreeMap<String, String>();
            apiSign.put("appid", appId);
            apiSign.put("secret", appSecret);
            apiSign.put("sign", (String)signResultMap.get("sign"));
            apiSign.put("timestamp", "" + currentTimeMills);
            String MD5Content = SignatureUtil.getSignContent(apiSign);
            String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();
            HashMap<String, String> apiHeader = new HashMap<String, String>();
            apiHeader.put("appid", appId);
            apiHeader.put("timestamp", "" + currentTimeMills);
            apiHeader.put("apisign", apiSignString);
            HlsWsRequests hlsWsRequests = this.logInterfaceRequest(getQrCode, "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply", mapper.writeValueAsString(apiHeader), hlsEbankCcbTransaction.getTransactionId());
            this.logger.info("\u53d1\u9001\u6536\u6b3e\u7801\u7533\u8bf7\u8bf7\u6c42,\u8bf7\u6c42\u53c2\u6570: {}", (Object)mapper.writeValueAsString(apiHeader));
            try {
                response = Utils.postForEntity("https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply", signResult, apiHeader);
                this.logger.info("\u6536\u6b3e\u7801\u7533\u8bf7\u8fd4\u56de\u7ed3\u679c\uff1a" + mapper.writeValueAsString(response));
                hlsWsRequests.setResponseClob(mapper.writeValueAsString(response));
                hlsWsRequests.setReturnStatus("S");
                hlsWsRequests.setResponsedDate(new Date());
                Boolean checkResult1 = this.checkSign(mapper.writeValueAsString(response));
                if (checkResult1.booleanValue()) {
                    String respCode;
                    String returnCode = response.get("returnCode");
                    resultType = cmbSuccess.equalsIgnoreCase(returnCode) ? (cmbSuccess.equalsIgnoreCase(respCode = response.get("returnCode")) ? "1" : "2") : "3";
                    if (!"1".equalsIgnoreCase(resultType)) {
                        errorCd = response.get("errCode");
                    }
                } else {
                    errorCd = "SIGN_ERROR";
                    resultType = "4";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38: {} ", (Object)e.getMessage());
                errorCd = "SEND_ERROR";
                hlsWsRequests.setReturnStatus("E");
                hlsWsRequests.setResponsedDate(new Date());
                hlsEbankCcbTransaction.setReturnMsg(e.getMessage());
                result.put("respMsg", (Object)("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage()));
                resultType = "5";
            }
            this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u4fe1\u606f\u5931\u8d25: {} ", (Object)e.getMessage());
            hlsEbankCcbTransaction.setReturnMsg("\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            result.put("respMsg", (Object)("\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u4fe1\u606f\u5931\u8d25:" + e.getMessage()));
            errorCd = "MESSAGE_ERROR";
            resultType = "5";
        }
        hlsEbankCcbTransaction = this.setEbankTransaction(hlsEbankCcbTransaction, response, resultType);
        this.hlsEbankCcbTransactionMapper.updateByPrimaryKey(hlsEbankCcbTransaction);
        if (Objects.nonNull(errorCd)) {
            this.updateLd037Fail(ld037, errorCd);
        } else {
            this.ld037Mapper.updateByPrimaryKeySelective(ld037);
        }
        result = this.putResult(result, response, resultType);
        return result;
    }

    private JSONObject putResult(JSONObject result, Map<String, String> response, String type) {
        if ("1".equalsIgnoreCase(type)) {
            JSONObject bizContent = new JSONObject();
            bizContent = JSONObject.parseObject((String)response.get("biz_content").toString());
            result.put("respCode", (Object)response.get("returnCode"));
            result.put("respMsg", (Object)"\u8bf7\u6c42\u6210\u529f");
            result.put("qrcode", (Object)bizContent.getString("qrCode").replace("https://qr.95516.com/", "http://payment-uat.cs.cmburl.cn/"));
            result.put("cmborderid", (Object)bizContent.getString("cmbOrderId"));
            result.put("txnTime", (Object)bizContent.getString("txnTime"));
        } else if ("2".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)response.get("errCode"));
            result.put("respMsg", (Object)response.get("respMsg"));
        } else if ("3".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)response.get("errCode"));
            result.put("respMsg", (Object)response.get("respMsg"));
        } else if ("4".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)"FAIL");
            result.put("respMsg", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else if ("5".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)"FAIL");
        }
        return result;
    }

    private HlsEbankCcbTransaction setEbankTransaction(HlsEbankCcbTransaction hlsEbankCcbTransaction, Map<String, String> response, String type) {
        if ("1".equalsIgnoreCase(type)) {
            JSONObject bizContent = new JSONObject();
            bizContent = JSONObject.parseObject((String)response.get("biz_content").toString());
            hlsEbankCcbTransaction.setStatus(transDeal);
            hlsEbankCcbTransaction.setReturnCode(response.get("returnCode"));
            hlsEbankCcbTransaction.setReturnMsg("\u83b7\u53d6\u4e8c\u7ef4\u7801\u6210\u529f");
            hlsEbankCcbTransaction.setQrCode(bizContent.getString("qrCode"));
            hlsEbankCcbTransaction.setCmbOrderId(bizContent.getString("cmbOrderId"));
            hlsEbankCcbTransaction.setTxnTime(bizContent.getString("txnTime"));
            hlsEbankCcbTransaction.setOrderStatus("0000");
        } else if ("2".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus("FAIL");
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0000");
        } else if ("3".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus("FAIL");
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0003");
        } else if ("4".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus("FAIL");
            hlsEbankCcbTransaction.setReturnCode("SIGN_ERROR");
            hlsEbankCcbTransaction.setReturnMsg("\u63a5\u53e3\u8bf7\u6c42\u9a8c\u7b7e\u5931\u8d25");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        } else if ("5".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus("FAIL");
            hlsEbankCcbTransaction.setReturnCode("SEND_ERROR");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        return hlsEbankCcbTransaction;
    }

    private void updateLd037Fail(Ld037 ld037, String errorCd) {
        ld037.setErrorcd(errorCd);
        this.ld037Mapper.updateLd037Fail(ld037);
    }

    private HlsEbankCcbTransaction createTransaction(IRequest iRequest, Ld037 ld037) {
        HlsEbankCcbTransaction ccbTransaction = new HlsEbankCcbTransaction();
        ccbTransaction.setMerId("3089991701201D0");
        ccbTransaction.setVersion("0.0.1");
        ccbTransaction.setUserId("N003574551");
        ccbTransaction.setStatus(transNew);
        ccbTransaction.setBankType("CMB");
        ccbTransaction.setCount(1L);
        ccbTransaction.setAmount(ld037.getAmount());
        ccbTransaction.setNewDate(new Date());
        ccbTransaction.setCreatedBy(1L);
        ccbTransaction.setCreationDate(new Date());
        ccbTransaction.setLastUpdatedBy(1L);
        ccbTransaction.setTranDate(StringUtil.getRelevantDate(new Date()));
        ccbTransaction.setTranTime(StringUtil.getRelevantTime(new Date()));
        ccbTransaction.setTranType("APPLY");
        this.hlsEbankCcbTransactionMapper.insert(ccbTransaction);
        return (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(ccbTransaction);
    }

    private String getQrRequestParams(HlsEbankCcbTransaction hlsEbankCcbTransaction, Ld037 ld037) {
        TreeMap<String, String> requestPublicParams = new TreeMap<String, String>();
        String requestStr = null;
        try {
            requestPublicParams.put("version", this.version);
            requestPublicParams.put("encoding", this.encoding);
            requestPublicParams.put("signMethod", this.signMethod);
            HashMap<String, String> requestTransactionParams = new HashMap<String, String>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());
            requestTransactionParams.put("orderId", hlsEbankCcbTransaction.getTransactionNumber());
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());
            requestTransactionParams.put("payValidTime", "900");
            requestTransactionParams.put("notifyUrl", "http://sign.hitachics.com/core/api/public/cmb/get/qr/code/listen");
            requestTransactionParams.put("mchReserved", ld037.getId().toString());
            BigDecimal a1 = new BigDecimal(Double.toString(hlsEbankCcbTransaction.getAmount()));
            BigDecimal b1 = new BigDecimal(Double.toString(100.0));
            requestTransactionParams.put("txnAmt", a1.multiply(b1).stripTrailingZeros().toPlainString());
            requestTransactionParams.put("currencyCode", this.currencyCode);
            JSONObject mchReserved = new JSONObject();
            mchReserved.put("transactionId", (Object)hlsEbankCcbTransaction.getTransactionId());
            requestTransactionParams.put("tradeScene", "OFFLINE");
            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));
            this.logger.info("\u6536\u6b3e\u7801\u7533\u8bf7\u52a0\u7b7e\u524d\u7684\u62a5\u6587\u5185\u5bb9:" + mapper.writeValueAsString(requestPublicParams));
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, privateKey));
            requestStr = mapper.writeValueAsString(requestPublicParams);
            this.logger.info("\u6536\u6b3e\u7801\u7533\u8bf7\u52a0\u7b7e\u540e\u7684\u62a5\u6587\u5185\u5bb9\uff1a" + requestStr);
            return requestStr;
        }
        catch (Exception e) {
            this.logger.info("\u6536\u6b3e\u7801\u7533\u8bf7\u52a0\u7b7e\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return requestStr;
        }
    }

    private Boolean checkSign(String string) {
        System.out.println("\u8981\u9a8c\u7b7e\u7684\u62a5\u6587\u5185\u5bb9\uff1a" + string);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map responseBodyMap = (Map)objectMapper.readValue(string, Map.class);
            String sign = (String)responseBodyMap.remove("sign");
            String contentStr = SignatureUtil.getSignContent(responseBodyMap);
            boolean result = SM2Util.sm2Check(contentStr, sign, publicKey);
            if (result) {
                System.out.println("\u62a5\u6587\u9a8c\u7b7e\u6210\u529f!");
            } else {
                System.out.println("\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25!");
            }
            return result;
        }
        catch (Exception e) {
            System.out.println("\u9a8c\u7b7e\u53d1\u751f\u5f02\u5e38\uff01");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProp(String propPath) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(propPath);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (Exception var13) {
            LogUtil.writeErrorLog((String)"\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)var13);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public HlsWsRequests logInterfaceRequest(String functionName, String url, String request, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName(functionName);
        String tableName = this.getTableName(functionName);
        hlsWsRequests.setTableName(tableName);
        hlsWsRequests.setStatusCode("1");
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setPkValue(pkValue);
        hlsWsRequests.setRequestClob(request);
        this.hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    private String getTableName(String functionName) {
        String tableName = "";
        if (getQrCode.equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CCB_TRANSACTION";
        } else if ("QUERY_PAY_RESULT".equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CMB_QUERY";
        }
        return tableName;
    }

    @Override
    public JSONObject queryOrderStatus(IRequest iRequest, JSONObject params) {
        String respCode;
        String resultType = null;
        JSONObject result = new JSONObject();
        String url = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/orderquery";
        if (Objects.isNull(params.get((Object)"recamt_id"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570recamt_id\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = (Ld037)this.ld037Mapper.selectByPrimaryKey(ld037);
        HlsEbankCcbTransaction hlsEbankCcbTransaction = (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
        String signResult = HclcCmbPolyServiceImpl.getOrderQueryParameter(hlsEbankCcbTransaction);
        if (hlsEbankCcbTransaction.getOrderStatus().equals(cmbSuccess)) {
            result.put("respCode", (Object)hlsEbankCcbTransaction.getReturnCode());
            result.put("respMsg", (Object)hlsEbankCcbTransaction.getReturnMsg());
            result.put("tradeState", (Object)hlsEbankCcbTransaction.getOrderStatus());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        Map signResultMap = null;
        try {
            signResultMap = (Map)mapper.readValue(signResult, Map.class);
        }
        catch (IOException e) {
            resultType = "5";
            e.printStackTrace();
        }
        long currentTimeMills = System.currentTimeMillis() / 1000L;
        TreeMap<String, String> apiSign = new TreeMap<String, String>();
        apiSign.put("appid", appId);
        apiSign.put("secret", appSecret);
        apiSign.put("sign", (String)signResultMap.get("sign"));
        apiSign.put("timestamp", "" + currentTimeMills);
        String MD5Content = SignatureUtil.getSignContent(apiSign);
        String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();
        HashMap<String, String> apiHeader = new HashMap<String, String>();
        apiHeader.put("appid", appId);
        apiHeader.put("timestamp", "" + currentTimeMills);
        apiHeader.put("apisign", apiSignString);
        Map<String, String> responseMap = Utils.postForEntity("https://api.cmburl.cn:8065/polypay/v1.0/mchorders/orderquery", signResult, apiHeader);
        if (null == responseMap) {
            resultType = "3";
            this.logger.info("\u54cd\u5e94\u7684\u5185\u5bb9\u4e3a\u7a7a");
            return result;
        }
        Boolean checkResponse = null;
        try {
            checkResponse = this.checkSign(mapper.writeValueAsString(responseMap));
        }
        catch (JsonProcessingException e) {
            resultType = "4";
            e.printStackTrace();
        }
        String returnCode = responseMap.get("returnCode");
        resultType = cmbSuccess.equalsIgnoreCase(returnCode) ? (cmbSuccess.equalsIgnoreCase(respCode = responseMap.get("returnCode")) ? "1" : "2") : "3";
        if (!"1".equalsIgnoreCase(resultType)) {
            this.updateLd037Fail(ld037, responseMap.get("errCode"));
        } else {
            this.updateLd037Fail(ld037, "SIGN_ERROR");
            resultType = "4";
        }
        hlsEbankCcbTransaction = this.setEbankTransactionQR(hlsEbankCcbTransaction, responseMap, resultType);
        this.hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);
        result = this.putResult(result, responseMap, resultType);
        return result;
    }

    private static String getOrderQueryParameter(HlsEbankCcbTransaction hlsEbankCcbTransaction) {
        TreeMap<String, String> requestPublicParams = new TreeMap<String, String>();
        String requestStr = null;
        try {
            requestPublicParams.put("version", "0.0.1");
            requestPublicParams.put("encoding", "UTF-8");
            requestPublicParams.put("signMethod", "02");
            HashMap<String, String> requestTransactionParams = new HashMap<String, String>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());
            requestTransactionParams.put("orderId", hlsEbankCcbTransaction.getTransactionNumber());
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());
            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));
            requestTransactionParams.put("origOrderId", hlsEbankCcbTransaction.getTransactionNumber());
            System.out.println("\u52a0\u7b7e\u524d\u7684\u62a5\u6587\u5185\u5bb9\uff1a" + mapper.writeValueAsString(requestPublicParams));
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, privateKey));
            requestStr = mapper.writeValueAsString(requestPublicParams);
            System.out.println("\u52a0\u7b7e\u540e\u7684\u62a5\u6587\u5185\u5bb9\uff1a" + requestStr);
            return requestStr;
        }
        catch (Exception e) {
            System.out.println("\u52a0\u7b7e\u53d1\u751f\u5f02\u5e38\uff01");
            e.printStackTrace();
            return requestStr;
        }
    }

    private HlsEbankCcbTransaction setEbankTransactionQR(HlsEbankCcbTransaction hlsEbankCcbTransaction, Map<String, String> response, String type) {
        if ("1".equalsIgnoreCase(type)) {
            if (response.get("tradeState").equalsIgnoreCase("P")) {
                hlsEbankCcbTransaction.setStatus(transDeal);
                hlsEbankCcbTransaction.setOrderStatus("P");
            } else if (response.get("tradeState").equalsIgnoreCase("S")) {
                hlsEbankCcbTransaction.setStatus(cmbSuccess);
                hlsEbankCcbTransaction.setOrderStatus("S");
            } else if (response.get("tradeState").equalsIgnoreCase("C")) {
                hlsEbankCcbTransaction.setStatus(transClose);
                hlsEbankCcbTransaction.setOrderStatus("C");
            } else if (response.get("tradeState").equalsIgnoreCase("F")) {
                hlsEbankCcbTransaction.setStatus("FAIL");
                hlsEbankCcbTransaction.setOrderStatus("F");
            }
        } else if ("2".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0000");
        } else if ("3".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0003");
        } else if ("4".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode("SIGN_ERROR");
            hlsEbankCcbTransaction.setReturnMsg("\u63a5\u53e3\u8bf7\u6c42\u9a8c\u7b7e\u5931\u8d25");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        } else if ("5".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode("SEND_ERROR");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        return hlsEbankCcbTransaction;
    }

    private JSONObject putResultQR(JSONObject result, Map<String, String> response, String type) {
        if ("1".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)response.get("returnCode"));
            result.put("respMsg", (Object)"\u8bf7\u6c42\u6210\u529f");
            result.put("orderId", (Object)response.get("orderId"));
            result.put("cmbOrderId", (Object)response.get("cmbOrderId"));
            result.put("tradeState", (Object)response.get("tradeState"));
            result.put("txnTime", (Object)response.get("txnTime"));
        } else if ("2".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)response.get("errCode"));
            result.put("respMsg", (Object)response.get("respMsg"));
        } else if ("3".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)response.get("errCode"));
            result.put("respMsg", (Object)response.get("respMsg"));
        } else if ("4".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)"FAIL");
            result.put("respMsg", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else if ("5".equalsIgnoreCase(type)) {
            result.put("respCode", (Object)"FAIL");
        }
        return result;
    }

    @Override
    public Map<String, String> orderNotify(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        System.out.println(params);
        String requestBodyString = params.toJSONString();
        HashMap<String, String> respData = new HashMap<String, String>();
        respData.put("version", "0.0.1");
        respData.put("encoding", "UTF-8");
        respData.put("signMethod", "02");
        try {
            respData.put("returnCode", cmbSuccess);
            if (requestBodyString == null || "".equals(requestBodyString.trim())) {
                respData.put("returnCode", "FAIL");
                return respData;
            }
            Map<String, String> requestBodyMap = this.str2Map(requestBodyString);
            Map<String, String> resultMap = requestBodyMap.entrySet().stream().collect(Collectors.toMap(e -> SignatureUtil.decode((String)e.getKey()), e -> SignatureUtil.decode((String)e.getValue())));
            if (resultMap == null) {
                respData.put("returnCode", "FAIL");
                return respData;
            }
            String sign = resultMap.remove("sign");
            String contentStr = SignatureUtil.getSignContent(resultMap);
            boolean flag = SM2Util.sm2Check(contentStr, sign, publicKey);
            if (!flag) {
                System.out.println("\u9a8c\u7b7e\u5931\u8d25");
                respData.put("returnCode", "FAIL");
                return respData;
            }
            System.out.println("\u9a8c\u7b7e\u6210\u529f");
            Long recamtId = params.getLong("mchReserved");
            Ld037 ld037 = new Ld037();
            ld037.setId(recamtId);
            ld037 = (Ld037)this.ld037Mapper.selectByPrimaryKey(ld037);
            HlsEbankCcbTransaction hlsEbankCcbTransaction = (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
            hlsEbankCcbTransaction.setStatus(cmbSuccess);
            hlsEbankCcbTransaction.setOrderStatus("S");
            this.hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);
            respData.put("respCode", cmbSuccess);
            String signContent = SignatureUtil.getSignContent(respData);
            respData.put("sign", SM2Util.sm2Sign(signContent, privateKey));
            System.out.println("\u52a0\u7b7e\u6210\u529f");
            return respData;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            respData.put("returnCode", "FAIL");
            return respData;
        }
    }

    @Override
    public JSONObject closeOrder(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get((Object)"recamt_id"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570recamt_id\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = (Ld037)this.ld037Mapper.selectByPrimaryKey(ld037);
        HlsEbankCcbTransaction hlsEbankCcbTransaction = (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
        if (cmbSuccess.equalsIgnoreCase(hlsEbankCcbTransaction.getStatus())) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff01");
            return result;
        }
        String signResult = HclcCmbPolyServiceImpl.getOrderQueryParameter(hlsEbankCcbTransaction);
        ObjectMapper mapper = new ObjectMapper();
        Map signResultMap = null;
        try {
            signResultMap = (Map)mapper.readValue(signResult, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long currentTimeMills = System.currentTimeMillis() / 1000L;
        TreeMap<String, String> apiSign = new TreeMap<String, String>();
        apiSign.put("appid", appId);
        apiSign.put("secret", appSecret);
        apiSign.put("sign", (String)signResultMap.get("sign"));
        apiSign.put("timestamp", "" + currentTimeMills);
        String MD5Content = SignatureUtil.getSignContent(apiSign);
        String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();
        HashMap<String, String> apiHeader = new HashMap<String, String>();
        apiHeader.put("appid", appId);
        apiHeader.put("timestamp", "" + currentTimeMills);
        apiHeader.put("apisign", apiSignString);
        Map<String, String> responseMap = Utils.postForEntity("https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply", signResult, apiHeader);
        Boolean checkResponse = null;
        try {
            checkResponse = this.checkSign(mapper.writeValueAsString(responseMap));
        }
        catch (JsonProcessingException e) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u6570\u636e\u9a8c\u7b7e\u5931\u8d25");
            e.printStackTrace();
        }
        String returnCode = responseMap.get("returnCode");
        if (cmbSuccess.equalsIgnoreCase(returnCode)) {
            String respCode = responseMap.get("returnCode");
            if ("ORDER_PAID".equalsIgnoreCase(respCode)) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u9700\u8981\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\uff01");
                return result;
            }
            if (cmbSuccess.equalsIgnoreCase(respCode)) {
                if ("C".equalsIgnoreCase(responseMap.get("closeState"))) {
                    hlsEbankCcbTransaction.setStatus(transClose);
                    hlsEbankCcbTransaction.setOrderStatus("C");
                    result.put("respCode", (Object)responseMap.get("respCode"));
                    result.put("respMsg", (Object)"\u8bf7\u6c42\u6210\u529f");
                    result.put("cmborderid", (Object)responseMap.get("origOrderId"));
                    result.put("closeState", (Object)responseMap.get("closeState"));
                    result.put("txnTime", (Object)responseMap.get("txnTime"));
                } else {
                    hlsEbankCcbTransaction.setOrderStatus("F");
                    result.put("respCode", (Object)responseMap.get("respCode"));
                    result.put("respMsg", (Object)"\u8bf7\u6c42\u6210\u529f");
                    result.put("cmborderid", (Object)responseMap.get("origOrderId"));
                    result.put("closeState", (Object)responseMap.get("closeState"));
                    result.put("txnTime", (Object)responseMap.get("txnTime"));
                }
            } else if ("SYSTERM_ERROR".equalsIgnoreCase(respCode)) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u9700\u8981\u91cd\u65b0\u8c03\u7528\u67e5\u8be2\u63a5\u53e3\uff01");
            } else if ("FAIL".equalsIgnoreCase(respCode)) {
                result.put("errCode", (Object)responseMap.get("errCode"));
                result.put("respMsg", (Object)responseMap.get("respMsg"));
            }
        } else {
            result.put("errCode", (Object)responseMap.get("errCode"));
            result.put("respMsg", (Object)responseMap.get("respMsg"));
        }
        this.hlsEbankCcbTransactionMapper.updateByPrimaryKey(hlsEbankCcbTransaction);
        return result;
    }

    private Map<String, String> str2Map(String str) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] results = str.split("&");
        if (results != null && results.length > 0) {
            for (int var = 0; var < results.length; ++var) {
                String pair = results[var];
                String[] kv = pair.split("=", 2);
                if (kv == null || kv.length != 2) continue;
                result.put(kv[0], kv[1]);
            }
        }
        return result;
    }
}

