/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppRoleModule;
import com.hand.app.appManger.service.IAppRoleModuleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class AppRoleModuleController
extends BaseController {
    @Autowired
    private IAppRoleModuleService appRoleModule;

    @RequestMapping(value={"/app/query/RoleModule"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryRoleModule(HttpServletRequest request, @RequestParam(value="roleId") String roleId) {
        return this.appRoleModule.selectRoleModule(this.createRequestContext(request), roleId);
    }

    @RequestMapping(value={"/app/queryRoleAllModule"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryRoleAllModule(HttpServletRequest request, @RequestParam(value="roleId") String roleId) {
        return this.appRoleModule.selectRoleAllModule(this.createRequestContext(request), roleId);
    }

    @RequestMapping(value={"/app/addRoleModule"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public ResponseData addRoleModule(HttpServletRequest request, @RequestBody List<AppRoleModule> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.appRoleModule.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/app/deleteRoleModule"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public int deleteRoleModule(HttpServletRequest request, @RequestBody List<AppRoleModule> roleModule) {
        return this.appRoleModule.batchDelete(roleModule);
    }
}

