/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.hand.app.appManger.dto.AppModule;
import com.hand.app.appManger.service.IAppModuleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app/module"})
public class AppModuleController
extends BaseController {
    @Autowired
    private IAppModuleService appModuleService;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(AppModule dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.appModuleService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData addModule(HttpServletRequest request, @RequestBody List<AppModule> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.appModuleService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public int deleteAppModule(HttpServletRequest request, @RequestBody List<AppModule> appModule) {
        return this.appModuleService.batchDelete(appModule);
    }
}

