/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppHomePicture;
import com.hand.app.appManger.service.IAppHomePictureService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class AppHomePictureController
extends BaseController {
    @Autowired
    private IAppHomePictureService appHomeService;

    @RequestMapping(value={"/app/addHomePicture"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public ResponseData addPicture(HttpServletRequest request, @RequestBody List<AppHomePicture> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.appHomeService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/app/deleteHomePicture"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public int deletePicture(HttpServletRequest request, @RequestBody List<AppHomePicture> picture) {
        return this.appHomeService.batchDelete(picture);
    }

    @RequestMapping(value={"/app/queryAll"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryAllPicture(AppHomePicture dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.appHomeService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/app/queryHomePicture"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryHomePicture(HttpServletRequest request, @RequestParam(value="appCode") String appCode) {
        return this.appHomeService.getHomePicture(this.createRequestContext(request), appCode);
    }
}

