/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.github.pagehelper.StringUtil;
import com.hand.app.appManger.bean.SmsInfo;
import com.hand.app.appManger.service.ICaptchaCodeService;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api"})
public class AppCaptchaController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(AppCaptchaController.class);
    @Autowired
    ICaptchaCodeService captchaCodeService;
    @Resource(name="restBean")
    IHapApiService restService;
    @Autowired
    IHapInterfaceHeaderService headerService;

    @ResponseBody
    @Timed
    @RequestMapping(value={"/aliyun/sms"}, method={RequestMethod.POST})
    public JSONObject sentAliyunMsm(HttpServletRequest request, @RequestBody SmsInfo smsInfo) {
        JSONObject json = new JSONObject();
        try {
            json = this.captchaCodeService.sendAliyunSms(this.createRequestContext(request), smsInfo);
        }
        catch (Exception e) {
            this.logger.error("something error!", (Throwable)e);
            json.put("result", (Object)"E");
            json.put("message", (Object)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        return json;
    }

    @ResponseBody
    @Timed
    @RequestMapping(value={"/captcha/do"}, method={RequestMethod.POST})
    public JSONObject captchaDo(HttpServletRequest request, @RequestBody(required=false) JSONObject params) throws Exception {
        JSONObject json = new JSONObject();
        String captchaCode = request.getParameter("captchaCode");
        String captchaKey = request.getParameter("captchaKey");
        if (StringUtils.isEmpty((String)captchaCode) || StringUtil.isEmpty(captchaKey) || !this.captchaCodeService.checkCaptcha(captchaKey, captchaCode).booleanValue()) {
            json.put("result", (Object)"E");
            json.put("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        } else {
            String sysName = request.getParameter("sysName");
            String apiName = request.getParameter("apiName");
            this.logger.info("sysName:{}  apiName:{} ", (Object)sysName, (Object)apiName);
            this.logger.info("requestBody:{}", (Object)params);
            HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
            this.logger.info("return HmsInterfaceHeader:{}", (Object)hapInterfaceHeader);
            if (hapInterfaceHeader.getInterfaceType().equals("REST")) {
                json = this.restService.invoke(hapInterfaceHeader, params);
            }
        }
        return json;
    }
}

