/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.sqlsource;

import com.github.pagehelper.Constant;
import com.github.pagehelper.parser.Parser;
import com.github.pagehelper.sqlsource.OrderByStaticSqlSource;
import com.github.pagehelper.sqlsource.PageSqlSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class PageProviderSqlSource
extends PageSqlSource
implements Constant {
    private SqlSourceBuilder sqlSourceParser;
    private Class<?> providerType;
    private Method providerMethod;
    private Boolean providerTakesParameterObject;
    private String[] providerMethodArgumentNames;
    private Configuration configuration;

    public PageProviderSqlSource(ProviderSqlSource provider) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)provider);
        this.sqlSourceParser = (SqlSourceBuilder)metaObject.getValue("sqlSourceParser");
        this.providerType = (Class)metaObject.getValue("providerType");
        this.providerMethod = (Method)metaObject.getValue("providerMethod");
        this.configuration = (Configuration)metaObject.getValue("sqlSourceParser.configuration");
        try {
            this.providerTakesParameterObject = (Boolean)metaObject.getValue("providerTakesParameterObject");
        }
        catch (ReflectionException e) {
            this.providerMethodArgumentNames = (String[])metaObject.getValue("providerMethodArgumentNames");
        }
    }

    private SqlSource createSqlSource(Object parameterObject) {
        if (this.providerTakesParameterObject != null) {
            return this.createSqlSource331(parameterObject);
        }
        return this.createSqlSource340(parameterObject);
    }

    private SqlSource createSqlSource331(Object parameterObject) {
        try {
            String sql = this.providerTakesParameterObject != false ? (String)this.providerMethod.invoke(this.providerType.newInstance(), parameterObject) : (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            StaticSqlSource sqlSource = (StaticSqlSource)this.sqlSourceParser.parse(sql, parameterType, new HashMap());
            return new OrderByStaticSqlSource(sqlSource);
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, (Throwable)e);
        }
    }

    private SqlSource createSqlSource340(Object parameterObject) {
        try {
            String sql;
            Class<?>[] parameterTypes = this.providerMethod.getParameterTypes();
            if (parameterTypes.length == 0) {
                sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
            } else if (parameterTypes.length == 1 && (parameterObject == null || parameterTypes[0].isAssignableFrom(parameterObject.getClass()))) {
                sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), parameterObject);
            } else if (parameterObject instanceof Map) {
                Map params = (Map)parameterObject;
                sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), this.extractProviderMethodArguments(params, this.providerMethodArgumentNames));
            } else {
                throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + "). Cannot invoke a method that holds " + (parameterTypes.length == 1 ? "named argument(@Param)" : "multiple arguments") + " using a specifying parameterObject. In this case, please specify a 'java.util.Map' object.");
            }
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            StaticSqlSource sqlSource = (StaticSqlSource)this.sqlSourceParser.parse(sql, parameterType, new HashMap());
            return new OrderByStaticSqlSource(sqlSource);
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, (Throwable)e);
        }
    }

    private Object[] extractProviderMethodArguments(Map<String, Object> params, String[] argumentNames) {
        Object[] args = new Object[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = params.get(argumentNames[i]);
        }
        return args;
    }

    @Override
    protected BoundSql getDefaultBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    @Override
    protected BoundSql getCountBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new BoundSql(this.configuration, ((Parser)localParser.get()).getCountSql(boundSql.getSql()), boundSql.getParameterMappings(), parameterObject);
    }

    @Override
    protected BoundSql getPageBoundSql(Object parameterObject) {
        BoundSql boundSql;
        if (parameterObject instanceof Map && ((Map)parameterObject).containsKey("_provider_object")) {
            SqlSource sqlSource = this.createSqlSource(((Map)parameterObject).get("_provider_object"));
            boundSql = sqlSource.getBoundSql(((Map)parameterObject).get("_provider_object"));
        } else {
            SqlSource sqlSource = this.createSqlSource(parameterObject);
            boundSql = sqlSource.getBoundSql(parameterObject);
        }
        return new BoundSql(this.configuration, ((Parser)localParser.get()).getPageSql(boundSql.getSql()), ((Parser)localParser.get()).getPageParameterMapping(this.configuration, boundSql), parameterObject);
    }
}

