/*
 * Decompiled with CFR 0.152.
 */
package com.chinapay.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.dto.HclcCupSignInfo;
import com.chinapay.dto.HlsEbankCcbTransaction;
import com.chinapay.dto.HlsWsConfig;
import com.chinapay.mapper.HclcCupSignInfoMapper;
import com.chinapay.mapper.HlsEbankCcbTransactionMapper;
import com.chinapay.mapper.HlsWsConfigMapper;
import com.chinapay.secss.SecssConstants;
import com.chinapay.secss.SecssUtil;
import com.chinapay.service.IHclcChinaPayService;
import com.chinapay.util.HttpUtils;
import com.chinapay.util.StringUtil;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HclcChinaPayServiceImpl
extends BaseServiceImpl<HclcCupSignInfo>
implements IHclcChinaPayService {
    @Autowired
    IHapInterfaceHeaderService headerService;
    public static final String sendNew = "SEND_NEW";
    public static final String sendSuccess = "SEND_SUCCESS";
    public static final String sendFail = "SEND_FAIL";
    public static final String signFail = "SING_FAIL";
    public static final String signSuccess = "SING_SUCCESS";
    public static final String cupSendMessage = "CUP_SEND_MESSAGE";
    public static final String cupSignSend = "CUP_SIGN_SEND";
    public static final String cupBatchUpload = "CUP_BATCH_UPLOAD";
    public static final String cupBatchQuery = "CUP_BATCH_QUERY";
    public static final String cupBatchDownload = "CUP_BATCH_DOWNLOAD";
    public static final String transNew = "NEW";
    public static final String transDeal = "DEAL";
    public static final String transSuccess = "SUCCESS";
    public static final String transFail = "FAIL";
    @Value(value="${cup.mer.id}")
    private String cupMerId;
    @Value(value="${cup.upload.file.path}")
    private String cupUploadFilePath;
    @Value(value="${cup.download.file.path}")
    private String cupDownloadFilePath;
    @Value(value="${cup.init.file.path}")
    private String cupInitFilePath;
    @Autowired
    private HclcCupSignInfoMapper hclcCupSignInfoMapper;
    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private HlsWsConfigMapper hlsWsConfigMapper;
    @Autowired
    private HlsEbankCcbTransactionMapper hlsEbankCcbTransactionMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private HclcCupSignInfo createCupSignInfo(IRequest iRequest, JSONObject cardTranDataJson) {
        HclcCupSignInfo hclcCupSignInfo = new HclcCupSignInfo();
        Map additionMapFromJSON = (Map)JSONObject.parseObject((String)cardTranDataJson.toJSONString(), Map.class);
        StringUtil.setFieldValue4Bean(hclcCupSignInfo, additionMapFromJSON);
        hclcCupSignInfo.setStatus(sendNew);
        this.hclcCupSignInfoMapper.insertSelective(hclcCupSignInfo);
        return hclcCupSignInfo;
    }

    @Override
    public JSONObject sendSignMessage(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("Version", "20140728");
        sendMap.put("AccessType", "0");
        sendMap.put("MerId", this.cupMerId);
        String merOrderNo = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        sendMap.put("MerOrderNo", merOrderNo);
        sendMap.put("TranDate", StringUtil.getRelevantDate(new Date()));
        sendMap.put("TranTime", StringUtil.getRelevantTime(new Date()));
        sendMap.put("BusiType", "0001");
        sendMap.put("TranType", "0608");
        String ownerId = this.cupMerId;
        SecssUtil secssUtil = this.getSecssUtil(ownerId);
        JSONObject cardTranDataJson = new JSONObject();
        cardTranDataJson.put("CardNo", (Object)params.getString("card_no").replace(" ", ""));
        cardTranDataJson.put("AccName", (Object)params.getString("acc_name").replace(" ", ""));
        cardTranDataJson.put("CertType", (Object)"01");
        cardTranDataJson.put("CertNo", (Object)params.getString("cert_no").replace(" ", ""));
        cardTranDataJson.put("MobileNo", (Object)params.getString("mobile_no").replace(" ", ""));
        cardTranDataJson.put("EntrstAuthNo", (Object)params.getString("cert_no").replace(" ", ""));
        cardTranDataJson.put("EntrstAmtLmt", (Object)"50000000");
        Date strDtT = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(strDtT);
        calendar.add(5, -1);
        strDtT = calendar.getTime();
        cardTranDataJson.put("EntrstStrDtTm", (Object)StringUtil.getEntrstStrDtT(strDtT));
        cardTranDataJson.put("EntrstEndDtTm", (Object)StringUtil.yearAddNum(strDtT, 10));
        cardTranDataJson.put("EntrstDtUnt", (Object)"07");
        cardTranDataJson.put("EntrstDtStp", (Object)"9999");
        this.logger.info("send sign message start!");
        HclcCupSignInfo hclcCupSignInfo = new HclcCupSignInfo();
        hclcCupSignInfo = this.createCupSignInfo(iRequest, cardTranDataJson);
        hclcCupSignInfo.setMerOrderNo(merOrderNo);
        hclcCupSignInfo.setMerId(this.cupMerId);
        try {
            String strCardTranData = null;
            if (Objects.nonNull(cardTranDataJson)) {
                strCardTranData = cardTranDataJson.toString();
                this.logger.info("\u52a0\u5bc6\u524d\u7684\u5361\u4fdd\u7559\u57df=" + strCardTranData);
                strCardTranData = Base64.encodeBase64String((byte[])strCardTranData.getBytes("UTF-8"));
                secssUtil.encryptData(strCardTranData);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    strCardTranData = secssUtil.getEncValue();
                } else {
                    result.put("respCode", (Object)"E");
                    result.put("respMsg", (Object)"\u52a0\u5bc6\u5361\u4fdd\u7559\u57df\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                    this.logger.info("\u52a0\u5bc6\u5361\u4fdd\u7559\u57df\u5931\u8d25\uff01" + secssUtil.getErrCode());
                    return result;
                }
            }
            if (strCardTranData != null) {
                sendMap.put("CardTranData", strCardTranData);
            }
            secssUtil.sign(sendMap);
            if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u7b7e\u540d\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                this.logger.info("\u7b7e\u540d\u5931\u8d25\uff01");
                return result;
            }
            sendMap.put("Signature", secssUtil.getSign());
            result = this.doSend(sendMap, secssUtil, cupSendMessage, hclcCupSignInfo.getSignId());
            if ("0000".equalsIgnoreCase(result.getString("respCode"))) {
                hclcCupSignInfo.setStatus(sendSuccess);
            } else {
                hclcCupSignInfo.setStatus(sendFail);
            }
            hclcCupSignInfo.setRemark(result.getString("respMsg"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u7b7e\u7ea6\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u7b7e\u7ea6\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            hclcCupSignInfo.setStatus(sendFail);
        }
        this.hclcCupSignInfoMapper.updateByPrimaryKeySelective(hclcCupSignInfo);
        result.put("signId", (Object)hclcCupSignInfo.getSignId());
        return result;
    }

    @Override
    public JSONObject sendSign(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get((Object)"signId"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570signId\u7f3a\u5931\uff0c\u65e0\u6cd5\u7b7e\u7ea6\uff01");
            return result;
        }
        HclcCupSignInfo hclcCupSignInfo = new HclcCupSignInfo();
        hclcCupSignInfo.setSignId(params.getLong("signId"));
        hclcCupSignInfo = (HclcCupSignInfo)this.hclcCupSignInfoMapper.selectByPrimaryKey(hclcCupSignInfo);
        if (signSuccess.equalsIgnoreCase(hclcCupSignInfo.getStatus())) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u7b7e\u7ea6\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u7b7e\u7ea6\uff01");
            return result;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("Version", "20140728");
        sendMap.put("MerId", hclcCupSignInfo.getMerId());
        sendMap.put("MerOrderNo", hclcCupSignInfo.getMerOrderNo());
        sendMap.put("TranDate", StringUtil.getRelevantDate(new Date()));
        sendMap.put("TranTime", StringUtil.getRelevantTime(new Date()));
        sendMap.put("BusiType", "0001");
        sendMap.put("TranType", "9904");
        sendMap.put("MerBgUrl", "http://lease.hitachics.com/core/api/public/china/send/sign/listen");
        String ownerId = this.cupMerId;
        SecssUtil secssUtil = this.getSecssUtil(ownerId);
        JSONObject cardTranDataJson = new JSONObject();
        cardTranDataJson.put("CardNo", (Object)hclcCupSignInfo.getCardNo());
        cardTranDataJson.put("AccName", (Object)hclcCupSignInfo.getAccName());
        cardTranDataJson.put("CertType", (Object)hclcCupSignInfo.getCertType());
        cardTranDataJson.put("CertNo", (Object)hclcCupSignInfo.getCertNo());
        cardTranDataJson.put("MobileNo", (Object)hclcCupSignInfo.getMobileNo());
        cardTranDataJson.put("EntrstAuthNo", (Object)hclcCupSignInfo.getCertNo());
        cardTranDataJson.put("EntrstAmtLmt", (Object)hclcCupSignInfo.getEntrstAmtLmt());
        cardTranDataJson.put("EntrstStrDtTm", (Object)hclcCupSignInfo.getEntrstStrDtTm());
        cardTranDataJson.put("EntrstEndDtTm", (Object)hclcCupSignInfo.getEntrstEndDtTm());
        cardTranDataJson.put("EntrstDtUnt", (Object)hclcCupSignInfo.getEntrstDtUnt());
        cardTranDataJson.put("EntrstDtStp", (Object)hclcCupSignInfo.getEntrstDtStp().toString());
        cardTranDataJson.put("MobileAuthCode", (Object)params.getString("auth_code"));
        String strCardTranData = null;
        try {
            this.logger.info("send sign start!");
            if (Objects.nonNull(cardTranDataJson)) {
                strCardTranData = cardTranDataJson.toString();
                this.logger.info("\u52a0\u5bc6\u524d\u7684\u5361\u4fdd\u7559\u57df=" + strCardTranData);
                strCardTranData = Base64.encodeBase64String((byte[])strCardTranData.getBytes("UTF-8"));
                secssUtil.encryptData(strCardTranData);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    strCardTranData = secssUtil.getEncValue();
                } else {
                    result.put("respCode", (Object)"E");
                    result.put("respMsg", (Object)"\u52a0\u5bc6\u5361\u4fdd\u7559\u57df\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                    this.logger.info("\u52a0\u5bc6\u5361\u4fdd\u7559\u57df\u5931\u8d25!");
                    return result;
                }
            }
            if (strCardTranData != null) {
                sendMap.put("CardTranData", strCardTranData);
            }
            JSONObject tranReservedJson = new JSONObject();
            tranReservedJson.put("SubTransType", (Object)"99100001");
            sendMap.put("TranReserved", tranReservedJson.toString());
            secssUtil.sign(sendMap);
            if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u7b7e\u540d\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                this.logger.info("\u7b7e\u540d\u5931\u8d25!");
                return result;
            }
            sendMap.put("Signature", secssUtil.getSign());
            result = this.doSend(sendMap, secssUtil, cupSignSend, hclcCupSignInfo.getSignId());
            if ("0000".equalsIgnoreCase(result.getString("respCode")) && "01".equalsIgnoreCase(result.getString("SignState"))) {
                hclcCupSignInfo.setStatus(signSuccess);
                hclcCupSignInfo.setProtocolNo(result.getJSONObject("CardTranData").getString("ProtocolNo"));
            } else {
                hclcCupSignInfo.setStatus(signFail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u7b7e\u7ea6\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u7b7e\u7ea6\u63a5\u53e3\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            hclcCupSignInfo.setStatus(signFail);
        }
        this.hclcCupSignInfoMapper.updateByPrimaryKeySelective(hclcCupSignInfo);
        return result;
    }

    @Override
    public JSONObject uploadBatch(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get((Object)"transaction_id"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570transaction_id\u7f3a\u5931\uff0c\u65e0\u6cd5\u4e0a\u4f20\uff01");
            return result;
        }
        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(params.getLongValue("transaction_id"));
        hlsEbankCcbTransaction = (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);
        if (!transNew.equalsIgnoreCase(hlsEbankCcbTransaction.getStatus())) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u6279\u6263\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u6279\u6263\u6587\u4ef6\u65e0\u6cd5\u53d1\u9001\uff01");
            this.logger.info("\u6279\u6263\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u6279\u6263\u6587\u4ef6\u65e0\u6cd5\u53d1\u9001\uff01");
            return result;
        }
        this.logger.info("upload batch start, transaction_id:" + hlsEbankCcbTransaction.getTransactionId());
        try {
            String line;
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("Version", "20140728");
            sendMap.put("MerId", this.cupMerId);
            sendMap.put("FileName", hlsEbankCcbTransaction.getSendFileName());
            sendMap.put("BusiType", "0001");
            String filepath = this.cupUploadFilePath + hlsEbankCcbTransaction.getSendFileName();
            File file = new File(filepath);
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                System.out.println("file too big...");
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u6279\u6263\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38\uff0c\u4e0a\u4f20\u6587\u4ef6\u592a\u5927\uff01");
                this.logger.info("\u6279\u6263\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38\uff0c\u4e0a\u4f20\u6587\u4ef6\u592a\u5927\uff01");
                return result;
            }
            if (fileSize <= 0L) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u6279\u6263\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                this.logger.info("\u6279\u6263\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                return result;
            }
            FileInputStream fi = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)fi, "UTF-8");
            BufferedReader br = new BufferedReader(reader);
            String readResult = "";
            while ((line = br.readLine()) != null) {
                readResult = readResult + line;
                readResult = readResult + "\n";
            }
            br.close();
            reader.close();
            if (readResult.startsWith("\ufeff")) {
                readResult = readResult.substring(1);
            }
            String ownerId = this.cupMerId;
            SecssUtil secssUtil = this.getSecssUtil(ownerId);
            String contentStr = secssUtil.encodeEnvelope(readResult.getBytes("UTF-8"));
            sendMap.put("FileContent", contentStr);
            secssUtil.sign(sendMap);
            if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u7b7e\u540d\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                this.logger.info("\u7b7e\u540d\u5931\u8d25!");
                return result;
            }
            sendMap.put("Signature", secssUtil.getSign());
            hlsEbankCcbTransaction.setVersion((String)sendMap.get("Version"));
            hlsEbankCcbTransaction.setTranDate(StringUtil.getRelevantDate(new Date()));
            hlsEbankCcbTransaction.setTranTime(StringUtil.getRelevantTime(new Date()));
            hlsEbankCcbTransaction.setTranType("0101");
            result = this.doSend(sendMap, secssUtil, cupBatchUpload, hlsEbankCcbTransaction.getTransactionId());
            if ("0014".equalsIgnoreCase(result.getString("respCode")) || "2043".equalsIgnoreCase(result.getString("respCode")) || "E".equalsIgnoreCase(result.getString("respCode"))) {
                hlsEbankCcbTransaction.setStatus(transDeal);
                hlsEbankCcbTransaction.setOrderStatus("0001");
            } else {
                hlsEbankCcbTransaction.setStatus(transFail);
                hlsEbankCcbTransaction.setOrderStatus("0003");
            }
            hlsEbankCcbTransaction.setReturnCode(result.getString("respCode"));
            hlsEbankCcbTransaction.setReturnMsg(result.getString("respMsg"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6279\u91cf\u4ea4\u6613\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c" + e.getMessage());
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u6279\u91cf\u4ea4\u6613\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            hlsEbankCcbTransaction.setStatus(transDeal);
        }
        this.hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);
        return result;
    }

    @Override
    public JSONObject queryBatch(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get((Object)"transaction_id"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570transaction_id\u7f3a\u5931\uff0c\u65e0\u6cd5\u67e5\u8be2\uff01");
            return result;
        }
        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(params.getLongValue("transaction_id"));
        hlsEbankCcbTransaction = (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("Version", "20140728");
        sendMap.put("MerId", this.cupMerId);
        sendMap.put("MerBatchId", hlsEbankCcbTransaction.getSendFileName().split("_")[2]);
        sendMap.put("MerBatchDate", hlsEbankCcbTransaction.getSendFileName().split("_")[1]);
        sendMap.put("BusiType", "0001");
        sendMap.put("TranType", "0506");
        this.logger.info("query batch start, transaction_id:" + hlsEbankCcbTransaction.getTransactionId());
        try {
            String ownerId = this.cupMerId;
            SecssUtil secssUtil = this.getSecssUtil(ownerId);
            secssUtil.sign(sendMap);
            if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u7b7e\u540d\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                this.logger.info("\u7b7e\u540d\u5931\u8d25!");
                return result;
            }
            sendMap.put("Signature", secssUtil.getSign());
            result = this.doSend(sendMap, secssUtil, cupBatchQuery, hlsEbankCcbTransaction.getTransactionId());
            if ("0000".equalsIgnoreCase(result.getString("respCode"))) {
                String orderStatus = result.getString("OrderStatus");
                if ("0000".equalsIgnoreCase(orderStatus)) {
                    hlsEbankCcbTransaction.setBackFileName(result.getString("DownloadFileName"));
                } else if ("0003".equalsIgnoreCase(orderStatus) || "1002".equalsIgnoreCase(orderStatus)) {
                    hlsEbankCcbTransaction.setStatus(transFail);
                }
                hlsEbankCcbTransaction.setOrderStatus(orderStatus);
            } else if ("3441".equalsIgnoreCase(result.getString("respCode"))) {
                hlsEbankCcbTransaction.setStatus(transFail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6279\u91cf\u4ea4\u6613\u6587\u4ef6\u67e5\u8be2\u5f02\u5e38!" + e.getMessage());
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u6279\u91cf\u4ea4\u6613\u6587\u4ef6\u67e5\u8be2\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        this.hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);
        return result;
    }

    @Override
    public JSONObject downloadBatch(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get((Object)"transaction_id"))) {
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u8bf7\u6c42\u5fc5\u987b\u53c2\u6570transaction_id\u7f3a\u5931\uff0c\u65e0\u6cd5\u4e0b\u8f7d\uff01");
            return result;
        }
        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(params.getLongValue("transaction_id"));
        hlsEbankCcbTransaction = (HlsEbankCcbTransaction)this.hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("Version", "20140728");
        sendMap.put("MerId", this.cupMerId);
        sendMap.put("OriFileName", hlsEbankCcbTransaction.getSendFileName());
        sendMap.put("DownloadFileName", hlsEbankCcbTransaction.getBackFileName());
        this.logger.info("download batch start, transaction_id:" + hlsEbankCcbTransaction.getTransactionId());
        try {
            String ownerId = this.cupMerId;
            SecssUtil secssUtil = this.getSecssUtil(ownerId);
            secssUtil.sign(sendMap);
            if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                result.put("respCode", (Object)"E");
                result.put("respMsg", (Object)"\u7b7e\u540d\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                this.logger.info("\u7b7e\u540d\u5931\u8d25!");
                return result;
            }
            sendMap.put("Signature", secssUtil.getSign());
            result = this.doSend(sendMap, secssUtil, cupBatchDownload, hlsEbankCcbTransaction.getTransactionId());
            if ("0000".equalsIgnoreCase(result.getString("respCode"))) {
                String fileData = result.getString("FileData");
                String filepath = this.cupDownloadFilePath + hlsEbankCcbTransaction.getBackFileName();
                FileOutputStream fos = new FileOutputStream(filepath);
                OutputStreamWriter write = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                BufferedWriter writer = new BufferedWriter(write);
                writer.write(fileData);
                writer.close();
                hlsEbankCcbTransaction.setFileFlag("1");
                this.hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);
                result.remove((Object)"FileData");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6279\u91cf\u4ea4\u6613\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
            result.put("respCode", (Object)"E");
            result.put("respMsg", (Object)"\u6279\u91cf\u4ea4\u6613\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        return result;
    }

    public JSONObject doSend(Map<String, String> sendMap, SecssUtil secssUtil, String functionName, Long pkValue) throws UnsupportedEncodingException {
        JSONObject resultJson = new JSONObject();
        JSONObject requestJson = new JSONObject();
        for (String key : sendMap.keySet()) {
            String value = sendMap.get(key);
            if (value == null) {
                value = "null";
            }
            value = value.trim();
            requestJson.put(key, (Object)value);
        }
        HlsWsConfig hlsWsConfig = new HlsWsConfig();
        List<Object> configs = new ArrayList();
        hlsWsConfig.setConfigName(functionName);
        configs = this.hlsWsConfigMapper.select(hlsWsConfig);
        if (!Objects.nonNull(configs) || configs.size() <= 0) {
            resultJson.put("respCode", (Object)"E");
            resultJson.put("respMsg", (Object)("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u4fe1\u606f\uff1a" + functionName + "\u672a\u5b9a\u4e49"));
            this.logger.info("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u4fe1\u606f: {} \u672a\u5b9a\u4e49\uff01", (Object)functionName);
            return resultJson;
        }
        hlsWsConfig = (HlsWsConfig)configs.get(0);
        HlsWsRequests hlsWsRequests = this.logInterfaceRequest(functionName, hlsWsConfig.getWsdlAddress(), requestJson.toString(), pkValue);
        this.logger.info("\u53d1\u9001\u8bf7\u6c42,\u8bf7\u6c42\u53c2\u6570: {}", (Object)requestJson.toString());
        String result = "";
        try {
            result = HttpUtils.sendJson(hlsWsConfig.getWsdlAddress(), requestJson, "UTF-8");
            this.logger.info("\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c: {} ", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38: {} ", (Object)e.getMessage());
            resultJson.put("respCode", (Object)"E");
            resultJson.put("respMsg", (Object)("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + e.getMessage()));
            hlsWsRequests.setReturnStatus("E");
            hlsWsRequests.setResponsedDate(new Date());
            this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
            return resultJson;
        }
        Map retMap = (Map)JSONObject.parseObject((String)result, Map.class);
        hlsWsRequests.setResponseClob(result);
        hlsWsRequests.setReturnStatus("S");
        hlsWsRequests.setResponsedDate(new Date());
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        String sign = (String)retMap.get("Signature");
        if (StringUtil.isNotEmpty(sign)) {
            secssUtil.verify(retMap);
        }
        if (Objects.isNull(retMap.get("respCode"))) {
            resultJson.put("respCode", (Object)"E");
            resultJson.put("respMsg", (Object)"\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u672a\u53d1\u73b0\u9a8c\u7b7e\u9a8c\u7b7e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            this.logger.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u672a\u53d1\u73b0\u9a8c\u7b7e\u9a8c\u7b7e\u4fe1\u606f");
            return resultJson;
        }
        for (Map.Entry entry : retMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtil.isEmpty(value)) continue;
            if ("CardTranData".equals(key)) {
                secssUtil.decryptData(value);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    value = secssUtil.getDecValue();
                }
            }
            if ("RiskData".equals(key)) {
                secssUtil.decryptData(value);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    value = secssUtil.getDecValue();
                }
            }
            if ("FileData".equals(key)) {
                byte[] bytes = secssUtil.decodeEnvelope(value);
                value = new String(bytes, "UTF-8");
            }
            resultJson.put(key, (Object)value);
        }
        hlsWsRequests.setResponseClob(resultJson.toString());
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    protected SecssUtil getSecssUtil(String ownerId) {
        String path = String.format("%s%s.properties", this.cupInitFilePath, ownerId);
        SecssUtil secssUtil = new SecssUtil(true);
        secssUtil.init(path);
        return secssUtil;
    }

    private String getTableName(String functionName) {
        String tableName = "";
        if (cupSignSend.equalsIgnoreCase(functionName) || cupSendMessage.equalsIgnoreCase(functionName)) {
            tableName = "HCLC_CUP_SIGN_INFO";
        } else if (cupBatchUpload.equalsIgnoreCase(functionName) || cupBatchQuery.equalsIgnoreCase(functionName) || cupBatchDownload.equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CCB_TRANSACTION";
        }
        return tableName;
    }

    public HlsWsRequests logInterfaceRequest(String functionName, String url, String request, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName(functionName);
        String tableName = this.getTableName(functionName);
        hlsWsRequests.setTableName(tableName);
        hlsWsRequests.setStatusCode("1");
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setPkValue(pkValue);
        hlsWsRequests.setRequestClob(request);
        this.hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }
}

