/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.cp.api.impl.WxCpServiceAbstractImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxCpServiceApacheHttpClientImpl
extends WxCpServiceAbstractImpl<CloseableHttpClient, HttpHost> {
    protected CloseableHttpClient httpClient;
    protected HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.APACHE_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isAccessTokenExpired() || forceRefresh) {
            Object var2 = this.globalAccessTokenRefreshLock;
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAccessTokenExpired()) {
                    String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + this.configStorage.getCorpId() + "&corpsecret=" + this.configStorage.getCorpSecret();
                    try {
                        HttpGet e = new HttpGet(url);
                        if (this.httpProxy != null) {
                            RequestConfig resultContent = RequestConfig.custom().setProxy(this.httpProxy).build();
                            e.setConfig(resultContent);
                        }
                        String resultContent1 = null;
                        try (CloseableHttpClient error = this.getRequestHttpClient();
                             CloseableHttpResponse response = error.execute((HttpUriRequest)e);){
                            resultContent1 = new BasicResponseHandler().handleResponse((HttpResponse)response);
                        }
                        finally {
                            e.releaseConnection();
                        }
                        WxError error1 = WxError.fromJson((String)resultContent1);
                        if (error1.getErrorCode() != 0) {
                            throw new WxErrorException(error1);
                        }
                        WxAccessToken accessToken1 = WxAccessToken.fromJson((String)resultContent1);
                        this.configStorage.updateAccessToken(accessToken1.getAccessToken(), accessToken1.getExpiresIn());
                    }
                    catch (IOException var56) {
                        throw new RuntimeException(var56);
                    }
                }
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        ApacheHttpClientBuilder apacheHttpClientBuilder = this.configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(this.configStorage.getHttpProxyHost()).httpProxyPort(this.configStorage.getHttpProxyPort()).httpProxyUsername(this.configStorage.getHttpProxyUsername()).httpProxyPassword(this.configStorage.getHttpProxyPassword());
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

