/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.v3.sign;

import com.timevale.esign.sdk.tech.impl.model.ModelType;
import com.timevale.esign.sdk.tech.impl.model.TsaModel;
import com.timevale.tech.sdk.constants.a;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.text.pdf.security.ah;
import esign.utils.constant.type.CAIssuer;
import esign.utils.exception.ai;
import esign.utils.s;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class e {
    private static final Logger a = LoggerFactory.getLogger(e.class);

    public static byte[] a(byte[] signResult) {
        byte[] result = signResult;
        try {
            CMSSignedData sd = new CMSSignedData(result);
            SignerInformationStore signers = sd.getSignerInfos();
            SignerInformation signer = (SignerInformation)signers.getSigners().iterator().next();
            byte[] signature = signer.getSignature();
            String rdnsDec = signer.getSID().getIssuer().toString();
            ArrayList<String> bktspUrls = new ArrayList<String>();
            String tspUrl = e.a(rdnsDec, bktspUrls);
            a.debug("ready to execute timestamp with: {} ", (Object)tspUrl);
            ASN1EncodableVector aev = e.a(signature, tspUrl, bktspUrls);
            if (aev != null) {
                AttributeTable at = new AttributeTable(aev);
                signer = SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)at);
                ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
                signerInfos.add(signer);
                sd = CMSSignedData.replaceSigners((CMSSignedData)sd, (SignerInformationStore)new SignerInformationStore(signerInfos));
                result = sd.getEncoded();
            } else {
                a.warn("all timestamp server return null aev.");
            }
            return result;
        }
        catch (CMSException e2) {
            a.error("signResult parse exception. ", (Throwable)e2);
            return null;
        }
        catch (IOException e3) {
            a.error("append timestamp io exception. ", (Throwable)e3);
            return null;
        }
        catch (Exception e4) {
            a.error("do timestamp exception.", (Throwable)e4);
            return null;
        }
    }

    private static ASN1EncodableVector a(byte[] signature, String timestampUrl, List<String> bkTimestampUrls) throws Exception {
        ASN1EncodableVector aev = e.a(signature, timestampUrl);
        if (aev == null && bkTimestampUrls != null && !bkTimestampUrls.isEmpty()) {
            String url;
            Iterator<String> i$ = bkTimestampUrls.iterator();
            while (i$.hasNext() && (aev = e.a(signature, url = i$.next())) == null) {
                a.warn("execute timestamp with {} invalid.", (Object)url);
            }
        }
        return aev;
    }

    private static ASN1EncodableVector a(byte[] signature, String timestampUrl) throws Exception {
        MessageDigest md = MessageDigest.getInstance("sha-1");
        md.update(signature);
        byte[] tsImprint = md.digest();
        ah tsc = new ah(timestampUrl, null, null);
        String ID_TIME_STAMP_TOKEN = "1.2.840.113549.1.9.16.2.14";
        ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(tsc.a(tsImprint)));
        ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_TIME_STAMP_TOKEN));
        ASN1Sequence seq = (ASN1Sequence)tempstream.readObject();
        v.add((ASN1Encodable)new DERSet((ASN1Encodable)seq));
        unauthAttributes.add((ASN1Encodable)new DERSequence(v));
        return unauthAttributes;
    }

    private static String a(String issuer, List<String> bkTimeStampUrls) {
        if (issuer.contains("ZJCA")) {
            issuer = CAIssuer.ZJCA.getCAIssuer();
        } else if (issuer.contains("CFCA")) {
            issuer = CAIssuer.CFCA.getCAIssuer();
        }
        String tsaUrl = null;
        ConcurrentHashMap<String, String> map = com.timevale.tech.sdk.constants.a.a();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(issuer)) {
                    tsaUrl = entry.getValue();
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase(CAIssuer.TGCA.getCAIssuer())) {
                    if (!issuer.equalsIgnoreCase(CAIssuer.ZJCA.getCAIssuer()) && !issuer.equalsIgnoreCase(CAIssuer.TGCA.getCAIssuer())) continue;
                    tsaUrl = entry.getValue();
                    continue;
                }
                bkTimeStampUrls.add(entry.getValue());
            }
        }
        if (s.a(tsaUrl)) {
            try {
                TsaModel model = (TsaModel)ModelType.TsaServer.model();
                tsaUrl = model.getUrl();
            }
            catch (ai e2) {
                a.error("get tsa server failed.", (Throwable)e2);
            }
        }
        return tsaUrl;
    }
}

