/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.util;

import com.esms.common.entity.MediaItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaUtil {
    private static final int MAX_ACCEPT_FILE_LENGTH = 0x100000;

    public static MediaItem getMediaFromFile(String folder, String fileName) throws IOException {
        File file = new File(folder, fileName);
        return MediaUtil.getMediaFromFile(file);
    }

    public static MediaItem getMediaFromFile(String fullFileName) throws IOException {
        File file = new File(fullFileName);
        return MediaUtil.getMediaFromFile(file);
    }

    public static MediaItem getMediaFromFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int fileLen = fis.available();
            if (fileLen > 0x100000) {
                return null;
            }
            byte[] data = new byte[fileLen];
            fis.read(data);
            MediaItem media = new MediaItem();
            media.setData(data);
            media.setMeta(file.getName());
            MediaItem mediaItem = media;
            return mediaItem;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static List<MediaItem> getMediasFromFolder(String path) throws IOException {
        File folder = new File(path);
        if (!folder.exists()) {
            throw new FileNotFoundException(path);
        }
        if (!folder.isDirectory()) {
            throw new IOException(String.valueOf(path) + " : is not a folder?!");
        }
        ArrayList<MediaItem> medias = new ArrayList<MediaItem>();
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaItem media;
            File file = fileArray[n2];
            if (file.isFile() && (media = MediaUtil.getMediaFromFile(file)) != null) {
                medias.add(media);
            }
            ++n2;
        }
        return medias;
    }
}

