/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> T deserializeFromBytes(byte[] srcBytes, Class<T> t) throws Exception {
        if (srcBytes == null) {
            throw new IllegalArgumentException("srcBytes should not be null");
        }
        return (T)mapper.readValue(srcBytes, 0, srcBytes.length, t);
    }

    public static <T> T deserialize(String src, Class<T> t) throws Exception {
        if (src == null) {
            throw new IllegalArgumentException("src should not be null");
        }
        return (T)mapper.readValue(src, t);
    }

    public static byte[] serializeToBytes(Object obj) throws Exception {
        return mapper.writeValueAsBytes(obj);
    }

    public static String serialize(Object obj) throws Exception {
        return mapper.writeValueAsString(obj);
    }
}

