/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common;

import com.esms.MessageData;
import com.esms.common.entity.Account;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MediaItem;
import com.esms.common.entity.TemplateData;
import com.esms.common.entity.WechatMessage;
import com.esms.common.util.CommonUtil;
import com.esms.common.util.JsonUtil;
import com.esms.common.util.UUIDUtil;
import com.esms.common.util.XmlUtil;
import com.esms.common.util.ZipUtil;
import com.google.protobuf.ByteString;
import com.xuanwu.msggate.common.protobuf.CommonItem;
import com.xuanwu.msggate.common.protobuf.mt.MTRequest;
import com.xuanwu.msggate.common.protobuf.mt.MTResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MTSupport {
    private static final String METHOD = "SDK_JAVA";
    private static final String VERSION = "5.1";
    private static final String FROM_CODE = "SDK_JAVA_5.1";

    public static byte[] getLoginBytes(Account account) {
        return MTSupport.getLoginBytes(account, "0");
    }

    public static byte[] getLoginBytes(Account account, String loginMode) {
        MTRequest.TRequest.Builder builder = MTRequest.TRequest.newBuilder();
        builder.setUuid(UUIDUtil.tranUUID2Builder(UUID.randomUUID()));
        builder.setType(MTRequest.TRequestType.LOGIN);
        CommonItem.Account.Builder acc = CommonItem.Account.newBuilder();
        acc.setName(account.getName());
        acc.setPassword(account.getPassword());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ACCESS_METHOD", METHOD);
        map.put("ACCESS_VERSION", VERSION);
        if (CommonUtil.isNotBlank(account.getFrom())) {
            map.put("ACCESS_EXT_MSG", account.getFrom());
        }
        if (loginMode.equals("1")) {
            String timestamp = System.currentTimeMillis() + "";
            acc.setPassword(CommonUtil.createSignature(account.getName(), timestamp, account.getPrivateKey()));
            map.put("ACCESS_LOGINMODE", "1");
            map.put("ACCESS_TIMESTAMP", timestamp);
        }
        builder.setAttributes(XmlUtil.toXML(map));
        builder.setUser(acc);
        return builder.build().toByteArray();
    }

    public static byte[] getSendBytes(Account account, MTPack pack) throws Exception {
        return MTSupport.getSendBytes(account, "0", pack);
    }

    public static byte[] getSendBytes(Account account, String loginMode, MTPack pack) throws Exception {
        MTRequest.TRequest.Builder builder = MTRequest.TRequest.newBuilder();
        if (pack.getBatchID() == null) {
            pack.setBatchID(UUID.randomUUID());
        }
        builder.setUuid(UUIDUtil.tranUUID2Builder(pack.getBatchID()));
        if (pack.getCustomNum() != null) {
            builder.setCustomNum(pack.getCustomNum());
        }
        CommonItem.BizMeta.Builder biz = CommonItem.BizMeta.newBuilder();
        biz.setLevel(0);
        biz.setPriority(0);
        biz.setMsgType(pack.getMsgType().getIndex());
        biz.setSendType(pack.getSendType().ordinal());
        if (pack.getScheduleTime() > 0L) {
            biz.setScheduleTime(pack.getScheduleTime());
        }
        if (pack.getDeadline() > 0L) {
            biz.setDeadline(pack.getDeadline());
        }
        if (pack.getRemark() != null) {
            builder.setRemark(pack.getRemark());
        }
        biz.setBizType(pack.getBizType());
        builder.setInfo(biz);
        builder.setType(MTRequest.TRequestType.MESSAGE_SENT);
        builder.setFrom(FROM_CODE);
        if (pack.getBatchName() != null) {
            builder.setBatchName(pack.getBatchName());
        }
        builder.setDistinctFlag(pack.isDistinctFlag());
        if (pack.getMedias() != null) {
            for (MediaItem mItem : pack.getMedias()) {
                CommonItem.MediaItem.Builder temp = CommonItem.MediaItem.newBuilder();
                temp.setMediaType(mItem.getMediaType());
                temp.setMeta(mItem.getMeta());
                temp.setData(ByteString.copyFrom((byte[])mItem.getData()));
                builder.addMmsAttachment(temp);
            }
        }
        switch (pack.getSendType()) {
            case MASS: {
                CommonItem.MassPack.Builder massmsg = CommonItem.MassPack.newBuilder();
                MessageData msg0 = pack.getMsgs().get(0);
                CommonItem.MsgContent.Builder contentMass = CommonItem.MsgContent.newBuilder();
                if (pack.getMsgType() == MTPack.MsgType.WECHAT) {
                    WechatMessage message = new WechatMessage();
                    message.setTemplateId(pack.getTemplateNo());
                    message.settTemplateDatas(msg0.getTemplateDatas());
                    message.setWechatType(WechatMessage.WechatType.TEMPLATE);
                    message.setUrl(msg0.getUrl());
                    contentMass.setContent(JsonUtil.serialize(message));
                } else if (pack.getMsgType() == MTPack.MsgType.EMAIL) {
                    if (msg0.getEmailContent() != null) {
                        contentMass.setContent(JsonUtil.serialize(msg0.getEmailContent()));
                    }
                } else {
                    contentMass.setContent(msg0.getContent());
                }
                massmsg.setContent(contentMass);
                for (MessageData msg : pack.getMsgs()) {
                    CommonItem.MsgItem.Builder item = CommonItem.MsgItem.newBuilder();
                    if (pack.getMsgType() == MTPack.MsgType.WECHAT) {
                        item.setOpenId(msg.getOpenId());
                    }
                    if (pack.getMsgType() == MTPack.MsgType.EMAIL) {
                        item.setEmail(msg.getEmail());
                    }
                    item.setPhone(msg.getPhone());
                    if (msg.getCustomMsgID() != null) {
                        item.setCustomMsgID(msg.getCustomMsgID());
                    }
                    if (msg.getCustomNum() != null) {
                        item.setCustomNum(msg.getCustomNum());
                    }
                    item.setVipFlag(msg.isVipFlag());
                    if (msg.getOrgCode() != null && msg.getOrgCode().length() > 0) {
                        item.setOrgCode(msg.getOrgCode());
                    }
                    if (msg.getMsgFmt() != 0) {
                        item.setMsgFmt(msg.getMsgFmt());
                    }
                    massmsg.addItems(item);
                }
                builder.setMassMsg(ByteString.copyFrom((byte[])ZipUtil.zipByteArray(massmsg.build().toByteArray())));
                break;
            }
            case GROUP: {
                CommonItem.GroupPack.Builder groupmsg = CommonItem.GroupPack.newBuilder();
                String templateNo = pack.getTemplateNo();
                for (MessageData msg : pack.getMsgs()) {
                    Map<String, TemplateData> templateDatas;
                    CommonItem.MsgItem.Builder item = CommonItem.MsgItem.newBuilder();
                    CommonItem.MsgContent.Builder contentGroup = CommonItem.MsgContent.newBuilder();
                    item.setPhone(msg.getPhone());
                    String msgContent = msg.getContent();
                    if (CommonUtil.isNotBlank(templateNo) && CommonUtil.isBlank(msgContent) && (templateDatas = msg.getTemplateDatas()) != null) {
                        msgContent = JsonUtil.serialize(templateDatas);
                    }
                    contentGroup.setContent(msgContent);
                    if (msg.getMedias() != null) {
                        for (MediaItem mItem : msg.getMedias()) {
                            CommonItem.MediaItem.Builder temp = CommonItem.MediaItem.newBuilder();
                            temp.setMediaType(mItem.getMediaType());
                            temp.setMeta(mItem.getMeta());
                            temp.setData(ByteString.copyFrom((byte[])mItem.getData()));
                            contentGroup.addMedias(temp);
                        }
                    }
                    if (msg.getCustomMsgID() != null) {
                        item.setCustomMsgID(msg.getCustomMsgID());
                    }
                    if (msg.getCustomNum() != null) {
                        item.setCustomNum(msg.getCustomNum());
                    }
                    item.setVipFlag(msg.isVipFlag());
                    if (pack.getMsgType() == MTPack.MsgType.WECHAT) {
                        item.setOpenId(msg.getOpenId());
                        WechatMessage message = new WechatMessage();
                        message.setOpenId(msg.getOpenId());
                        message.setTemplateId(pack.getTemplateNo());
                        message.settTemplateDatas(msg.getTemplateDatas());
                        message.setWechatType(WechatMessage.WechatType.TEMPLATE);
                        message.setUrl(msg.getUrl());
                        contentGroup.setContent(JsonUtil.serialize(message));
                    } else if (pack.getMsgType() == MTPack.MsgType.EMAIL) {
                        item.setEmail(msg.getEmail());
                        if (msg.getEmailContent() != null) {
                            contentGroup.setContent(JsonUtil.serialize(msg.getEmailContent()));
                        }
                    }
                    item.setContent(contentGroup);
                    if (msg.getOrgCode() != null && msg.getOrgCode().length() > 0) {
                        item.setOrgCode(msg.getOrgCode());
                    }
                    if (msg.getMsgFmt() != 0) {
                        item.setMsgFmt(msg.getMsgFmt());
                    }
                    groupmsg.addItems(item);
                }
                builder.setGroupMsg(ByteString.copyFrom((byte[])ZipUtil.zipByteArray(groupmsg.build().toByteArray())));
                break;
            }
        }
        CommonItem.Account.Builder acc = CommonItem.Account.newBuilder();
        acc.setName(account.getName());
        acc.setPassword(account.getPassword());
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        String templateNo = pack.getTemplateNo();
        if (templateNo != null && !"".equals(templateNo.trim())) {
            attrs.put("TEMPLATE_NO", templateNo.trim());
        }
        if (loginMode.equals("1")) {
            String timestamp = System.currentTimeMillis() + "";
            acc.setPassword(CommonUtil.createSignature(account.getName(), timestamp, account.getPrivateKey()));
            attrs.put("ACCESS_LOGINMODE", "1");
            attrs.put("ACCESS_TIMESTAMP", timestamp);
        }
        builder.setUser(acc);
        if (!attrs.isEmpty()) {
            builder.setAttributes(XmlUtil.toXML(attrs));
        }
        return builder.build().toByteArray();
    }

    public static boolean isLoginSuc(byte[] srcBytes) throws IOException {
        GsmsResponse resp = MTSupport.getResponse(srcBytes);
        return resp.getResult() == 0;
    }

    public static GsmsResponse getResponse(byte[] srcBytes) throws IOException {
        MTResponse.TResponse.Builder builder = MTResponse.TResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        GsmsResponse resp = new GsmsResponse();
        resp.setMessage(builder.getMessage());
        resp.setResult(builder.getResult().getNumber());
        resp.setUuid(UUIDUtil.tranBuilder2UUID(builder.getUuid()));
        resp.setAttributes(builder.getAttributes());
        return resp;
    }

    public static void verifyPack(MTPack pack) {
        if (pack == null) {
            throw new NullPointerException("pack");
        }
        if (pack.getMsgs() == null || pack.getMsgs().size() < 1) {
            throw new IllegalArgumentException("msgs is empty");
        }
        if (pack.getSendType() == null) {
            throw new NullPointerException("sendType");
        }
        if (pack.getMsgType() == null) {
            throw new NullPointerException("msgType");
        }
    }
}

