/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common;

import com.esms.MOMsg;
import com.esms.common.entity.Account;
import com.esms.common.entity.AccountInfo;
import com.esms.common.entity.BindChannel;
import com.esms.common.entity.BusinessType;
import com.esms.common.entity.MTReport;
import com.esms.common.entity.MTResponse;
import com.esms.common.entity.Ticket;
import com.esms.common.entity.TicketInfo;
import com.esms.common.util.CommonUtil;
import com.esms.common.util.UUIDUtil;
import com.esms.common.util.XmlUtil;
import com.esms.common.util.ZipUtil;
import com.google.protobuf.InvalidProtocolBufferException;
import com.xuanwu.msggate.common.protobuf.CommonItem;
import com.xuanwu.msggate.common.protobuf.mo.MORequest;
import com.xuanwu.msggate.common.protobuf.mo.MOResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MOSupport {
    public static byte[] getLoginBytes(Account account) {
        return MOSupport.getLoginBytes(account, "0");
    }

    public static byte[] getLoginBytes(Account account, String loginMode) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.LOGIN);
        CommonItem.Account.Builder acBuilder = CommonItem.Account.newBuilder();
        acBuilder.setName(account.getName());
        acBuilder.setPassword(account.getPassword());
        if (loginMode.equals("1")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String timestamp = String.valueOf(System.currentTimeMillis());
            acBuilder.setPassword(CommonUtil.createSignature(account.getName(), timestamp, account.getPrivateKey()));
            map.put("ACCESS_LOGINMODE", "1");
            map.put("ACCESS_TIMESTAMP", timestamp);
            builder.setAttributes(XmlUtil.toXML(map));
        }
        builder.setUser(acBuilder.build());
        return builder.build().toByteArray();
    }

    public static boolean isLoginSuc(byte[] srcBytes) throws InvalidProtocolBufferException {
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        if (builder.getType() == CommonItem.OMsgType.LOGIN && builder.getResult() == CommonItem.Result.SUCCESS) {
            return true;
        }
        throw new RuntimeException(String.valueOf(builder.getResult().getNumber()) + ", " + builder.getResult().name() + ", " + builder.getMessage());
    }

    public static byte[] getAcInfoReq() {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.ACCOUNT_INFO);
        return builder.build().toByteArray();
    }

    public static byte[] getBizTypeReq() {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.BIZ_TYPE);
        return builder.build().toByteArray();
    }

    public static byte[] getModifyPwdReq(String newPwd) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.MODIFY_PWD);
        builder.setNewPwd(newPwd);
        return builder.build().toByteArray();
    }

    public static byte[] getMOReq(int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.MO);
        builder.setPageSize(fetchSize);
        builder.setAttributes("<map><entry><string>needConfirm</string><string>1</string></entry></map>");
        return builder.build().toByteArray();
    }

    public static byte[] findTicketReq(String phone, Date startTime, Date endTime, String userName, int pageIndex) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_TICKET);
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setPageIndex(pageIndex);
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (startTime != null) {
            map.put("START_TIME", sdf.format(startTime));
        }
        if (endTime != null) {
            map.put("END_TIME", sdf.format(endTime));
        }
        if (userName != null) {
            map.put("USER_NAME", userName);
        }
        builder.setAttributes(XmlUtil.toXML(map));
        return builder.build().toByteArray();
    }

    public static byte[] getFindRespReq(UUID batchID, String phone, int pageIndex, boolean isSimple) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_RESP);
        if (batchID != null) {
            builder.setBatchID(batchID.toString());
        }
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setIsSimple(isSimple);
        builder.setPageIndex(pageIndex);
        return builder.build().toByteArray();
    }

    public static byte[] getRespReq(int limitDays, int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.RESP);
        builder.setDays(limitDays);
        builder.setPageSize(fetchSize);
        builder.setAttributes("<map><entry><string>needConfirm</string><string>1</string></entry></map>");
        return builder.build().toByteArray();
    }

    public static byte[] getFindReportReq(UUID batchID, String phone, int pageIndex, boolean isSimple) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_REPORT);
        if (batchID != null) {
            builder.setBatchID(batchID.toString());
        }
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setIsSimple(isSimple);
        builder.setPageIndex(pageIndex);
        return builder.build().toByteArray();
    }

    public static byte[] getReportReq(int limitDays, int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.REPORT);
        builder.setDays(limitDays);
        builder.setPageSize(fetchSize);
        builder.setAttributes("<map><entry><string>needConfirm</string><string>1</string></entry></map>");
        return builder.build().toByteArray();
    }

    public static TicketInfo toTickets(MOResponse.OResponse.Builder builder) throws IOException {
        if (builder.getType() != CommonItem.OMsgType.FIND_TICKET) {
            return null;
        }
        CommonItem.TicketPack.Builder ticketPack = CommonItem.TicketPack.newBuilder();
        Map map = (Map)XmlUtil.fromXML(builder.getAttributes());
        ticketPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        List<CommonItem.Ticket> items = ticketPack.getTicketsList();
        if (items == null || items.size() == 0) {
            return null;
        }
        TicketInfo ticketInfo = new TicketInfo();
        ticketInfo.setTotal(Integer.valueOf(String.valueOf(map.get("TOTAL"))));
        ticketInfo.setFlag(Boolean.valueOf(String.valueOf(map.get("ALL"))));
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (CommonItem.Ticket t : items) {
            Ticket ticket = new Ticket();
            ticket.setTicketId(t.getId());
            ticket.setBatchId(t.getBatchId());
            ticket.setBatchName(t.getBatchName());
            ticket.setPhone(t.getPhone());
            ticket.setContent(t.getContent());
            ticket.setTotal(t.getTotal());
            ticket.setNumber(t.getNumber());
            ticket.setSpecNumber(t.getSpecNumer());
            ticket.setBizTypeName(t.getBizType());
            ticket.setUserName(t.getUserName());
            ticket.setSubmitRespTime(new Date(t.getSubmitRespTime()));
            ticket.setOriginResult(t.getOriginResult());
            tickets.add(ticket);
        }
        ticketInfo.setTickets(tickets);
        return ticketInfo;
    }

    public static MTResponse[] toResps(MOResponse.OResponse.Builder builder) throws IOException {
        if (builder.getType() != CommonItem.OMsgType.RESP && builder.getType() != CommonItem.OMsgType.FIND_RESP) {
            return null;
        }
        CommonItem.RespPack.Builder respPack = CommonItem.RespPack.newBuilder();
        respPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        List<CommonItem.RespItem> items = respPack.getItemsList();
        if (items == null || items.size() == 0) {
            return null;
        }
        ArrayList<MTResponse> resps = new ArrayList<MTResponse>();
        for (CommonItem.RespItem item : items) {
            MTResponse resp = new MTResponse();
            resp.setBatchID(UUIDUtil.tranBuilder2UUID(item.getBatchID()));
            resp.setCustomMsgID(item.getCustomMsgID());
            resp.setMsgID(item.getMsgID());
            resp.setNumber(item.getNumber());
            resp.setOriginResult(item.getOriginResult());
            resp.setPhone(item.getPhone());
            resp.setState(item.getState());
            resp.setSubmitRespTime(item.getSubmitRespTime());
            resp.setTotal(item.getTotal());
            resp.setReserve(item.getReserve());
            resp.setRespId(builder.getUuid());
            resps.add(resp);
        }
        return resps.toArray(new MTResponse[resps.size()]);
    }

    public static MTReport[] toReports(MOResponse.OResponse.Builder builder) throws IOException {
        if (builder.getType() != CommonItem.OMsgType.REPORT && builder.getType() != CommonItem.OMsgType.FIND_REPORT) {
            return null;
        }
        CommonItem.ReportPack.Builder reportPack = CommonItem.ReportPack.newBuilder();
        reportPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        List<CommonItem.StateItem> items = reportPack.getStateItemList();
        if (items == null || items.size() == 0) {
            return null;
        }
        ArrayList<MTReport> reports = new ArrayList<MTReport>();
        for (CommonItem.StateItem item : items) {
            MTReport report = new MTReport();
            report.setBatchID(UUIDUtil.tranBuilder2UUID(item.getBatchID()));
            report.setPhone(item.getDestPhone());
            report.setState(item.getState());
            report.setMsgID(item.getMsgID());
            report.setCustomMsgID(item.getCustomMsgID());
            report.setSubmitTime(item.getSubmitTime());
            report.setDoneTime(item.getDoneTime());
            report.setOriginResult(item.getOriginResult());
            report.setReserve(item.getReserve());
            report.setRespId(builder.getUuid());
            reports.add(report);
        }
        return reports.toArray(new MTReport[reports.size()]);
    }

    public static MOMsg[] toMos(MOResponse.OResponse.Builder builder) throws IOException {
        if (builder.getType() != CommonItem.OMsgType.MO) {
            return null;
        }
        CommonItem.MOTicketPack.Builder moPack = CommonItem.MOTicketPack.newBuilder();
        moPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        List<CommonItem.MOTicket> items = moPack.getItemsList();
        if (items == null || items.size() == 0) {
            return null;
        }
        ArrayList<MOMsg> mos = new ArrayList<MOMsg>();
        for (CommonItem.MOTicket item : items) {
            MOMsg mo = new MOMsg();
            mo.setPhone(item.getPhone());
            mo.setContent(item.getContent());
            mo.setMsgType(item.getType());
            mo.setSepcNumber(item.getSpecNumber());
            mo.setServiceType(item.getServiceType());
            mo.setRecevieTime(item.getPostTime());
            mo.setRespId(builder.getUuid());
            mos.add(mo);
        }
        return mos.toArray(new MOMsg[mos.size()]);
    }

    public static AccountInfo toAcInfo(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.ACCOUNT_INFO) {
            return null;
        }
        MOResponse.AccountInfo.Builder acInfoBuilder = MOResponse.AccountInfo.newBuilder();
        acInfoBuilder.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        AccountInfo acInfo = new AccountInfo();
        acInfo.setAccount(acInfoBuilder.getAccount());
        acInfo.setName(acInfoBuilder.getName());
        acInfo.setIdentify(acInfoBuilder.getIdentify());
        acInfo.setUserBrief(acInfoBuilder.getSignature());
        acInfo.setBizNames(acInfoBuilder.getBizNamesList().toArray(new String[0]));
        acInfo.setBalance((long)(acInfoBuilder.getBalance() * 100.0));
        return acInfo;
    }

    public static BusinessType[] toBizType(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.BIZ_TYPE) {
            return null;
        }
        MOResponse.BizTypePack.Builder bizPack = MOResponse.BizTypePack.newBuilder();
        bizPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        ArrayList<BusinessType> bizTypes = new ArrayList<BusinessType>();
        List<MOResponse.BusinessType> items = bizPack.getItemsList();
        if (items == null || items.size() == 0) {
            return null;
        }
        for (MOResponse.BusinessType biz : items) {
            BusinessType bizType = new BusinessType();
            bizType.setId(biz.getId());
            bizType.setName(biz.getName());
            bizType.setPriority(biz.getPriority());
            bizType.setStartTime(biz.getStartTime());
            bizType.setEndTime(biz.getEndTime());
            bizType.setExtendFlag(biz.getExtendFlag());
            bizType.setState(biz.getState());
            ArrayList<BindChannel> bindChs = new ArrayList<BindChannel>();
            for (MOResponse.BindChannel chBuilder : biz.getBindChsList()) {
                BindChannel bindCh = new BindChannel();
                bindCh.setCarrier(chBuilder.getCarrier());
                bindCh.setSpecNumber(chBuilder.getSpecNumber());
                bindCh.setSendType(chBuilder.getSendType());
                bindChs.add(bindCh);
            }
            bizType.setBindChs(bindChs);
            bizTypes.add(bizType);
        }
        return bizTypes.toArray(new BusinessType[bizTypes.size()]);
    }

    public static int toModifyPwdResult(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.MODIFY_PWD) {
            return -100;
        }
        return builder.getResult().getNumber();
    }

    public static byte[] getConfirmBytes(MOResponse.OResponse.Builder resp) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(resp.getType());
        builder.setUuid(resp.getUuid());
        builder.setAttributes("<map><entry><string>confirm</string><string>1</string></entry></map>");
        return builder.build().toByteArray();
    }

    public static byte[] getConfirmBytes(CommonItem.OMsgType msgType, CommonItem.UUID uuid) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(msgType);
        builder.setUuid(uuid);
        builder.setAttributes("<map><entry><string>confirm</string><string>1</string></entry></map>");
        return builder.build().toByteArray();
    }

    private static MORequest.ORequest.Builder getReq(CommonItem.OMsgType type) {
        return MOSupport.getReq(type, UUID.randomUUID());
    }

    private static MORequest.ORequest.Builder getReq(CommonItem.OMsgType type, UUID uuid) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(type);
        builder.setUuid(UUIDUtil.tranUUID2Builder(uuid));
        return builder;
    }

    public static MOResponse.OResponse.Builder toRespBuilder(byte[] srcBytes) throws IOException {
        if (srcBytes == null) {
            throw new NullPointerException("srcBytes");
        }
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        return builder;
    }
}

