/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common;

import com.esms.HostInfo;
import com.esms.common.HttpSupport;
import com.esms.common.pool.SocketObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ConnectionSupport {
    public static SocketObject getValidSockObj(HostInfo proxyHost, HostInfo destHost, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(timeout);
        switch (proxyHost.getType()) {
            case DIRECT: {
                socket.connect(new InetSocketAddress(destHost.getIp(), destHost.getPort()), timeout);
                break;
            }
            case HTTP: {
                socket.connect(new InetSocketAddress(proxyHost.getIp(), proxyHost.getPort()), timeout);
                ConnectionSupport.connectToHttp(socket, proxyHost, destHost);
                break;
            }
            case SOCKET4: {
                socket.connect(new InetSocketAddress(proxyHost.getIp(), proxyHost.getPort()), timeout);
                ConnectionSupport.connectToSocks4(socket, proxyHost, destHost);
                break;
            }
            case SOCKET5: {
                socket.connect(new InetSocketAddress(proxyHost.getIp(), proxyHost.getPort()), timeout);
                ConnectionSupport.connectToSocks5(socket, proxyHost, destHost);
                break;
            }
            default: {
                socket.connect(new InetSocketAddress(destHost.getIp(), destHost.getPort()), timeout);
            }
        }
        SocketObject obj = new SocketObject(socket);
        return obj;
    }

    private static void connectToHttp(Socket socket, HostInfo proxyHost, HostInfo destHost) throws IOException {
        String httpReq = HttpSupport.getConnectResq(proxyHost, destHost);
        socket.getOutputStream().write(httpReq.getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String str = reader.readLine();
        int respCode = HttpSupport.getResponseCode(str);
        if (str != null) {
            while (!reader.readLine().equals("")) {
            }
        }
        if (respCode != 200) {
            throw new ConnectException("Could not connect to [" + destHost.toString() + "]: " + str);
        }
    }

    private static void connectToSocks4(Socket socket, HostInfo proxyHost, HostInfo destHost) throws ConnectException {
        byte[] req = new byte[9];
        req[0] = 4;
        req[1] = 1;
        byte[] portBytes = ConnectionSupport.portToBytes(destHost.getPort());
        req[2] = portBytes[0];
        req[3] = portBytes[1];
        byte[] ipBytes = ConnectionSupport.ipToBytes(destHost.getIp());
        int i = 0;
        while (i < ipBytes.length) {
            req[i + 4] = ipBytes[i];
            ++i;
        }
        try {
            socket.getOutputStream().write(req);
            byte[] resp = new byte[8];
            int len = socket.getInputStream().read(resp);
            if (len != 8 || resp[0] != 0 || resp[1] != 90) {
                throw new ConnectException("Failed to connect to Socks4 proxy server");
            }
        }
        catch (IOException e) {
            throw new ConnectException(e.toString());
        }
    }

    private static void connectToSocks5(Socket socket, HostInfo proxyHost, HostInfo destHost) throws ConnectException {
        try {
            byte[] req = new byte[120];
            byte[] resp = new byte[100];
            int reqLen = 0;
            int respLen = 0;
            req[0] = 5;
            if (proxyHost.needLogin()) {
                req[1] = 2;
                req[2] = 2;
                socket.getOutputStream().write(req, 0, 4);
                reqLen = socket.getInputStream().read(resp);
                if (reqLen != 2 || resp[1] != 2) {
                    throw new ConnectException("Failed to connect to Socks5 proxy server");
                }
                byte[] tempBytes = proxyHost.getUsername().getBytes();
                req[1] = (byte)tempBytes.length;
                respLen = ConnectionSupport.copyBytes(tempBytes, req, 2);
                tempBytes = proxyHost.getPassword().getBytes();
                req[respLen] = (byte)tempBytes.length;
                respLen = ConnectionSupport.copyBytes(tempBytes, req, respLen + 1);
                socket.getOutputStream().write(req, 0, respLen);
                reqLen = socket.getInputStream().read(resp);
                if (reqLen != 2 || resp[1] != 0) {
                    throw new ConnectException("Failed to connect to Socks5 proxy server");
                }
            } else {
                req[1] = 1;
                socket.getOutputStream().write(req, 0, 3);
                reqLen = socket.getInputStream().read(resp);
                if (reqLen != 2 || resp[1] != 0) {
                    throw new ConnectException("Failed to connect to Socks5 proxy server");
                }
            }
            req[1] = 1;
            req[2] = 0;
            req[3] = 1;
            ConnectionSupport.copyBytes(ConnectionSupport.ipToBytes(destHost.getIp()), req, 4);
            ConnectionSupport.copyBytes(ConnectionSupport.portToBytes(destHost.getPort()), req, 8);
            socket.getOutputStream().write(req, 0, 10);
            reqLen = socket.getInputStream().read(resp);
            if (reqLen != 10 || resp[1] != 0) {
                throw new ConnectException("Failed to connect to Socks5 proxy server");
            }
        }
        catch (IOException e) {
            throw new ConnectException(e.toString());
        }
    }

    private static byte[] portToBytes(int port) {
        byte[] result = new byte[2];
        byte low = 0;
        byte high = 0;
        high = (byte)(port / 256);
        low = (byte)(port % 256);
        result[0] = high;
        result[1] = low;
        return result;
    }

    private static byte[] ipToBytes(String ip) {
        int dot = 46;
        int p1 = ip.indexOf(dot);
        int b0 = Integer.parseInt(ip.substring(0, p1));
        int p2 = ip.indexOf(dot, ++p1);
        int b1 = Integer.parseInt(ip.substring(p1, p2));
        int p3 = ip.indexOf(dot, ++p2);
        int b2 = Integer.parseInt(ip.substring(p2, p3));
        int b3 = Integer.parseInt(ip.substring(++p3));
        byte[] result = new byte[]{(byte)b0, (byte)b1, (byte)b2, (byte)b3};
        return result;
    }

    private static int copyBytes(byte[] sour, byte[] dest, int offset) {
        int i = 0;
        while (i < sour.length) {
            dest[i + offset] = sour[i];
            ++i;
        }
        return offset + sour.length;
    }
}

