/*
 * Decompiled with CFR 0.152.
 */
package com.esms;

import com.esms.common.util.CommonUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostInfo {
    private String ip;
    private int port;
    private String username;
    private String password;
    private ConnectionType type = ConnectionType.DIRECT;
    private String ipRegex = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
    private String[] ipList;
    private int activeNum;
    private int changeMtCount = 0;

    public HostInfo(String ip, int port) {
        this.setHost(ip, port);
    }

    public void setHost(String ip, int port) {
        if (ip == null) {
            throw new IllegalArgumentException("Host Address Can Not Be Null!");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port out of range:" + port);
        }
        if (this.isValidIp(ip)) {
            this.ip = ip;
            this.port = port;
        } else {
            this.getIpList(ip);
            if (this.ipList.length == 0) {
                throw new IllegalArgumentException("Domain name get ip list is null!");
            }
            this.ip = this.ipList[0];
            this.port = port;
            this.activeNum = 0;
        }
    }

    private boolean isValidIp(String ip) {
        Pattern pattern = Pattern.compile(this.ipRegex);
        Matcher match = pattern.matcher(ip);
        return match.matches();
    }

    private void getIpList(String domainName) {
        InetAddress[] bupt = null;
        try {
            bupt = InetAddress.getAllByName(domainName);
            if (bupt != null && bupt.length > 0) {
                this.ipList = new String[bupt.length];
                int i = 0;
                while (i < bupt.length && i < 5) {
                    InetAddress add = bupt[i];
                    this.ipList[i] = add.getHostAddress();
                    System.out.println(add.getHostAddress());
                    ++i;
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public boolean changeHost() {
        if (this.ipList == null) {
            return false;
        }
        int size = this.ipList.length;
        if (size == 1) {
            return false;
        }
        if (this.changeMtCount >= size - 1) {
            this.changeMtCount = 0;
            return false;
        }
        if (this.activeNum < size - 1) {
            this.ip = this.ipList[++this.activeNum];
        } else {
            this.activeNum = 0;
            this.ip = this.ipList[this.activeNum];
        }
        ++this.changeMtCount;
        return true;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.valueOf(this.ip) + ":" + this.port;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HostInfo)) {
            return false;
        }
        HostInfo sockAddr = (HostInfo)obj;
        boolean sameIP = false;
        if (this.ip != null) {
            sameIP = this.ip.equals(sockAddr.ip);
        } else {
            boolean bl = sameIP = this.ip == null && sockAddr.ip == null;
        }
        return sameIP && this.port == sockAddr.port;
    }

    public boolean needLogin() {
        return CommonUtil.isNotBlank(this.username);
    }

    public final int hashCode() {
        if (this.ip != null) {
            return this.ip.hashCode() + this.port;
        }
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public void setType(ConnectionType type) {
        this.type = type;
    }

    public void setIp(String ip) {
        if (!CommonUtil.isIP(ip)) {
            throw new IllegalArgumentException("Invalid IP Address");
        }
        this.ip = ip;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port out of range:" + port);
        }
        this.port = port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        DIRECT(0),
        HTTP(1),
        SOCKET4(2),
        SOCKET5(3);

        private final int index;

        private ConnectionType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ConnectionType getType(int index) {
            switch (index) {
                case 0: {
                    return DIRECT;
                }
                case 1: {
                    return HTTP;
                }
                case 2: {
                    return SOCKET4;
                }
                case 3: {
                    return SOCKET5;
                }
            }
            return DIRECT;
        }
    }
}

