/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.httppool;

import esign.utils.asserts.b;
import esign.utils.exception.af;
import esign.utils.exception.ai;
import esign.utils.network.d;
import esign.utils.network.f;
import esign.utils.timeunit.TimeUnit;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPool {
    private PoolingHttpClientConnectionManager a;
    private d b;
    private static final int c = (int)TimeUnit.SECOND.unit(30).milliTick();
    private static final Logger d = LoggerFactory.getLogger(HttpPool.class);

    public HttpPool(int totalMax, int routeMax) {
        d poolConfig;
        this.b = poolConfig = new d().a(routeMax).b(totalMax);
    }

    public HttpPool() {
        this(20, 1);
    }

    public HttpPool(d poolConfig) {
        this.b = poolConfig;
    }

    public boolean a() {
        return this.a != null;
    }

    public void b() {
        if (!this.a()) {
            return;
        }
        this.a.shutdown();
        this.a.close();
        this.a = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient a(esign.utils.httpclient.a conf) throws ai {
        if (this.a()) {
            return this.a(this.a, conf);
        }
        HttpPool httpPool = this;
        synchronized (httpPool) {
            if (!this.a()) {
                this.a(this.b);
            }
            return this.a(this.a, conf);
        }
    }

    private CloseableHttpClient a(PoolingHttpClientConnectionManager connectionManager, esign.utils.httpclient.a conf) {
        RequestConfig requestConfig = this.b(conf);
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new a(conf.b()));
        if (null != conf.g()) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(conf.h(), conf.g());
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        if (!StringUtils.isEmpty((String)conf.c()) && 0 != conf.d()) {
            builder.setProxy(new HttpHost(conf.c(), conf.d()));
            builder.setUserAgent("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)");
        }
        return builder.build();
    }

    public CloseableHttpClient c() throws ai {
        return this.a(new esign.utils.httpclient.a());
    }

    public String d() throws ai {
        esign.utils.asserts.b.a(this.b, af.au.a("http pool config"));
        return this.b.d();
    }

    private void a(d config) throws ai {
        Registry<ConnectionSocketFactory> facs = this.e();
        this.a = this.a(facs);
        this.a = this.a(this.a, config);
    }

    private RequestConfig a(int connectTimeout, int requestTimeout, int socketTimeout) {
        return RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(requestTimeout).setSocketTimeout(socketTimeout).build();
    }

    private RequestConfig b(esign.utils.httpclient.a conf) {
        int connectTimeout = (int)(null == conf.l() ? (long)c : conf.l().milliTick());
        int requestTimeout = (int)(null == conf.m() ? (long)c : conf.m().milliTick());
        int poolTimout = (int)(null == conf.n() ? 0L : conf.n().milliTick());
        return this.a(connectTimeout, poolTimout, requestTimeout);
    }

    private PoolingHttpClientConnectionManager a(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        return mgr;
    }

    private PoolingHttpClientConnectionManager a(PoolingHttpClientConnectionManager mgr, d configMgr) {
        d.info("configure pool. {}", (Object)configMgr.d());
        mgr.setMaxTotal(configMgr.b().intValue());
        mgr.setDefaultMaxPerRoute(configMgr.c().intValue());
        Collection<f> configs = configMgr.a();
        for (f config : configs) {
            mgr.setMaxPerRoute(config.c(), config.b());
        }
        return mgr;
    }

    private Registry<ConnectionSocketFactory> e() throws ai {
        SSLContext sslContext;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)SeldefTrustStrategy.INSTANCE).build();
        }
        catch (Exception e2) {
            d.error("create ssl context failed.", (Throwable)e2);
            throw af.ag.a(e2);
        }
        SSLConnectionSocketFactory fac = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)SeldefHostnameVerifier.INSTANCE);
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)fac).build();
    }

    private class a
    implements HttpRequestRetryHandler {
        private int b;

        public a(int retry) {
            this.b = retry;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return executionCount < this.b;
        }
    }

    private static enum SeldefHostnameVerifier implements HostnameVerifier
    {
        INSTANCE;


        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static enum SeldefTrustStrategy implements TrustStrategy
    {
        INSTANCE;


        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

