/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.graphics.suites;

import com.timevale.seal.graphics.impl.f;
import com.timevale.seal.graphics.impl.m;
import com.timevale.seal.graphics.paragraph.TextRevision;
import com.timevale.seal.graphics.suites.GraphicsText;
import esign.utils.exception.ai;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class SuiteFixedText
extends GraphicsText
implements f {
    private TextRevision textRevision;

    public void cloneFrom(SuiteFixedText that) {
        super.cloneFrom(that);
        this.setTextRevision(that.getTextRevision());
    }

    @Override
    public void draw(Graphics2D g2, Integer canvasWidth, Integer canvasHeight) throws ai {
        this.drawLine(g2, canvasWidth, canvasHeight);
    }

    public TextRevision getTextRevision() {
        return this.textRevision;
    }

    public void setTextRevision(TextRevision textRevision) {
        this.textRevision = textRevision;
    }

    private int width(Graphics g2) {
        if (null == this.getFontRealWidth()) {
            Font font = this.getFont().getAwtFont(this.getFontSize());
            return g2.getFontMetrics(font).stringWidth(this.getText());
        }
        return this.getFontRealWidth() * this.getText().length();
    }

    private int singleWidth(Graphics g2) {
        if (null == this.getFontRealWidth()) {
            Font font = this.getFont().getAwtFont(this.getFontSize());
            return g2.getFontMetrics(font).stringWidth(this.getText()) / this.getText().length();
        }
        return this.getFontRealWidth();
    }

    private int singleHeight(Graphics g2) {
        if (null == this.getFontRealHeight()) {
            Font font = this.getFont().getAwtFont(this.getFontSize());
            return g2.getFontMetrics(font).getHeight();
        }
        return this.getFontRealHeight();
    }

    private int centeredLeft(Graphics2D g2) {
        return this.getX() + (this.getWidth() - this.width(g2)) / 2;
    }

    @Override
    public m construct(Graphics g2) {
        return new m(null, null, this.width(g2), this.singleHeight(g2));
    }

    @Override
    public void reinit(m r2) {
        if (null != r2.c()) {
            this.setWidth(r2.c());
        }
        if (null != r2.b()) {
            this.setY(r2.b());
        }
    }

    public void drawLine(Graphics2D g2, Integer canvasWidth, Integer canvasHeight) throws ai {
        if (TextRevision.NONE.equals((Object)this.textRevision)) {
            super.draw(g2, canvasWidth, canvasHeight);
            return;
        }
        if (TextRevision.CENTERED.equals((Object)this.textRevision)) {
            this.setX(this.centeredLeft(g2));
            super.draw(g2, canvasWidth, canvasHeight);
            return;
        }
        if (1 == this.getText().length()) {
            this.setX(this.getX() + this.getWidth() / 2);
            super.draw(g2, canvasWidth, canvasHeight);
            return;
        }
        g2.setFont(this.getFont().getAwtFont(this.getFontSize()));
        g2.setColor(this.getColor().getAwtColor());
        int count = this.getText().length();
        float space = (float)(this.getWidth() - this.singleWidth(g2)) / (float)(count - 1);
        char[] chars = this.getText().toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            float x2 = (float)i2 * space + (float)this.getX();
            this.setCharacter(chars[i2]);
            this.draw(x2, (float)this.getY(), g2);
        }
    }
}

