/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class IOUtil {
    public static byte[] addLength(byte[] bytes) {
        int totalLength = bytes.length + 4;
        byte[] lengthedArray = new byte[totalLength];
        System.arraycopy(IOUtil.intToByteArray(bytes.length), 0, lengthedArray, 0, 4);
        System.arraycopy(bytes, 0, lengthedArray, 4, bytes.length);
        return lengthedArray;
    }

    public static byte[] readLengthValue(InputStream inputStream) throws IOException {
        int receiveLength = IOUtil.readInt(inputStream);
        int bufferSize = receiveLength < 4096 ? receiveLength : 4096;
        byte[] read = IOUtil.read(inputStream, receiveLength, bufferSize);
        return read;
    }

    public static void sendLengthValue(OutputStream outputStream, byte[] sendBytes) throws IOException {
        outputStream.write(IOUtil.addLength(sendBytes));
        outputStream.flush();
    }

    public static byte[] read(InputStream inputStream, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int num = inputStream.read(buffer);
        while (num != -1) {
            baos.write(buffer, 0, num);
            num = inputStream.read(buffer);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static byte[] read(InputStream inputStream, int length, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int totalNum = 0;
        int num = 0;
        int readLength = bufferSize;
        while (totalNum < length) {
            num = inputStream.read(buffer, 0, readLength);
            if (num <= 0) {
                throw new EOFException();
            }
            baos.write(buffer, 0, num);
            readLength = length - (totalNum += num) > bufferSize ? bufferSize : length - totalNum;
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static byte[] intToByteArray(int i) {
        byte[] intBytes = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return intBytes;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] packageLength = IOUtil.read(inputStream, 4, 4);
        int r0 = packageLength[0] << 24;
        int r1 = 0xFF0000 & packageLength[1] << 16;
        int r2 = 0xFF00 & packageLength[2] << 8;
        int r3 = 0xFF & packageLength[3];
        int result = r0 + r1 + r2 + r3;
        if ((r0 | r1 | r2 | r3) < 0) {
            throw new EOFException();
        }
        return result;
    }

    public static Socket createSocket(String host, int port, int connectTimeout, int readTimeout) throws IOException {
        Socket socket = new Socket();
        socket.setReuseAddress(true);
        socket.setSoLinger(true, 0);
        if (readTimeout > 0) {
            socket.setSoTimeout(readTimeout);
        }
        socket.connect(new InetSocketAddress(host, port), connectTimeout);
        return socket;
    }
}

