/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class ExceptionUtil {
    private static Properties exceptionProperties = new Properties();

    public ExceptionUtil(String errorPropertiesFile) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(errorPropertiesFile);
            BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream));
            exceptionProperties.load(bf);
        }
        catch (Exception e) {
            throw new Exception("Can not load the error properties file in path " + errorPropertiesFile, e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public String getMessageByCode(String code) {
        String returnMessage = "Can not find code " + code + " in error properties file!";
        if (exceptionProperties.containsKey(code)) {
            try {
                returnMessage = new String(exceptionProperties.getProperty(code).getBytes("UTF-8"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                returnMessage = "UnsupportedEncodingException";
            }
        }
        return returnMessage;
    }

    public static String getStatckTreeInfo(Throwable thr) {
        StringBuffer resultBuffer = new StringBuffer();
        resultBuffer.append(thr.toString()).append('\n');
        StackTraceElement[] itemStackTraceElements = null;
        itemStackTraceElements = thr.getCause() != null ? thr.getCause().getStackTrace() : thr.getStackTrace();
        for (int i = 0; i < itemStackTraceElements.length; ++i) {
            StackTraceElement iterable_element = itemStackTraceElements[i];
            resultBuffer.append("Execption in Class:").append(iterable_element.getClassName());
            resultBuffer.append(",in Method ").append(iterable_element.getMethodName());
            resultBuffer.append(",at Line ").append(iterable_element.getLineNumber()).append('\n');
        }
        return resultBuffer.toString();
    }
}

