/*
 * Decompiled with CFR 0.152.
 */
package constant;

import util.ErrorPair;
import util.ExceptionUtil;
import util.StringUtil;

public class APIToolKitException
extends Exception {
    private static final long serialVersionUID = -7844006261455376450L;
    private static final String CATK_ERROR_PROPERTIES_NAME = "/apitkError_";
    private static final String CATK_ERROR_ZH_CN_PROPERTIES_PATH = "/apitkError_zh_CN.properties";
    public static final String ERROR_CODE_810001 = "810001";
    public static final String ERROR_CODE_810002 = "810002";
    public static final String ERROR_CODE_810003 = "810003";
    public static final String ERROR_CODE_810004 = "810004";
    public static final String ERROR_CODE_810005 = "810005";
    public static final String ERROR_CODE_810006 = "810006";
    public static final String ERROR_CODE_810007 = "810007";
    public static final String ERROR_CODE_810008 = "810008";
    public static final String ERROR_CODE_810009 = "810009";
    public static final String ERROR_CODE_810010 = "810010";
    public static final String ERROR_CODE_810011 = "810011";
    public static final String ERROR_CODE_810012 = "810012";
    public static final String ERROR_CODE_810016 = "810016";
    private String errCode = null;
    private String errDesc = null;
    private String errDetail = null;
    private Throwable history = null;
    private String language = null;
    private ExceptionUtil exceptionUtil;
    public static final ErrorPair CONN_CASERVER_FAIL = new ErrorPair("904104", "\u8fde\u63a5API\u5931\u8d25");

    public APIToolKitException(String errCode) {
        this(errCode, "zh_CN");
    }

    public APIToolKitException(String errCode, String language) {
        this.initExceptionUtil(language);
        this.errCode = errCode;
        this.errDesc = this.exceptionUtil.getMessageByCode(errCode);
        this.language = language;
    }

    public APIToolKitException(String errCode, Throwable history) {
        this(errCode, history, null);
    }

    public APIToolKitException(String errCode, Throwable history, String language) {
        this.initExceptionUtil(language);
        this.errCode = errCode;
        this.errDesc = this.exceptionUtil.getMessageByCode(errCode);
        this.history = history;
        this.language = language;
    }

    public APIToolKitException(String errCode, String errDesc, Throwable history) {
        this.errCode = errCode;
        this.errDesc = errDesc;
        this.history = history;
    }

    public APIToolKitException(String errCode, String errDesc, String errDetail) {
        this.errCode = errCode;
        this.errDesc = errDesc;
        this.errDetail = errDetail;
    }

    private void initExceptionUtil(String language) {
        try {
            this.exceptionUtil = StringUtil.isEmpty(language) || "zh_CN".equalsIgnoreCase(language) ? new ExceptionUtil(CATK_ERROR_ZH_CN_PROPERTIES_PATH) : new ExceptionUtil(CATK_ERROR_PROPERTIES_NAME + language + ".properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendMsg(String msg) {
        this.errDesc = this.errDesc + " " + msg;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrDesc() {
        return this.errDesc;
    }

    public void setErrDesc(String errDesc) {
        this.errDesc = errDesc;
    }

    public Throwable getHistory() {
        return this.history;
    }

    public String getErrDetail() {
        if (this.history != null) {
            this.errDetail = ExceptionUtil.getStatckTreeInfo(this.history);
        } else if (StringUtil.isEmpty(this.errDetail)) {
            this.errDetail = this.errDesc;
        }
        return this.errDetail;
    }

    public void setErrDetail(String errDetail) {
        this.errDetail = errDetail;
    }

    @Override
    public String getMessage() {
        StringBuffer msg = new StringBuffer();
        if ("en_US".equalsIgnoreCase(this.language)) {
            msg.append("Error code: ").append(this.errCode).append(", error message: ").append(this.errDesc);
        } else {
            msg.append("\u9519\u8bef\u7801\uff1a").append(this.errCode).append("\uff0c\u9519\u8bef\u4fe1\u606f\uff1a").append(this.errDesc);
        }
        return msg.toString();
    }

    @Override
    public String toString() {
        StringBuffer exString = new StringBuffer();
        if ("en_US".equalsIgnoreCase(this.language)) {
            exString.append("Error code: ").append(this.errCode).append(", error message: ").append(this.errDesc).append("\nError detail:").append(this.getErrDetail());
        } else {
            exString.append("\u9519\u8bef\u7801\uff1a").append(this.errCode).append("\uff0c\u9519\u8bef\u4fe1\u606f\uff1a").append(this.errDesc).append("\n\u5f02\u5e38\u5386\u53f2\uff1a").append(this.getErrDetail());
        }
        return exString.toString();
    }
}

