/*
 * Decompiled with CFR 0.152.
 */
package config;

import client.ClientSocket;
import client.ServerInfo;
import com.sun.org.apache.xml.internal.utils.ObjectPool;
import config.SystemEnvironment;
import constant.APIToolKitException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import logger.LoggerManager;
import util.StringUtil;

public class APIConfig {
    public static boolean skipLast;
    public static int maxRetryTimes;
    public static int retryInterval;
    public static ArrayList<ServerInfo> serverInfos;
    public static boolean isSocketTypeLong;
    public static int readTimeout;
    public static int connTimeout;
    public static boolean isInitFlag;
    public static int socketPoolSize;

    public static synchronized void initialize(String configFolderPath) throws APIToolKitException {
        if (!isInitFlag) {
            if (StringUtil.isEmpty(configFolderPath)) {
                configFolderPath = "./APIConfig";
            }
            try {
                LoggerManager.loadLogger(configFolderPath + File.separator + "logback-api.xml");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                APIConfig.loadApiProperties(configFolderPath + File.separator + "api.properties");
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("EnviromentConfig-loadApiProperties-Exception:", e);
                APIToolKitException exception = new APIToolKitException("810002", e, "zh_CN");
                exception.appendMsg("\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6 " + configFolderPath + File.separator + "api.properties");
                throw exception;
            }
            if (isSocketTypeLong) {
                SystemEnvironment.socketPool = new ObjectPool(ClientSocket.class, socketPoolSize);
                for (int i = 0; i < socketPoolSize; ++i) {
                    SystemEnvironment.socketPool.freeInstance(new ClientSocket(serverInfos));
                }
            }
            isInitFlag = true;
        }
    }

    private static boolean checkServerAlreadyExist(ServerInfo serverInfo) {
        boolean result = false;
        for (int i = 0; i < serverInfos.size(); ++i) {
            if (!serverInfos.get(i).getServerIp().equals(serverInfo.getServerIp()) || serverInfos.get(i).getServerPort() != serverInfo.getServerPort()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void loadApiProperties(String configFilePath) throws Exception {
        int socketPoolSizeTemp;
        Properties properties = new Properties();
        properties.load(new FileInputStream(configFilePath));
        String ipPortList = properties.getProperty("serverList");
        readTimeout = Integer.parseInt(properties.getProperty("read.timeout"));
        connTimeout = Integer.parseInt(properties.getProperty("conn.timeout"));
        retryInterval = Integer.parseInt(properties.getProperty("retryInterval"));
        maxRetryTimes = Integer.parseInt(properties.getProperty("maxRetryTimes"));
        skipLast = Boolean.parseBoolean(properties.getProperty("skipLast"));
        serverInfos = new ArrayList();
        String[] ipPortArray = ipPortList.split(";");
        for (int serverCount = 0; serverCount < ipPortArray.length; ++serverCount) {
            ServerInfo serverInfo = new ServerInfo();
            String[] serverIpAndPort = ipPortArray[serverCount].split(":");
            String serverIp = serverIpAndPort[0];
            String serverPort = serverIpAndPort[1];
            serverInfo.setServerIp(serverIp);
            serverInfo.setServerPort(Integer.parseInt(serverPort));
            serverInfo.setConnectTimeOut(connTimeout);
            serverInfo.setReadTimeOut(readTimeout);
            if (!APIConfig.checkServerAlreadyExist(serverInfo)) {
                serverInfos.add(serverInfo);
                LoggerManager.systemLogger.info("\u8f7d\u5165\u670d\u52a1\u5668 Ip: {}, Port {} \u6210\u529f!", (Object)serverIp, (Object)serverPort);
                continue;
            }
            LoggerManager.systemLogger.error("\u8f7d\u5165\u670d\u52a1\u5668 Ip: {}, Port {} \u5931\u8d25,\u8be5\u670d\u52a1\u5668\u5df2\u5b58\u5728! ", (Object)serverIp, (Object)serverPort);
        }
        isSocketTypeLong = Boolean.valueOf(properties.getProperty("isLongSocket"));
        String socketPoolSizeString = properties.getProperty("socketPoolSize");
        if (StringUtil.isNotEmpty(socketPoolSizeString) && (socketPoolSizeTemp = Integer.parseInt(socketPoolSizeString)) > 0) {
            socketPoolSize = socketPoolSizeTemp;
        }
    }

    static {
        isInitFlag = false;
        socketPoolSize = 5;
    }
}

