/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientSocket;
import config.APIConfig;
import config.SystemEnvironment;
import constant.APIToolKitException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import logger.LoggerManager;
import util.IOUtil;
import util.StringUtil;

public class DataSender {
    public static String sendAndGetResult(String message) throws APIToolKitException {
        if (APIConfig.isInitFlag) {
            String result = null;
            if (StringUtil.isNotEmpty(message)) {
                result = DataSender.handleSend(message);
            }
            return result;
        }
        APIToolKitException apiToolKitException = new APIToolKitException("810016");
        throw apiToolKitException;
    }

    public static String handleSend(String message) throws APIToolKitException {
        String result;
        block14: {
            result = null;
            LoggerManager.systemLogger.debug("\u8981\u53d1\u9001\u7684\u62a5\u6587{}", (Object)message);
            if (message != null) {
                ClientSocket clientSocket = null;
                try {
                    clientSocket = DataSender.getClientSocket();
                    if (clientSocket.getSocketConnected()) {
                        IOUtil.sendLengthValue(clientSocket.getSocket().getOutputStream(), message.getBytes("UTF-8"));
                        byte[] returnValue = IOUtil.readLengthValue(clientSocket.getSocket().getInputStream());
                        try {
                            String recieveResult = new String(returnValue, "UTF-8");
                            LoggerManager.systemLogger.debug("\u8fd4\u56de\u7ed3\u679c{},", (Object)recieveResult);
                            result = recieveResult;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            LoggerManager.exceptionLogger.error("UnsupportedEncodingException when new String (Constants.DEFAULT_CHARSET)", e);
                        }
                        break block14;
                    }
                    LoggerManager.exceptionLogger.error("\u62a5\u6587\u5904\u7406\u5f02\u5e38 SocketNotConnected");
                    APIToolKitException apiToolKitException = new APIToolKitException("810008");
                    apiToolKitException.appendMsg("IP " + clientSocket.getCurrentServerInfo().getServerIp() + " Port " + clientSocket.getCurrentServerInfo().getServerPort());
                    apiToolKitException.appendMsg("Socket Not Connected");
                    throw apiToolKitException;
                }
                catch (IOException e) {
                    boolean isReadTimeOutExecption = e instanceof SocketTimeoutException;
                    LoggerManager.exceptionLogger.error("\u62a5\u6587\u5904\u7406\u5f02\u5e38IOException  ", e);
                    if (APIConfig.isSocketTypeLong) {
                        clientSocket.dispose();
                    }
                    APIToolKitException apiToolKitException = isReadTimeOutExecption ? new APIToolKitException("810007") : new APIToolKitException("810008");
                    apiToolKitException.appendMsg("IP " + clientSocket.getCurrentServerInfo().getServerIp() + " Port " + clientSocket.getCurrentServerInfo().getServerPort());
                    throw apiToolKitException;
                }
                catch (InterruptedException e) {
                    LoggerManager.exceptionLogger.error("InterruptedException ", e);
                    APIToolKitException apiToolKitException = new APIToolKitException("810004");
                    throw apiToolKitException;
                }
                finally {
                    if (clientSocket != null) {
                        if (APIConfig.isSocketTypeLong) {
                            SystemEnvironment.socketPool.freeInstance(clientSocket);
                        } else {
                            clientSocket.dispose();
                        }
                    }
                }
            }
        }
        return result;
    }

    public static ClientSocket getClientSocket() throws InterruptedException {
        ClientSocket clientSocket = APIConfig.isSocketTypeLong ? (ClientSocket)SystemEnvironment.socketPool.getInstanceIfFree() : new ClientSocket(APIConfig.serverInfos);
        int reTryCount = 0;
        while (clientSocket == null) {
            if (++reTryCount > APIConfig.maxRetryTimes) {
                LoggerManager.exceptionLogger.error("\u91cd\u8bd5\u8d85\u8fc7{}\u6b21,\u672a\u5728\u8fde\u63a5\u6c60\u4e2d\u83b7\u5f97\u53ef\u7528\u8d44\u6e90,\u8bf7\u4fee\u6539\u914d\u7f6e\uff0c\u653e\u5f03\u8fde\u63a5", (Object)APIConfig.maxRetryTimes);
                break;
            }
            LoggerManager.systemLogger.info("\u8fde\u63a5\u6c60\u4e2d\u65e0\u53ef\u7528\u8d44\u6e90  \u7b49\u5f85 {} ms", (Object)APIConfig.retryInterval);
            if (APIConfig.isSocketTypeLong) {
                clientSocket = (ClientSocket)SystemEnvironment.socketPool.getInstanceIfFree();
            }
            Thread.sleep(APIConfig.retryInterval);
        }
        reTryCount = 0;
        while (!clientSocket.getSocketConnected()) {
            LoggerManager.exceptionLogger.error("\u670d\u52a1\u5668\u8fde\u63a5\u4e0d\u53ef\u7528, IP: {}, Port: {}", (Object)clientSocket.getCurrentServerInfo().getServerIp(), (Object)clientSocket.getCurrentServerInfo().getServerPort());
            if (++reTryCount > APIConfig.maxRetryTimes) {
                LoggerManager.exceptionLogger.error("\u91cd\u8fde\u8d85\u8fc7{}\u6b21,\u653e\u5f03\u91cd\u8fde", (Object)APIConfig.maxRetryTimes);
                break;
            }
            try {
                Thread.sleep(APIConfig.retryInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LoggerManager.systemLogger.info("\u91cd\u65b0\u521b\u5efa\u8fde\u63a5...");
            clientSocket.connectToServer();
            LoggerManager.systemLogger.info("\u91cd\u65b0\u521b\u5efa\u8fde\u63a5\u7b2c {} \u6b21,\u91cd\u8fde\u670d\u52a1\u5668\u5730\u5740\uff1a{}", (Object)String.valueOf(reTryCount), (Object)(clientSocket.getCurrentServerInfo().getServerIp() + "\uff1a" + clientSocket.getCurrentServerInfo().getServerPort()));
        }
        return clientSocket;
    }
}

