/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ServerInfo;
import config.APIConfig;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Random;
import logger.LoggerManager;
import util.IOUtil;

public class ClientSocket {
    private ArrayList<ServerInfo> serverInfos;
    private int serverIndex = -1;
    private Socket socket;

    public ClientSocket(ArrayList<ServerInfo> serverInfos) {
        this.serverInfos = serverInfos;
        this.connectToServer();
    }

    public void connectToServer() {
        int temServerIndex = new Random().nextInt(this.serverInfos.size());
        if (this.serverInfos.size() > 1 && APIConfig.skipLast) {
            while (temServerIndex == this.serverIndex) {
                LoggerManager.debugLogger.debug("\u670d\u52a1\u5668 {} \u4e0e\u4e0a\u6b21\u5931\u8d25\u670d\u52a1\u5668\u91cd\u590d", (Object)temServerIndex);
                temServerIndex = new Random().nextInt(this.serverInfos.size());
                LoggerManager.debugLogger.debug("\u91cd\u65b0\u9009\u62e9\u670d\u52a1\u5668 {}", (Object)temServerIndex);
            }
        }
        this.serverIndex = temServerIndex;
        LoggerManager.debugLogger.debug("\u9009\u5b9a\u670d\u52a1\u5668 {} ", (Object)this.serverIndex);
        ServerInfo serverInfo = this.serverInfos.get(this.serverIndex);
        LoggerManager.debugLogger.debug("\u9009\u5b9a\u670d\u52a1\u5668IP {} ,\u7aef\u53e3 {} ", (Object)serverInfo.getServerIp(), (Object)serverInfo.getServerPort());
        try {
            this.socket = IOUtil.createSocket(serverInfo.getServerIp(), serverInfo.getServerPort(), serverInfo.getConnectTimeOut(), serverInfo.getReadTimeOut());
            LoggerManager.systemLogger.info("\u8fde\u63a5\u670d\u52a1\u5668\u6210\u529f IP {} , Port {} ", (Object)serverInfo.getServerIp(), (Object)serverInfo.getServerPort());
        }
        catch (IOException e) {
            LoggerManager.exceptionLogger.error("\u521b\u5efaSocket \u8fde\u63a5\u51fa\u9519,\u670d\u52a1\u7aefIP {},\u7aef\u53e3 {}", (Object)serverInfo.getServerIp(), (Object)serverInfo.getServerPort());
        }
    }

    public void dispose() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LoggerManager.exceptionLogger.error("Close Socket failed", e);
        }
    }

    public boolean getSocketConnected() {
        boolean result = false;
        if (this.socket != null) {
            result = !this.socket.isClosed();
        }
        return result;
    }

    public ServerInfo getCurrentServerInfo() {
        return this.serverInfos.get(this.serverIndex);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getServerIndex() {
        return this.serverIndex;
    }

    public void setServerIndex(int serverIndex) {
        this.serverIndex = serverIndex;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }
}

