/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.ws.utils;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClient {
    public static synchronized String callHttpService(String wsdl, String methodName, Object[] data) throws Exception {
        String returnStr = null;
        JaxWsDynamicClientFactory clientFactory = JaxWsDynamicClientFactory.newInstance();
        Client client = clientFactory.createClient(wsdl);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setAllowChunking(false);
        policy.setConnectionTimeout(60000L);
        policy.setReceiveTimeout(60000L);
        conduit.setClient(policy);
        Object[] result = client.invoke(methodName, data);
        returnStr = result[0].toString();
        return returnStr;
    }

    public static String callHttpsService(String wsdl, String jksFilePath, String password, String methodName, Object[] data) throws Exception {
        String returnStr = null;
        TLSClientParameters HttpsParams = WSClient.getHttpsParams(jksFilePath, password);
        JaxWsDynamicClientFactory clientFactory = JaxWsDynamicClientFactory.newInstance();
        Client client = clientFactory.createClient(wsdl);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setAllowChunking(false);
        policy.setConnectionTimeout(180000L);
        policy.setReceiveTimeout(180000L);
        conduit.setClient(policy);
        conduit.setTlsClientParameters(HttpsParams);
        Object[] result = client.invoke(methodName, data);
        returnStr = result[0].toString();
        return returnStr;
    }

    private static TLSClientParameters getHttpsParams(String jksFilePath, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        TLSClientParameters tlsClientParameters = new TLSClientParameters();
        tlsClientParameters.setDisableCNCheck(true);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(jksFilePath), password.toCharArray());
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(keyStore);
        tlsClientParameters.setTrustManagers(trustFactory.getTrustManagers());
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(keyStore, password.toCharArray());
        tlsClientParameters.setKeyManagers(keyFactory.getKeyManagers());
        return tlsClientParameters;
    }

    public static void callHttpPost(String url, Map<String, String> data) {
        try {
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
            CloseableHttpResponse httpresponse = client.execute((HttpUriRequest)httppost);
            HttpEntity entity = httpresponse.getEntity();
            String body = EntityUtils.toString((HttpEntity)entity);
            System.out.println(body);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void callHttpPost(String url, String data) {
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).build();
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            CloseableHttpResponse httpresponse = client.execute((HttpUriRequest)httppost);
            HttpEntity entity = httpresponse.getEntity();
            String body = EntityUtils.toString((HttpEntity)entity);
            System.out.println(body);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String callHttpsPost(String url, String data, Map<String, String> sslParams) throws Exception {
        InputStream ksIn = null;
        InputStream tsIn = null;
        try {
            String KEY_STORE_TRUST_PATH = sslParams.get("KEY_STORE_TRUST_PATH");
            String KEY_STORE_TYPE_JKS = sslParams.get("KEY_STORE_TYPE_JKS");
            String KEY_STORE_TRUST_PASSWORD = sslParams.get("KEY_STORE_TRUST_PASSWORD");
            String KEY_STORE_CLIENT_PATH = sslParams.get("KEY_STORE_CLIENT_PATH");
            String KEY_STORE_TYPE_P12 = sslParams.get("KEY_STORE_TYPE_P12");
            KeyStore trustStore = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE_P12);
            ksIn = new FileInputStream(KEY_STORE_CLIENT_PATH);
            tsIn = new FileInputStream(KEY_STORE_TRUST_PATH);
            keyStore.load(ksIn, KEY_STORE_TRUST_PASSWORD.toCharArray());
            trustStore.load(tsIn, KEY_STORE_TRUST_PASSWORD.toCharArray());
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(keyStore, KEY_STORE_TRUST_PASSWORD.toCharArray()).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(100);
            connManager.setDefaultMaxPerRoute(10);
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            HttpClientContext context = HttpClientContext.create();
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                ksIn.close();
                tsIn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String callHttpsPost(String url, Map<String, String> data, Map<String, String> sslParams) throws Exception {
        InputStream ksIn = null;
        InputStream tsIn = null;
        try {
            String KEY_STORE_TRUST_PATH = sslParams.get("KEY_STORE_TRUST_PATH");
            String KEY_STORE_TYPE_JKS = sslParams.get("KEY_STORE_TYPE_JKS");
            String KEY_STORE_TRUST_PASSWORD = sslParams.get("KEY_STORE_TRUST_PASSWORD");
            String KEY_STORE_CLIENT_PATH = sslParams.get("KEY_STORE_CLIENT_PATH");
            String KEY_STORE_TYPE_P12 = sslParams.get("KEY_STORE_TYPE_P12");
            KeyStore trustStore = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE_P12);
            ksIn = new FileInputStream(KEY_STORE_CLIENT_PATH);
            tsIn = new FileInputStream(KEY_STORE_TRUST_PATH);
            keyStore.load(ksIn, KEY_STORE_TRUST_PASSWORD.toCharArray());
            trustStore.load(tsIn, KEY_STORE_TRUST_PASSWORD.toCharArray());
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(keyStore, KEY_STORE_TRUST_PASSWORD.toCharArray()).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(100);
            connManager.setDefaultMaxPerRoute(10);
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            HttpClientContext context = HttpClientContext.create();
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                ksIn.close();
                tsIn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String rt1 = WSClient.callHttpService("http://172.16.4.150:7010/services/RFPService?wsdl", "login", new String[]{"<msg><title>16999957-7</title><head>BDxBHF/DglQERL9eLtEiUzTXKgtpKvgEuBiCKJ3S+GIGjkmtEbgqnOXhxbW6SZHl5kQO6mRWw18I1TttfF6/Z5oSp4+AHj+Pyx6aAQvD4xrT4ngt9qvbU+BAx1osaLlvDXo/R3wPE4qhv2T0scbSNuyExVKiykLQJ4KA0Sa++wD1mlHaDUjTv9mxT1Rbvj4AEsM/xfYUqUM97DPsJFAoHRXwYtdZxEkg1di0Mum823FBEYmjSnc4WNIlAXvMidtcm2EHE5uHAJbzV/AcX8kRPLYk1kw3CspqYDhKOazPYBDOd9Otn8g/JIzoJdZsTNIaCkqndcVuIi2dbRKhcZvNRYec1k1/DgIHdobw7ZQEng5yOoJXcPQj7pitvIXPiKd6o+1wnG0NXn3acWsluRMfJkorkjQHHlEh8+0mEig8VIM3s6xpsHBu2jpwx8TDBQEvvUkPlbhLRmTVjfFXQYeqGUnZWZNVCjrd84qDL3LnDQ==</head><body>BF0iCyDk87FLotkEYSi5sOqRgKHfaFrca7KoXhONOFjkIJrKVFcDohLkNpYDQPfhVMqhAk7XHhirkW9U3a7vJrRMykoZ5FCzb6Q+xWy1qgGdGsI0PV0JE/nin+2R0H139u3qpDvMGydbxkCC/nUMCstR56eeECdeFPAK9SIv9ozTuDJwgcaj/s9eXxH8FFFgNKil4lFdWz3UYh2lMOg=</body></msg>"});
        System.out.println(rt1);
        String ret = WSClient.callHttpsService("https://ws.crcrfsp.com:7043/services/RFPService?wsdl", "E:/key/client.keystore", "123456", "login", new String[]{"<msg><title>16999957-7</title><head>BDxBHF/DglQERL9eLtEiUzTXKgtpKvgEuBiCKJ3S+GIGjkmtEbgqnOXhxbW6SZHl5kQO6mRWw18I1TttfF6/Z5oSp4+AHj+Pyx6aAQvD4xrT4ngt9qvbU+BAx1osaLlvDXo/R3wPE4qhv2T0scbSNuyExVKiykLQJ4KA0Sa++wD1mlHaDUjTv9mxT1Rbvj4AEsM/xfYUqUM97DPsJFAoHRXwYtdZxEkg1di0Mum823FBEYmjSnc4WNIlAXvMidtcm2EHE5uHAJbzV/AcX8kRPLYk1kw3CspqYDhKOazPYBDOd9Otn8g/JIzoJdZsTNIaCkqndcVuIi2dbRKhcZvNRYec1k1/DgIHdobw7ZQEng5yOoJXcPQj7pitvIXPiKd6o+1wnG0NXn3acWsluRMfJkorkjQHHlEh8+0mEig8VIM3s6xpsHBu2jpwx8TDBQEvvUkPlbhLRmTVjfFXQYeqGUnZWZNVCjrd84qDL3LnDQ==</head><body>BF0iCyDk87FLotkEYSi5sOqRgKHfaFrca7KoXhONOFjkIJrKVFcDohLkNpYDQPfhVMqhAk7XHhirkW9U3a7vJrRMykoZ5FCzb6Q+xWy1qgGdGsI0PV0JE/nin+2R0H139u3qpDvMGydbxkCC/nUMCstR56eeECdeFPAK9SIv9ozTuDJwgcaj/s9eXxH8FFFgNKil4lFdWz3UYh2lMOg=</body></msg>"});
        System.out.println(ret);
    }
}

