/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.ws.utils;

import com.rfp.base.BaseCipher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Base64;

public class ECCUtils
extends BaseCipher {
    private static final String ALGORITHM = "ECIES";

    public static PublicKey loadPublicKey(String filePath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(filePath));
            String readLine = null;
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return ECCUtils.getPublicKey(sb.toString());
    }

    public static PrivateKey loadPrivateKey(String filePath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(filePath));
            String readLine = null;
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return ECCUtils.getPrivateKey(sb.toString());
    }

    @Deprecated
    public static PublicKey getPublicKey(String publicKeyStr) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.decode(publicKeyStr);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePublic(x509KeySpec);
    }

    @Deprecated
    public static PrivateKey getPrivateKey(String privateKeyStr) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.decode(privateKeyStr);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    private static byte[] encryptFile(String filePath, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException {
        byte[] buff = new byte[1024];
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, publicKey);
        FileInputStream fis = null;
        CipherInputStream cis = null;
        FileOutputStream fos = null;
        CipherOutputStream cos = null;
        try {
            int r;
            fis = new FileInputStream(filePath);
            cis = new CipherInputStream(fis, cipher);
            fos = new FileOutputStream("");
            cos = new CipherOutputStream(fos, cipher);
            cis.available();
            while ((r = cis.read(buff)) != -1) {
                cos.write(buff, 0, r);
            }
        }
        finally {
            if (cos != null) {
                cos.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (cis != null) {
                cis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return buff;
    }

    public static String encrypt(String data, PublicKey publicKey) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        String mi = null;
        Cipher cipher = Cipher.getInstance(ALGORITHM, "BC");
        cipher.init(1, publicKey);
        mi = Base64.toBase64String(cipher.doFinal(data.getBytes()));
        return mi;
    }

    private static String encryptByUTF8(String data, PublicKey publicKey) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, UnsupportedEncodingException {
        String mi = null;
        Cipher cipher = Cipher.getInstance(ALGORITHM, "BC");
        cipher.init(1, publicKey);
        mi = Base64.toBase64String(cipher.doFinal(data.getBytes("UTF-8")));
        return mi;
    }

    public static String encrypt(String data, File publicFile) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        PublicKey publicKey = null;
        publicKey = ECCUtils.loadPublicKey(publicFile.getAbsolutePath());
        return ECCUtils.encrypt(data, publicKey);
    }

    private static String encryptByUTF8(String data, File publicFile) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        PublicKey publicKey = null;
        publicKey = ECCUtils.loadPublicKey(publicFile.getAbsolutePath());
        return ECCUtils.encryptByUTF8(data, publicKey);
    }

    public static String encrypt(String data, String keyPath) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, NoSuchPaddingException {
        PublicKey publicKey = null;
        publicKey = ECCUtils.loadPublicKey(keyPath);
        return ECCUtils.encrypt(data, publicKey);
    }

    public static String encryptByUTF8(String data, String keyPath) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, NoSuchPaddingException {
        PublicKey publicKey = null;
        publicKey = ECCUtils.loadPublicKey(keyPath);
        return ECCUtils.encryptByUTF8(data, publicKey);
    }

    public static String encryptByKeyUTF8(String data, String key) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, NoSuchPaddingException {
        PublicKey publicKey = null;
        publicKey = ECCUtils.getPublicKey(key);
        return ECCUtils.encryptByUTF8(data, publicKey);
    }

    public static String decrypt(String data, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(Base64.decode(data)));
    }

    private static String decryptByUTF8(String data, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(Base64.decode(data)), "UTF-8");
    }

    public static String decrypt(String data, File privateFile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey privateKey = ECCUtils.loadPrivateKey(privateFile.getAbsolutePath());
        return ECCUtils.decrypt(data, privateKey);
    }

    private static String decryptByUTF8(String data, File privateFile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey privateKey = ECCUtils.loadPrivateKey(privateFile.getAbsolutePath());
        return ECCUtils.decryptByUTF8(data, privateKey);
    }

    public static String decrypt(String data, String keyPath) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey privateKey = ECCUtils.loadPrivateKey(keyPath);
        return ECCUtils.decrypt(data, privateKey);
    }

    public static String decryptByUTF8(String data, String keyPath) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey privateKey = ECCUtils.loadPrivateKey(keyPath);
        return ECCUtils.decryptByUTF8(data, privateKey);
    }

    public static String decryptByKeyUTF8(String data, String key) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey privateKey = ECCUtils.getPrivateKey(key);
        return ECCUtils.decryptByUTF8(data, privateKey);
    }

    private static String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        int i = 0;
        while (i < x + z) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
            ++i;
        }
        return strings;
    }

    private static byte[] FileToBytes(String filePath) throws IOException {
        FileInputStream fis = null;
        byte[] buffer = null;
        try {
            try {
                File file = new File(filePath);
                int length = (int)file.length();
                fis = new FileInputStream(file);
                buffer = new byte[length];
                fis.read(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return buffer;
    }
}

