/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.sm.utils;

import java.io.IOException;
import java.math.BigInteger;

class Util {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    Util() {
    }

    public static byte[] changeCharset(String data, String charset) throws IOException {
        return new String(data.getBytes(charset), "UTF-8").getBytes();
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
            ++i;
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            int i = 0;
            while (i < 32 - n.toByteArray().length) {
                tmpd[i] = 0;
                ++i;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String getHexString(byte[] bytes) {
        return Util.getHexString(bytes, true);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        String ret = "";
        int i = 0;
        while (i < bytes.length) {
            ret = String.valueOf(ret) + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return upperCase ? ret.toUpperCase() : ret;
    }

    public static void printHexString(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            System.out.print("0x" + hex.toUpperCase() + ",");
            ++i;
        }
        System.out.println("");
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(Util.charToByte(hexChars[pos]) << 4 | Util.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] data) {
        return Util.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Util.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return Util.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return Util.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexString(byte[] data, char[] toDigits) {
        return new String(Util.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Util.toDigit(data[j], j) << 4;
            f |= Util.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String StringToAsciiString(String content) {
        String result = "";
        int max = content.length();
        int i = 0;
        while (i < max) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result = String.valueOf(result) + b;
            ++i;
        }
        return result;
    }

    public static String hexStringToString(String hexString, int encodeType) {
        String result = "";
        int max = hexString.length() / encodeType;
        int i = 0;
        while (i < max) {
            char c = (char)Util.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result = String.valueOf(result) + c;
            ++i;
        }
        return result;
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        int i = max;
        while (i > 0) {
            char c = hex.charAt(i - 1);
            int algorism = 0;
            algorism = c >= '0' && c <= '9' ? c - 48 : c - 55;
            result = (int)((double)result + Math.pow(16.0, max - i) * (double)algorism);
            --i;
        }
        return result;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        String result = "";
        int max = hex.length();
        int i = 0;
        while (i < max) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result = String.valueOf(result) + "0000";
                    break;
                }
                case '1': {
                    result = String.valueOf(result) + "0001";
                    break;
                }
                case '2': {
                    result = String.valueOf(result) + "0010";
                    break;
                }
                case '3': {
                    result = String.valueOf(result) + "0011";
                    break;
                }
                case '4': {
                    result = String.valueOf(result) + "0100";
                    break;
                }
                case '5': {
                    result = String.valueOf(result) + "0101";
                    break;
                }
                case '6': {
                    result = String.valueOf(result) + "0110";
                    break;
                }
                case '7': {
                    result = String.valueOf(result) + "0111";
                    break;
                }
                case '8': {
                    result = String.valueOf(result) + "1000";
                    break;
                }
                case '9': {
                    result = String.valueOf(result) + "1001";
                    break;
                }
                case 'A': {
                    result = String.valueOf(result) + "1010";
                    break;
                }
                case 'B': {
                    result = String.valueOf(result) + "1011";
                    break;
                }
                case 'C': {
                    result = String.valueOf(result) + "1100";
                    break;
                }
                case 'D': {
                    result = String.valueOf(result) + "1101";
                    break;
                }
                case 'E': {
                    result = String.valueOf(result) + "1110";
                    break;
                }
                case 'F': {
                    result = String.valueOf(result) + "1111";
                }
            }
            ++i;
        }
        return result;
    }

    public static String AsciiStringToString(String content) {
        String result = "";
        int length = content.length() / 2;
        int i = 0;
        while (i < length) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = Util.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result = String.valueOf(result) + d;
            ++i;
        }
        return result;
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return Util.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytearray) {
        String result = "";
        int length = bytearray.length;
        int i = 0;
        while (i < length) {
            char temp = (char)bytearray[i];
            result = String.valueOf(result) + temp;
            ++i;
        }
        return result;
    }

    public static int binaryToAlgorism(String binary) {
        int max = binary.length();
        int result = 0;
        int i = max;
        while (i > 0) {
            char c = binary.charAt(i - 1);
            int algorism = c - 48;
            result = (int)((double)result + Math.pow(2.0, max - i) * (double)algorism);
            --i;
        }
        return result;
    }

    public static String algorismToHEXString(int algorism) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        String temp = "";
        int i = 0;
        while (i < maxLength - str.length()) {
            temp = "0" + temp;
            ++i;
        }
        str = (String.valueOf(temp) + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    public static byte[] subByte(byte[] input, int startIndex, int length) {
        byte[] bt = new byte[length];
        int i = 0;
        while (i < length) {
            bt[i] = input[i + startIndex];
            ++i;
        }
        return bt;
    }
}

