/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.sm.utils;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

class SM2 {
    private static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    private final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    private final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    private final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    private final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    private final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    private final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    final ECCurve ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b, null, null);
    private final ECPoint ecc_point_g = this.ecc_curve.createPoint(this.ecc_gx, this.ecc_gy);
    private final ECDomainParameters ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
    final ECKeyPairGenerator ecc_key_pair_generator;

    public static SM2 Instance() {
        return new SM2();
    }

    private SM2() {
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init(ecc_ecgenparam);
    }
}

