package com.hand.hap.intergration.service.impl;

import com.github.pagehelper.StringUtil;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.beans.HapTransferDataMapper;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapAuthenticationService;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

import com.hand.hap.intergration.utils.HttpUtil;
import net.sf.json.JSONNull;
import com.alibaba.fastjson.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.DefaultValueProcessor;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HapRestApiServiceImpl implements IHapApiService {
    private final Logger logger = LoggerFactory.getLogger(HapRestApiServiceImpl.class);
    private final static String APPLICATION_JSON = "application/json";
    private final static String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private final static String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final static int HTTP_OK = 200;
    private final static int HTTP_401 = 401;
    @Autowired
    private IHapAuthenticationService authenticationService;

    public HapRestApiServiceImpl() {
    }

    /**
     * @param url
     * @param interfaceHeader
     * @param params
     * @return
     */
    private String sendPost(String url, HapInterfaceHeader interfaceHeader, JSONObject params) throws Exception {

        HttpResponse execute = null;
        JSONObject headers = new JSONObject();
        String requestContentType = "";
        JSONObject responseBody = new JSONObject();
        int httpReponseCode;
        if (interfaceHeader.getRequestContentType() != null) {
            requestContentType = interfaceHeader.getRequestContentType().toLowerCase();
        } else {
            requestContentType = "application/json";
        }
        if (interfaceHeader.getAuthFlag().equals("Y")) {
            headers = this.processAuthAuthorization(interfaceHeader);
        }
        headers.put("Content-Type", requestContentType);
        if (requestContentType.contains(APPLICATION_JSON)) {
            execute = HttpUtil.postJson(url, params, headers);
        } else if (requestContentType.contains(APPLICATION_FORM_URLENCODED)) {
            execute = HttpUtil.postFormUrlEncoded(url, params, headers);
        } else if (requestContentType.contains(APPLICATION_OCTET_STREAM)) {
            execute = HttpUtil.postOcStremJson(url, params, headers);
        } else {
            execute = HttpUtil.postJson(url, params, headers);
        }

        if (execute != null) {
            httpReponseCode = execute.getStatusLine().getStatusCode();
            //响应信息
            if (httpReponseCode != HTTP_OK) {
                if (httpReponseCode == HTTP_401) {
                    this.authenticationService.updateToken(interfaceHeader);
                }
                responseBody.put("code", httpReponseCode);
                responseBody.put("message", execute.getStatusLine().getReasonPhrase());
                return responseBody.toString();
            } else {
                String httpResult = HttpUtil.HttpResponseParseJson(execute);
                return httpResult;
            }
        } else {
            return "";
        }
    }

    /**
     * @param url
     * @param interfaceHeader
     * @param params
     * @return
     */
    private String sendGet(String url, HapInterfaceHeader interfaceHeader, JSONObject params) throws Exception {
        HttpResponse execute = null;
        JSONObject headers = new JSONObject();
        String requestContentType = "";
        JSONObject responseBody = new JSONObject();
        int httpReponseCode;
        if (params != null && params.size() > 0) {
            url += "?";
            StringBuffer parm = new StringBuffer();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                parm.append(key + "=" + URLEncoder.encode(entry.getValue().toString(), "utf-8") + "&");
            }
            String p = parm.substring(0, parm.length() - 1);
            url += p;
        }
        //请求URL
        requestContentType = interfaceHeader.getRequestContentType();
        if (interfaceHeader.getRequestContentType() != null) {
            requestContentType = interfaceHeader.getRequestContentType().toLowerCase();
        } else {
            requestContentType = "application/json";
        }
        if (interfaceHeader.getAuthFlag().equals("Y")) {
            headers = this.processAuthAuthorization(interfaceHeader);
        }
        headers.put("Content-Type", requestContentType);
        execute = HttpUtil.getJson(url, headers);
        if (execute != null) {
            httpReponseCode = execute.getStatusLine().getStatusCode();
            if (httpReponseCode != HTTP_OK) {
                if (httpReponseCode == HTTP_401) {
                    this.authenticationService.updateToken(interfaceHeader);
                }
                responseBody.put("code", httpReponseCode);
                responseBody.put("message", execute.getStatusLine().getReasonPhrase());
                return responseBody.toString();
            } else {
                String httpResult = HttpUtil.HttpResponseParseJson(execute);
                return httpResult;
            }
        } else {
            return "";
        }

    }

    public JSONObject invoke(HapInterfaceHeader headerAndLineDTO, JSONObject inbound) throws Exception {
        String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        this.logger.info("request url:{}", url);
        String data = null;
        JSONObject json = null;
        String inboundParam = " ";
        HapTransferDataMapper mapper = null;
        if (StringUtil.isNotEmpty(headerAndLineDTO.getMapperClass())) {
            ClassLoader jsonConfig = Thread.currentThread().getContextClassLoader();

            try {
                Class e = jsonConfig.loadClass(headerAndLineDTO.getMapperClass());
                mapper = (HapTransferDataMapper) e.newInstance();
            } catch (ClassNotFoundException var10) {
                this.logger.error("ClassNotFoundException:" + var10.getMessage());
                throw var10;
            } catch (InstantiationException var11) {
                this.logger.error("InstantiationException:" + var11.getMessage());
                throw var11;
            } catch (IllegalAccessException var12) {
                this.logger.error("IllegalAccessException:" + var12.getMessage());
                throw var12;
            }
        }
        if (mapper != null) {
            inboundParam = mapper.requestDataMap(inbound);
            inbound = JSONObject.parseObject(inboundParam);
        }
        if (headerAndLineDTO.getRequestMethod().equals("POST")) {
            if (inbound != null) {
                inboundParam = inbound.toString();
            }
            if (url.contains(".svc") || url.contains(".lsc")) {
                inboundParam = "{\"_request_data\"" + ":" + "{\"parameter\":" + inboundParam + "}}";
            }
            inbound = JSONObject.parseObject(inboundParam);
            this.logger.info("params Xml :{}", inboundParam);
            data = this.sendPost(url, headerAndLineDTO, inbound);
        } else if (headerAndLineDTO.getRequestMethod().equals("GET")) {
            data = this.sendGet(url, headerAndLineDTO, inbound);
        }
        json = JSONObject.parseObject(data);
        return json;
    }
    private JSONObject processAuthAuthorization(HapInterfaceHeader headerAndLineDTO) throws Exception {
        String accessToken;
        JSONObject headers = new JSONObject();
        if ("BASIC_AUTH".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
            String e = headerAndLineDTO.getAuthUsername() + ":" + headerAndLineDTO.getAuthPassword();
            accessToken = new String(Base64.encodeBase64(e.getBytes()));
            headers.put("Authorization", "Basic " + accessToken);
        } else if ("OAUTH2".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
            accessToken = this.authenticationService.getToken(headerAndLineDTO);
            if (StringUtil.isEmpty(accessToken)) {
                this.logger.error("get access_token failure,check your config");
            }
            headers.put("Authorization", "Bearer " + accessToken);
        }
        return headers;

    }
}
