package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2017/7/24
 * Time: 10:19
 * To change this template use File | Settings | File Templates.
 */
@UITag
public class HlsNavigationBar extends Component {
    public static final String PROPERTITY_NAVIGATIONBARTITLE = "navigationBarTitle";
    public static final String PROPERTITY_NAVIGATIONBAR = "navigationBar";
    public static final String PROPERTITY_NAVIGATIONBARCONTENT = "navigationBarContent";
    public static final String PROPERTITY_TREETITLE = "treeTitle";
    public static final String PROPERTITY_NAVIGATIONBARID = "navigationbarId";
    public static final String PROPERTITY_NAVIGATIONBARCLASS = "navigationbarClass";

    public static HlsNavigationBar createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE, PROPERTITY_NAVIGATIONBAR);
        HlsNavigationBar HlsNavigationBar = new HlsNavigationBar();
        HlsNavigationBar.initPrototype(view);
        return HlsNavigationBar;
    }

    public String getNavigationBarContent(ViewContext context) throws Exception {
        StringBuffer sb = new StringBuffer();
        List<XMap> list = getPrototype().getChildren();
        for (XMap map : list) {
            sb.append(ScreenBuilder.build(map, context));
        }
        return sb.toString();
    }

    public List<String> getNavigationBarTitle(ViewContext context) throws Exception {
        List<String> titleList = new ArrayList<>();
        List<XMap> list = getPrototype().getChildren();
        for (XMap map : list){
            if(map.get("navigationBar")!=null){
                if(this.getPrototype().getString("barType")!=null){
                    if(this.getPrototype().getString("barType").equals("normal")){
                        titleList.add("normal");
                        break;
                    }
                }
            }
        }
        int currentIndex = 0;
        for (XMap map : list){
            if(map.get("navigationBar")!=null){
                if(this.getPrototype().getString("barType").equals("tree")){
                    currentIndex++;
                    if(map.get("nodeLevel")!=null){
                        if( map.get("nodeLevel").toString().equals("parent")){
                            titleList.add("tree");
                            if(map.get("treeTitle").toString()!=null){
                                titleList.add(map.get("treeTitle").toString());
                            }else {
                                titleList.add(currentIndex+". 第"+currentIndex+"模块");
                            }
                            getbarId(map,titleList,currentIndex);
                        }
                    }
                    getBarData(map,titleList,currentIndex);
                }else if(this.getPrototype().getString("barType").equals("normal")){
                    currentIndex++;
                    getBarData(map,titleList,currentIndex);
                }
            }
        }
        return titleList;
    }

    public void getBarData(XMap map, List<String> titleList, int currentIndex){
        if(map.get("navigationBarTitle")!=null){
            titleList.add(map.get("navigationBarTitle").toString());
            getbarId(map,titleList,currentIndex);
        }else if(map.get("title")!=null && map.get("navigationBarTitle")==null){
            titleList.add(map.get("title").toString());
            getbarId(map,titleList,currentIndex);
        }else if(map.get("title")==null && map.get("navigationBarTitle")==null){
            titleList.add(currentIndex+". 第"+currentIndex+"模块");
            getbarId(map,titleList,currentIndex);
        }
    }

    public void getbarId(XMap map, List<String> titleList, int currentIndex){
        if(map.get("id")!=null){
            titleList.add(map.get("id").toString());
        }else {
            titleList.add("section-bar-"+currentIndex);
        }
    }

    public String getNavigationbarId(ViewContext context) throws Exception {
        String str = "";
        if(this.getPrototype().getString("id")!=null){
            str = this.getPrototype().getString("id");
        }
        return str.toString();
    }

    public String getNavigationbarClass(ViewContext context) throws Exception {
        String str = "";
        if(this.getPrototype().getString("class")!=null){
            str = this.getPrototype().getString("class");
        }
        return str.toString();
    }

    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_NAVIGATIONBARCONTENT, getNavigationBarContent(context));
        context.addJsonConfig(PROPERTITY_NAVIGATIONBARTITLE, getNavigationBarTitle(context));
        context.put(PROPERTITY_NAVIGATIONBARCLASS, getNavigationbarClass(context));
        context.put(PROPERTITY_NAVIGATIONBARID, getNavigationbarId(context));
    }
}
