package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

/**
 * Created by Reuenthal on 2017/10/17.
 */
public class HlsMultiBarChart extends HlsInfoSquareFrame {


    public static final String PROPERTITY_CONTEXTPATH = "contextPath";
    public static final String PROPERTITY_XAXIS_CATEGORIES="xAxis_categories";
    public static final String PROPERTITY_SERIES_NAME="series_name";
    public static final String PROPERTITY_SERIES_COLOR="series_color";
    public static final String PROPERTITY_SERIES_DATA="series_data";

    public String getSeriesData() {
        return this.getPrototype().getString(PROPERTITY_SERIES_DATA);
    }

    public String getSeriesColor() {
        return this.getPrototype().getString(PROPERTITY_SERIES_COLOR);
    }

    public String getSeriesName() {
        return this.getPrototype().getString(PROPERTITY_SERIES_NAME);
    }

    public String getXaxisCategories() {
        return this.getPrototype().getString(PROPERTITY_XAXIS_CATEGORIES);
    }


    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.addJsonConfig("xAxis_categories",getXaxisCategories());
        context.addJsonConfig("series_name",getSeriesName());
        context.addJsonConfig("series_color",getSeriesColor());
        context.addJsonConfig("series_data",getSeriesData());
        context.put(PROPERTITY_CONTEXTPATH,getContextPath());
        context.put(PROPERTITY_XAXIS_CATEGORIES,getXaxisCategories());
        context.put(PROPERTITY_SERIES_NAME,getSeriesName());
        context.put(PROPERTITY_SERIES_COLOR,getSeriesColor());
        context.put(PROPERTITY_SERIES_DATA,getSeriesData());
    }
}
