package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.XMap;

/**
 * 
 * 
 * 
 * @author yang.gao01@hand-china.com
 * 
 */
public interface HlsComponent {
	public static final String PROPERTITY_PROMPTCOLSPAN = "promptColspan";
	public static final String PROPERTITY_PROMPT = "prompt";
	public static final String PROPERTITY_COLSPAN = "colspan";
	public static final String PROPERTITY_VALIDATIONMESSAGE = "validationMessage";
	public static final String PROPERTITY_PRMOPTIMAGE = "promptImage";
	public static final String PROPERTITY_REQUIRED = "required";
	public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";
	public static final String PROPERTITY_PROMPTCLASSNAME = "promptClassName";
	public static final String PROPERTITY_HLSSTYLE = "hlsStyle";
	public static final String PROPERTITY_DATAMODELNAME = "datamodelname";
	public static final String PROPERTITY_DATAFIELDNAME = "datafieldname";
	public static final String PROPERTITY_BIND = "bind";
	public static final String PROPERTITY_BINDMODEL = "bindModel";
	public static final String PROPERTITY_PLACEHOLDER = "placeholder";

	void hlsSetPropertity(Object key, Object value);

	XMap getPrototype();
	
	default String getHlsClassName(){
        return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
    }

	default String getPromptClassName(){
		return getPrototype().getString(PROPERTITY_PROMPTCLASSNAME);
	}
	
	default String getDataField(String type){
		String bind=getPrototype().getString(PROPERTITY_BIND);
		if(bind!=null){
			String[] datas= bind.split(",");
			for (int i = 0; i < datas.length; i++) {
				datas[i] = datas[i].trim();
				if(datas[i].indexOf("value:")!=-1){
					String temp=datas[i].split(":")[1];
					if(PROPERTITY_DATAMODELNAME.equals(type)){
						temp=temp.split("\\.")[0].trim();
					}else if(PROPERTITY_DATAFIELDNAME.equals(type)){
						temp=temp.split("\\.")[1].trim();
					}
					return temp;
				}
			}
		}
        return null;
    }
	
	default String getHlsStyle(){
		return getPrototype().getString(PROPERTITY_HLSSTYLE);
	}
    
	default void setHlsClassName(String hlsClassName) {
		hlsSetPropertity(PROPERTITY_HLSCLASSNAME, hlsClassName);
    }

	default void setPromptClassName(String promptClassName) {
		hlsSetPropertity(PROPERTITY_PROMPTCLASSNAME, promptClassName);
	}
	
	default void setHlsStyle(String hlsStyle) {
		hlsSetPropertity(PROPERTITY_HLSSTYLE, hlsStyle);
    }

	default void setPromptColspan(String promptColspan) {
		hlsSetPropertity(PROPERTITY_PROMPTCOLSPAN, promptColspan);
	}

	default String getPromptColspan() {
		return getPrototype().getString(PROPERTITY_PROMPTCOLSPAN);
	}
	default String getPlaceholder() {
		return getPrototype().getString(PROPERTITY_PLACEHOLDER);
	}

	default void setPrompt(String prompt) {
		hlsSetPropertity(PROPERTITY_PROMPT, prompt);
	}

	default String getPrompt() {
		return getPrototype().getString(PROPERTITY_PROMPT);
	}

	default void setColSpan(String colSpan) {
		hlsSetPropertity(PROPERTITY_COLSPAN, colSpan);
	}

	default String getColSpan() {
		return getPrototype().getString(PROPERTITY_COLSPAN);
	}

	default void setValidationMessage(String validationMessage) {
		hlsSetPropertity(PROPERTITY_VALIDATIONMESSAGE, validationMessage);
	}

	default String getValidationMessage() {
		return getPrototype().getString(PROPERTITY_VALIDATIONMESSAGE);
	}

	default String getPromptImage() {
		String required = getPrototype().getString(PROPERTITY_REQUIRED);
		String promptImage = null;
		if ("true".equals(required)) {
			promptImage = "*";
		}
		return promptImage;
	}
	
	default String getHlsBindModel() {
		String temp = getPrototype().getString(PROPERTITY_BINDMODEL);
		return temp==null?"viewModel":temp;
	}

}
