package com.hand.app.robot.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.hap.system.controllers.BaseController;
import com.hand.app.robot.dto.RobotMessage;
import com.hand.app.robot.service.IRobotMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping(value = "/r/api")
public class RobotMessageController extends BaseController {

    @Autowired
    IRobotMessageService robotMessageService;

    @RequestMapping(value = "/app/addRobotMessage", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public RobotMessage addMessage(HttpServletRequest request, @RequestBody RobotMessage message) {
        return robotMessageService.insertSelective(createRequestContext(request), message);
    }
}
