package com.hand.app.esignHclc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.hand.app.esign.utils.AlgorithmHelper;
import com.hand.app.esignHclc.dto.SignFlowsInfoHclc;
import com.hand.app.esignHclc.dto.SignUserAttachInfo;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.mapper.SignInfoHclcMapper;
import com.hand.app.esignHclc.service.ISignFlowsInfoHclcService;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.app.esignHclc.service.ISignUserAttachInfoService;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.utils.HttpUtil;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.formbean.AttachmentInfo;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Service
public class SignInfoHclcServiceImpl extends BaseServiceImpl<SignUserInfoHclc> implements ISignInfoHclcService {


    @Value("${tsign.project.id}")
    private String projectId;
    @Value("${tsign.project.secret}")
    private String projectSecret;
    @Value("${tsign.api.notifyUrl}")
    private String notifyUrl;
    @Value("${tsign.face.api.appId}")
    private String appId;
    @Value("${tsign.face.api.secret}")
    private String secret;
    @Value("${wx.apiKey}")
    private String apiKey;
    @Value("${wx.image.path}")
    private String imagePath;
    @Value("${tsign.api.listenSignUrl}")
    private String listenSignUrl;
    @Value("${tsign.api.signRedirectUrl}")
    private String signRedirectUrl;

    private CloseableHttpClient httpClient;

    public static final String RESULT_ERROR = "-1";
    //用户认证接口信息
    public static final String indivSysName = "HCLC_FACE_API";
    public static final String tokenApiName = "getToken";
    public static final String indivApiName = "getIndivAuthUrl";
    public static final String getAccIdApiName = "getAccByThirdId";
    //公众号接口信息
    public static final String wxSysName = "wxgzh_hitachics";
    public static final String wxDownLoadApiName = "media_download";
    //业务系统接口信息
    public static final String hclcSysName = "HCL_UPLOAD_FILE";
    public static final String hclcUpLoadApiName = "upload";
    public static final String hclcDownloadApiName = "download";
    public static final String signSendApiName = "SignSendApiName";
    public static final String signFileDownApiName = "elecContractDownload";
    //电子签章接口信息
    public static final String signatureSysName = "HCLC_ELECTRONIC_SIGNATURE";
    public static final String accountsApiName = "outerAccounts";
    public static final String deleteApiName = "accountsDelete";
    public static final String signatureUpLoadApiName = "fileUpload";
    public static final String signFlowsApiName = "signFlows";
    public static final String getSignUrlsApiName = "getSignFlowDocUrls";
    public static final String createSealsApiName = "createTemplateSeals";

    private static final String HASH_ALGORITHM = "HmacSHA256";

    private final static int HTTP_OK = 200;

    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    private ISignInfoHclcFaceService signInfoHclcFaceService;
    @Autowired
    private SignInfoHclcMapper signInfoHclcMapper;
    @Autowired
    private ISignFlowsInfoHclcService iSignFlowsInfoHclcService;
    @Autowired
    private ISignUserAttachInfoService iSignUserAttachInfoService;


    private Logger logger = LoggerFactory.getLogger(getClass());

    public SignInfoHclcServiceImpl() {
        // ensure e-sign SDK will be init only once
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60 * 1000).setSocketTimeout(15000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }


    public Map<String, Object> getIndividualFaceUrl(IRequest iRequest, SignUserInfoHclc info) {

        Map<String, Object> map = new HashMap<>();

        if (Objects.isNull(info.getOpenId()) || "undefined".equalsIgnoreCase(info.getOpenId())) {
            logger.error("关键参数openId不存在，调用失败!");
            map.put("code", "000001");
            map.put("message", "关键参数openId不存在，调用失败!");
            return map;
        }

        //查询用户信息
        SignUserInfoHclc signInfoHclc = mapper.selectByPrimaryKey(info);

        //初始化创建用户判断
        String accountStatus = null;

        //判断用户信息是否存在,当新增用户时需要创建e签宝账户
        if (Objects.isNull(signInfoHclc)) {
            info.setCtitype(1L);
            info.setAuthFlag("N");
            signInfoHclc = this.insertSelective(iRequest, info);
            accountStatus = "ADD";
        } else {
            signInfoHclc.setCtitype(1L);
            if ("Y".equalsIgnoreCase(signInfoHclc.getAuthFlag())) {
                map.put("code", "000002");
                map.put("message", "人脸核身认证已完成，无需重复验证！");
                return map;
            }
            //移动端用户信息发生变更，需要注销e签宝账户，重新创建，并获取人脸核验url
            if (!info.getIdNo().equalsIgnoreCase(signInfoHclc.getIdNo()) || !info.getName().equalsIgnoreCase(signInfoHclc.getName()) || !info.getMobile().equalsIgnoreCase(signInfoHclc.getMobile())) {
                //e签宝账户不存在，需要新增
                if (Objects.isNull(signInfoHclc.getAccountId())) {
                    accountStatus = "ADD";
                }
                //e签宝账户已存在，注销e签宝账户，重新新增，获取人脸核验url
                else {
                    accountStatus = "MODIFY";
                }

            }
            //移动端用户信息未发生变更
            else {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                //存在对应核验url信息
                if (Objects.nonNull(signInfoHclc.getFaceAuthId())) {
                    //查询e签宝人脸核验信息
                    signInfoHclcFace.setAuthId(signInfoHclc.getFaceAuthId());
                    signInfoHclcFace = signInfoHclcFaceService.selectByPrimaryKey(iRequest, signInfoHclcFace);

                    //判断人脸核身认证状态，核验完成直接结束任务
                    if ("SUCCESS".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                        map.put("code", "000002");
                        map.put("message", "人脸核身认证已完成，无需重复验证！");
                        return map;
                    } else if ("FAIL".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                        accountStatus = "EXISTS";
                    } else {
                        //返回原核验url
                        map.put("code", "0");
                        map.put("url", signInfoHclcFace.getUrl());
                        map.put("message", "获取url成功！");
                        return map;
                    }

                }
                //不存在对应核验完成url，重新获取url
                else {
                    //e签宝账户不存在，需要新增
                    if (Objects.isNull(signInfoHclc.getAccountId())) {
                        accountStatus = "ADD";
                    }
                    //e签宝账户已存在，不需要新增，直接获取人脸核验url
                    else {
                        accountStatus = "EXISTS";
                    }
                }
            }

        }

        if (!"EXISTS".equalsIgnoreCase(accountStatus)) {
            //移动端用户信息发生变更，先注销e签宝用户
            if ("MODIFY".equalsIgnoreCase(accountStatus)) {
                map = deletePersonAccount(iRequest, signInfoHclc);
                //注销成功
                if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString())) {
                    signInfoHclc.setAccountId("");
                    signInfoHclc.setAuthAccountId("");
                    //重新设置个人用户信息
                    signInfoHclc.setIdNo(info.getIdNo());
                    signInfoHclc.setName(info.getName());
                    signInfoHclc.setMobile(info.getMobile());
                    signInfoHclc.setFaceAuthId(null);
                }
            }

            //创建e签宝账户
            if (map.size() == 0 || "0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString())) {
                //初始化经办人人脸识别信息
                SignUserInfoHclc signInfo = new SignUserInfoHclc();
                signInfo.setOpenId(signInfoHclc.getOpenId());
                signInfo.setIdNo(info.getIdNo());
                signInfo.setMobile(info.getMobile());
                signInfo.setName(info.getName());
                map = addPersonAccount(signInfo);
                //创建成功
                if ("0".equalsIgnoreCase(map.get("code").toString())) {
                    signInfoHclc.setAccountId(map.get("accountId").toString());
                    signInfoHclc.setSealId(map.get("sealId").toString());
                    if ("ADD".equalsIgnoreCase(accountStatus)) {
                        //重新设置个人用户信息
                        signInfoHclc.setIdNo(info.getIdNo());
                        signInfoHclc.setName(info.getName());
                        signInfoHclc.setMobile(info.getMobile());
                    }
                }
                signInfoHclc.setCreateCode(map.get("code").toString());
                signInfoHclc.setCreateMessage(map.get("message").toString());
            }
        }

        //用户创建成功
        if (map.size() == 0 || "0".equalsIgnoreCase(map.get("code").toString())) {
            //初始化接口密钥参数信息
            SignHclcUtils signHclcUtils = new SignHclcUtils();
            signInfoHclc = signHclcUtils.initProject(signInfoHclc, appId, secret, notifyUrl);

            //获取鉴权Token
            String tokenApiUrl = getApiUrl(indivSysName, tokenApiName);
            logger.debug("token url: {}", tokenApiUrl);
            String token = signHclcUtils.getFaceApiToken(tokenApiUrl, signInfoHclc.getAppId(), signInfoHclc.getSecret());

            if (Objects.nonNull(token)) {

//                //获取身份验证公有云账户id
//                if (signInfoHclc.getAuthAccountId() == null || "".equalsIgnoreCase(signInfoHclc.getAuthAccountId())) {
//                    map = getByThirdId(signInfoHclc, token);
//                    if ("0".equalsIgnoreCase(map.get("code").toString())) {
//                        signInfoHclc.setAuthAccountId(map.get("authAccountId").toString());
//                    }
//                }

//                if (signInfoHclc.getAuthAccountId() == null || "".equalsIgnoreCase(signInfoHclc.getAuthAccountId())) {
//                    map.put("code", "000010");
//                    map.put("message", "获取验证公有云accountId失败，请检查！");
//                } else {
                signInfoHclc.setRedirectUrl(info.getRedirectUrl());
                //获取个人核身认证地址
                map = getFaceUrlHttp(iRequest, signInfoHclc, token);

                if ("0".equalsIgnoreCase(map.get("code").toString())) {
                    signInfoHclc.setFaceAuthId(Long.valueOf(map.get("faceAuthId").toString()));
                }
//                }

            } else {
                map.put("code", "000007");
                map.put("message", "获取鉴权Token失败，请检查！");
            }

        }

        this.updateByPrimaryKey(iRequest, signInfoHclc);
        return map;


    }

    /***
     * 获取中台接口定义url;
     * @param sysName
     * @param apiName
     ***/
    public String getApiUrl(String sysName, String apiName) {
        //初始化接口密钥参数信息
        HapInterfaceHeader headerAndLineDTO = headerService.getHeaderAndLine(sysName, apiName);
        if (headerAndLineDTO == null) {
            logger.debug("headerAndLineDTO is null， apiName:{}, sysName:{}", apiName, sysName);
            return null;
        }
        return headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
    }

    /***
     * 获取人脸识别url;
     * @param iRequest
     * @param info
     * @param token
     ***/
    public Map<String, Object> getFaceUrlHttp(IRequest iRequest, SignUserInfoHclc info, String token) {
        Map<String, Object> map = new HashMap<>();

        //初始化人脸核验流程初始化数据
        SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
        signInfoHclcFace.setOpenId(info.getOpenId());
        signInfoHclcFace.setAuthStatus("NEW");
        signInfoHclcFace.setAuthType("1");
        signInfoHclcFace = signInfoHclcFaceService.insertSelective(iRequest, signInfoHclcFace);

        //业务方交互上下文信息
        JSONObject json1 = new JSONObject();
        //传入上下文id用于接口回传更新
        json1.put("contextId", signInfoHclcFace.getAuthId());
        json1.put("notifyUrl", info.getNotifyUrl());
        json1.put("redirectUrl", info.getRedirectUrl());

        //个人认证基本信息
        JSONObject json2 = new JSONObject();
        json2.put("name", info.getName());
        json2.put("certType", "INDIVIDUAL_CH_IDCARD");
        json2.put("certNo", info.getIdNo());
        json2.put("mobileNo", info.getMobile());

        //认证配置信息
        JSONObject json3 = new JSONObject();
        String[] str = new String[]{"name", "certNo", "mobileNo", "bankCardNo"};
        json3.put("indivUneditableInfo", str);


        JSONObject result = new JSONObject();
        //个人刷脸认证
        result.put("authType", "PSN_FACEAUTH_BYURL");
        result.put("contextInfo", json1);
        result.put("indivInfo", json2);
        result.put("configParams", json3);
//        result.put("repeatIdentity", true);
        JSONObject json = new JSONObject(result);
//        String param = json.toString();

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", info.getAppId());
        headInfo.put("X-Tsign-Open-Token", token);


        try {
            //初始化接口url信息
//            String faceApiurl = getApiUrl(indivSysName, indivApiName).replace("{accountId}", info.getAuthAccountId());
            String faceApiurl = getApiUrl(indivSysName, indivApiName);
            logger.debug("get face api url: {}", faceApiurl);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(faceApiurl, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                signInfoHclcFace.setFlowId(data.getString("flowId") == null ? "" : data.getString("flowId"));
                signInfoHclcFace.setUrl(data.getString("url") == null ? "" : data.getString("url"));
                signInfoHclcFace.setShortLink(data.getString("shortLink") == null ? "" : data.getString("shortLink"));
                signInfoHclcFace.setAuthStatus("AUTHING");

                map.put("code", "0");
                map.put("faceAuthId", signInfoHclcFace.getAuthId());
                map.put("AuthType", "FACE");
                map.put("url", data.getString("url"));
                map.put("message", "获取url成功！");
            } else {
                map.put("code", "000008");
                map.put("message", "获取人脸核身认证url失败，" + jsonResult.getString("message"));
            }
            signInfoHclcFace.setReturnCode(jsonResult.getString("code"));
            signInfoHclcFace.setReturnMessage(jsonResult.getString("message"));
        } catch (Exception e) {
            map.put("code", "000009");
            map.put("message", "访问e签宝人脸核身地址失败，请检查！");
            signInfoHclcFace.setReturnCode("000009");
            signInfoHclcFace.setReturnMessage(e.getMessage());
        }

        signInfoHclcFaceService.updateByPrimaryKey(iRequest, signInfoHclcFace);

        return map;
    }

    /***
     * 查询个人账户（按照第三方用户ID查询）;
     * @param info
     * @param token
     ***/
    public Map<String, Object> getByThirdId(SignUserInfoHclc info, String token) {
        Map<String, Object> map = new HashMap<>();

        //设置http请求head信息
        JSONObject headInfo = new JSONObject();
        headInfo.put("X-Tsign-Open-App-Id", info.getAppId());
        headInfo.put("X-Tsign-Open-Token", token);

        String param = "thirdPartyUserId=" + info.getAccountId();

        try {
            //初始化接口url信息
            String accIdApiurl = getApiUrl(indivSysName, getAccIdApiName) + "?" + param;
            logger.debug("get accountId api url: {}", accIdApiurl);

            //发送http请求
            HttpResponse execute = HttpUtil.getJson(accIdApiurl, headInfo);
            int httpReponseCode;
            String stringResult = null;
            JSONObject responseBody = new JSONObject();
            if (execute != null) {
                httpReponseCode = execute.getStatusLine().getStatusCode();
                if (httpReponseCode != HTTP_OK) {
                    responseBody.put("code", httpReponseCode);
                    responseBody.put("message", execute.getStatusLine().getReasonPhrase());
                    stringResult = responseBody.toString();
                } else {
                    stringResult = HttpUtil.HttpResponseParseJson(execute);
                }

                //解析返回结果
                JSONObject jsonResult = JSONObject.parseObject(stringResult);
                if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                    JSONObject data = jsonResult.getJSONObject("data");

                    map.put("code", "0");
                    map.put("authAccountId", data.getString("accountId"));
                    map.put("message", "获取个人云账户成功！");
                } else {
                    map.put("code", "000008");
                    map.put("message", "获取个人云账户失败," + jsonResult.getString("message"));
                }
            } else {
                map.put("code", "000010");
                map.put("message", "获取个人云账户发送网络请求失败，请检查个人云地址信息！");
            }

        } catch (Exception e) {
            map.put("code", "000009");
            map.put("message", e.getMessage());
        }

        return map;
    }

//    public JSONObject uploadHlsFromWx(IRequest iRequest, AttachmentInfo attachmentInfo) {
//
//
//        JSONObject json = null;
//        if (Objects.isNull(attachmentInfo.getMediaId())) {
//            logger.error("upload attachment failed, attachmentInfo:{} 关键参数mediaId不存在，调用失败!", JSON.toJSONString(attachmentInfo));
//            json.put("code", "3");
//            json.put("message", "关键参数mediaId不存在，调用失败");
//            return json;
//        }
//
//        //更新用户信息表mediaId信息
//        SignInfoHclc signInfoHclc = new SignInfoHclc();
//        signInfoHclc.setOpenId(attachmentInfo.getOpenId());
//        signInfoHclc.setMediaId(attachmentInfo.getMediaId());
//        signInfoHclc = updateByPrimaryKeySelective(iRequest, signInfoHclc);
//
//        try {
//
//            //下载微信服务器媒体文件
//            //设置文件目录
//            String tomcatPath = imagePath;
//            AttachmentInfo downloadInfo = new AttachmentInfo();
//            downloadInfo.setUploadSysName(wxSysName);
//            downloadInfo.setUploadApiName(wxDownLoadApiName);
//            downloadInfo.setMediaId(attachmentInfo.getMediaId());
//            tomcatPath = downloadFileFromWx(downloadInfo, tomcatPath);
//
//            //判断文件下载成功
//            if (!tomcatPath.equalsIgnoreCase("-1")) {
//                //身份证ocr认证
//                SignHclcUtils signHclcUtils = new SignHclcUtils();
//                json = signHclcUtils.idcard(tomcatPath);
//                json.put("code", "0");
//
//                //上传微信服务器媒体文件到社内服务器
//                attachmentInfo.setUserId("admin");
//                attachmentInfo.setUploadSysName(hclcSysName);
//                attachmentInfo.setUploadApiName(hclcUpLoadApiName);
//                attachmentInfo.setPkValue(attachmentInfo.getOpenId());
//                String attchmentId = uploadFileToHclc(tomcatPath, attachmentInfo);
//
//                //判断文件下载是否成功
//                if (Objects.nonNull(attchmentId)) {
//                    //设置用户信息表附件信息
//                    signInfoHclc.setAttachmentId(attchmentId);
//                    updateByPrimaryKeySelective(iRequest, signInfoHclc);
//                }
//
//                json.put("attchmentId", attchmentId);
//            } else {
//                json.put("code", "1");
//                json.put("message", "获取服务器图片失败,OCR识别失败");
//            }
//
//            return json;
//
//        } catch (Exception e) {
//            logger.error("upload attachment failed, attachmentInfo:{}", JSON.toJSONString(attachmentInfo), e);
//            json.put("code", "2");
//            json.put("message", e.getMessage());
//            return json;
//        }
//
//    }

    /***
     * 下载微信图片资源上传至业务系统;
     * @param iRequest
     * @param attachmentInfo
     ***/
    public JSONObject uploadHlsFromWx(IRequest iRequest, AttachmentInfo attachmentInfo) {


        JSONObject json = new JSONObject();
        if (Objects.isNull(attachmentInfo.getMediaId())) {
            logger.error("upload attachment failed, attachmentInfo:{} 关键参数mediaId不存在，调用失败!", JSON.toJSONString(attachmentInfo));
            json.put("code", "000003");
            json.put("message", "关键参数mediaId不存在，调用失败");
            return json;
        }

        //更新用户信息表mediaId信息
        SignUserAttachInfo signUserAttachInfo = new SignUserAttachInfo();
        signUserAttachInfo.setOpenId(attachmentInfo.getOpenId());
        signUserAttachInfo.setAttachmentType(attachmentInfo.getSourceType());

        List<SignUserAttachInfo> signUserAttachInfos = new ArrayList<>();
        signUserAttachInfos = iSignUserAttachInfoService.select(iRequest, signUserAttachInfo, 1, 1);
        if (signUserAttachInfos.size() > 0) {
            signUserAttachInfo = signUserAttachInfos.get(0);
        } else {
            signUserAttachInfo = iSignUserAttachInfoService.insertSelective(iRequest, signUserAttachInfo);
        }

        signUserAttachInfo.setMediaId(attachmentInfo.getMediaId());

        try {

            byte[] bytes;

            //下载微信服务器媒体文件
            //设置文件目录
            AttachmentInfo downloadInfo = new AttachmentInfo();
            downloadInfo.setUploadSysName(wxSysName);
            downloadInfo.setUploadApiName(wxDownLoadApiName);
            downloadInfo.setMediaId(attachmentInfo.getMediaId());
            InputStream inputStream = downloadFileFromWx(downloadInfo);
            bytes = IOUtils.toByteArray(inputStream);

            //判断文件下载成功
            if (!ArrayUtils.isEmpty(bytes)) {
                //身份证ocr认证
                SignHclcUtils signHclcUtils = new SignHclcUtils();
                if ("app_file_id_card".equalsIgnoreCase(attachmentInfo.getSourceType())) {
                    json = signHclcUtils.idcard(bytes);
                } else {
                    //营业执照
                    json = signHclcUtils.businessLicense(bytes);
                }
                json.put("code", "0");

                //上传微信服务器媒体文件到社内服务器
                attachmentInfo.setUserId("admin");
                attachmentInfo.setUploadSysName(hclcSysName);
                attachmentInfo.setUploadApiName(hclcUpLoadApiName);
                attachmentInfo.setPkValue(attachmentInfo.getOpenId());
                String attchmentId = uploadFileToHclc(bytes, attachmentInfo);

                //判断文件下载是否成功
                if (Objects.nonNull(attchmentId)) {
                    //设置用户信息表附件信息--身份证
                    signUserAttachInfo.setAttachmentIdHclc(Long.valueOf(attchmentId));
                    iSignUserAttachInfoService.updateByPrimaryKey(iRequest, signUserAttachInfo);
                    json.put("attchmentId", attchmentId);
                } else {
                    json.put("code", "000005");
                    json.put("message", "上传业务系统图片失败,OCR识别失败");
                }

            } else {
                json.put("code", "000001");
                json.put("message", "下载服务器图片失败,OCR识别失败");
            }

            return json;

        } catch (Exception e) {
            logger.error("upload attachment failed, attachmentInfo:{}", JSON.toJSONString(attachmentInfo), e);
            json.put("code", "000002");
            json.put("message", e.getMessage());
            return json;
        }

    }

    //    public String downloadFileFromWx(AttachmentInfo info, String filePath) throws IOException {
//        //设置接口参数
//        JSONObject parameters = new JSONObject();
//        parameters.put("apiKey", apiKey);
//        parameters.put("mediaId", info.getMediaId());
//
//        //初始化接口信息
//        String url = getApiUrl(info.getUploadSysName(), info.getUploadApiName());
//        logger.debug("upload url: {}", url);
//
//        //发起http请求下载文件
//        HttpPost httpPost = new HttpPost(url);
//        httpPost.addHeader(HTTP.CONTENT_TYPE, "application/json");
//        httpPost.setHeader("Accept", "application/json");
//        StringEntity se = new StringEntity(parameters.toString(), "utf-8");
//        se.setContentType("text/json");
//        httpPost.setEntity(se);
//
//        try {
//            //获取微信服务器媒体文件
//            CloseableHttpResponse response = httpClient.execute(httpPost);
//            InputStream inputStream = response.getEntity().getContent();
//
//            File file = new File(filePath);
//            if (!file.exists()) {
//                file.mkdirs();
//            }
//            filePath += File.separator + info.getFileName();
//            OutputStream outputStream = new FileOutputStream(filePath);
//            int len = -1;
//            byte[] bytes = new byte[1024];
//            while ((len = inputStream.read(bytes)) != -1) {
//                outputStream.write(bytes, 0, len);//写入
//            }
//            outputStream.flush();
//            outputStream.close();
//            inputStream.close();
//
//            return filePath;
//        } catch (IOException e) {
//            logger.error("获取服务器图片失败，msg:{}", e.getMessage());
//            e.printStackTrace();
//            return "-1";
//        }
//    }

    /***
     * 下载微信图片;
     * @param info
     ***/
    public InputStream downloadFileFromWx(AttachmentInfo info) throws IOException {
        //设置接口参数
        JSONObject parameters = new JSONObject();
        parameters.put("apiKey", apiKey);
        parameters.put("mediaId", info.getMediaId());

        //初始化接口信息
        String url = getApiUrl(info.getUploadSysName(), info.getUploadApiName());
        logger.debug("upload url: {}", url);

        //发起http请求下载文件
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(HTTP.CONTENT_TYPE, "application/json");
        httpPost.setHeader("Accept", "application/json");
        StringEntity se = new StringEntity(parameters.toString(), "utf-8");
        se.setContentType("text/json");
        httpPost.setEntity(se);

        //获取微信服务器媒体文件
        CloseableHttpResponse response = httpClient.execute(httpPost);
        InputStream inputStream = response.getEntity().getContent();
        return inputStream;
    }


//    public String uploadFileToHclc(String filePath, AttachmentInfo info) {
//        //todo upload file
//        logger.debug("params,filePath:{}, attachmentInfo:{}", filePath, JSON.toJSONString(info));
//        if (filePath == null || info == null || StringUtils.isBlank(info.getPkValue()) || StringUtils.isBlank(info.getSourceType())) {
//            return null;
//        }
//
//        String url = getApiUrl(info.getUploadSysName(), info.getUploadApiName());
//        logger.debug("upload url: {}", url);
//        HttpPost httpPost = new HttpPost(url);
//
//        //prepare params
//        StringBody pkValue = new StringBody(info.getPkValue(), ContentType.MULTIPART_FORM_DATA);
//        StringBody userId = new StringBody(info.getUserId(), ContentType.MULTIPART_FORM_DATA);
//        StringBody sourceType = new StringBody(info.getSourceType(), ContentType.MULTIPART_FORM_DATA);
//
//        ContentType pdfType = ContentType.create("image/jpeg", Consts.UTF_8);
//
//        try {
//            File file = new File(filePath);
//
//            HttpEntity entity = MultipartEntityBuilder.create()
//                    .setMode(HttpMultipartMode.BROWSER_COMPATIBLE)
//                    .addPart("pkvalue", pkValue)
//                    .addPart("user_id", userId)
//                    .addPart("source_type", sourceType)
//                    .addBinaryBody("file", file, pdfType, info.getFileName())
//                    .setCharset(CharsetUtils.get("utf-8"))
//                    .build();
//            httpPost.setEntity(entity);
//            CloseableHttpResponse response = httpClient.execute(httpPost);
//            InputStream content = response.getEntity().getContent();
//            String result = IOUtils.toString(content);
//            if (StringUtils.equals(RESULT_ERROR, result)) {
//                return null;
//            }
//            return result;
//        } catch (IOException e) {
//            logger.error("upload attachment failed, attachmentInfo:{}", JSON.toJSONString(info), e);
//        }
//        return null;
//    }

    /***
     * 上传微信图片至业务系统;
     * @param bytes
     * @param info
     ***/
    public String uploadFileToHclc(byte[] bytes, AttachmentInfo info) {
        //todo upload file
        logger.debug("params,bytes:{}, attachmentInfo:{}", bytes, JSON.toJSONString(info));
        if (ArrayUtils.isEmpty(bytes) || info == null || StringUtils.isBlank(info.getPkValue()) || StringUtils.isBlank(info.getSourceType())) {
            return null;
        }

        String url = getApiUrl(info.getUploadSysName(), info.getUploadApiName());
        logger.debug("upload url: {}", url);
        HttpPost httpPost = new HttpPost(url);

        //prepare params
        StringBody pkValue = new StringBody(info.getPkValue(), ContentType.MULTIPART_FORM_DATA);
        StringBody userId = new StringBody(info.getUserId(), ContentType.MULTIPART_FORM_DATA);
        StringBody sourceType = new StringBody(info.getSourceType(), ContentType.MULTIPART_FORM_DATA);

        ContentType pdfType = ContentType.create("image/jpeg", Consts.UTF_8);

        try {
            HttpEntity entity = MultipartEntityBuilder.create()
                    .setMode(HttpMultipartMode.BROWSER_COMPATIBLE)
                    .addPart("pkvalue", pkValue)
                    .addPart("user_id", userId)
                    .addPart("source_type", sourceType)
                    .addBinaryBody("file", bytes, pdfType, info.getFileName())
                    .setCharset(CharsetUtils.get("utf-8"))
                    .build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            InputStream content = response.getEntity().getContent();
            String result = IOUtils.toString(content);
            if (StringUtils.equals(RESULT_ERROR, result)) {
                return null;
            }
            return result;
        } catch (IOException e) {
            logger.error("upload attachment failed, attachmentInfo:{}", JSON.toJSONString(info), e);
        }
        return null;
    }


    /**
     * e签宝文件直传
     *
     * @param iRequest
     * @param dto      附件信息
     * @return
     */
    public Map<String, Object> signFileUpload(IRequest iRequest, AttachmentInfo dto) {
        Map<String, Object> map = new HashMap<>();

        if (Objects.isNull(dto.getAttachmentId())) {
            logger.error("关键参数AttachmentId不存在，调用失败!");
            map.put("success", "false");
            map.put("message", "关键参数AttachmentId不存在，调用失败!");
            return map;
        }

        String downloadUrl = getApiUrl(hclcSysName, hclcDownloadApiName);
        byte[] bytes;
        bytes = downloadFileFromHclc(dto.getAttachmentId(), downloadUrl);

        //判断文件下载成功
        if (!ArrayUtils.isEmpty(bytes)) {
            String uploadUrl = getApiUrl(signatureSysName, signatureUpLoadApiName);
            String fileKey = fileUpload(bytes, uploadUrl, dto.getFileName());
            if (fileKey == null) {
                map.put("success", "true");
                map.put("message", "上传e签宝文件失败请检查e签宝服务器!");
            } else {
                map.put("success", "true");
                map.put("fileKey", fileKey);
                map.put("message", "上传成功");
            }
        } else {
            logger.error("业务系统文件下载失败请检查文件下载路径!");
            map.put("success", "false");
            map.put("message", "业务系统文件下载失败请检查文件下载路径!");
        }
        return map;
    }

    /**
     * hclc的文件下载
     *
     * @param attachmentId
     * @param downloadUrl
     */
    public byte[] downloadFileFromHclc(String attachmentId, String downloadUrl) {

        String url = downloadUrl;
        try {
            url = url + (url.indexOf("?") > 0 ? "&attachment_id=" : "?attachment_id=") + attachmentId;

            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            if (HttpStatus.SC_OK != response.getStatusLine().getStatusCode()) {
                logger.error("request target attachment({}) failed,sysName:{}, apiName:{}", attachmentId, hclcSysName, hclcDownloadApiName);
                return null;
            }
            InputStream content = response.getEntity().getContent();
            return IOUtils.toByteArray(content);
        } catch (Exception e) {
            logger.error("request target attachment({}) failed,sysName:{}, apiName:{}", attachmentId, hclcSysName, hclcDownloadApiName);
            return null;
        }

    }

    /**
     * e签宝文件直传
     *
     * @param bytes     文件输入流
     * @param uploadUrl 接口地址
     * @param fileName  文件名
     * @return
     */

    private String fileUpload(byte[] bytes, String uploadUrl, String fileName) {
        String res = "";
        //初始化接口url信息
        logger.debug("upload url: {}", uploadUrl);

        try {
            HttpPost httpPost = new HttpPost(uploadUrl);

            //获取HMAC加密后的X-timevale-signature签名信息
            AlgorithmHelper algorithmHelper = new AlgorithmHelper();
            String EncryptedString = algorithmHelper.getXtimevaleSignature("", projectSecret, HASH_ALGORITHM, "UTF-8");

            //设置http请求head信息
            httpPost.addHeader("x-timevale-project-id", projectId);
            httpPost.addHeader("x-timevale-signature", EncryptedString);

            HttpEntity entity = MultipartEntityBuilder.create()
                    .setMode(HttpMultipartMode.BROWSER_COMPATIBLE)
                    .addBinaryBody("file", bytes, ContentType.MULTIPART_FORM_DATA, fileName)
                    .setCharset(CharsetUtils.get("utf-8"))
                    .build();
            httpPost.setEntity(entity);

            CloseableHttpResponse response = httpClient.execute(httpPost);
            InputStream content = response.getEntity().getContent();
            res = IOUtils.toString(content);

            if (StringUtils.equals(RESULT_ERROR, res)) {
                return null;
            }

            String fileKey = null;

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(res);
            if (!"".equalsIgnoreCase(jsonResult.getString("data")) && jsonResult.getString("data") != null) {
                fileKey = jsonResult.getJSONObject("data").getString("fileKey");
            }
            return fileKey;

        } catch (Exception e) {
            this.logger.info("文件上传，发送POST请求出错==>" + uploadUrl);
            this.logger.info("文件上传，异常信息==>" + e.getMessage());
            return null;
        }
    }


    public Map<String, Object> addPersonAccount(SignUserInfoHclc signInfoHclc) {
        Map<String, Object> map = new HashMap<>();
        //业务方交互上下文信息
        JSONObject result = new JSONObject();
        //银行卡号
        result.put("cardNo", "");
        //联系人邮箱
        result.put("contactsEmail", "");
        //联系人手机号
        result.put("contactsMobile", signInfoHclc.getMobile());
        //证件号码
        result.put("licenseNumber", signInfoHclc.getIdNo());
        //证件类型，个人证件类型（Other-其他，IDCard-身份证 号码，Passport-中国护照，HMPass-港澳居民来往内地通行证，MTP-台胞证）
        result.put("licenseType", "IDCard");
        //登录手机号/登录邮箱必填其一
        //登录邮箱
        result.put("loginEmail", "");
        //登录手机号/
        result.put("loginMobile", signInfoHclc.getMobile());
        //用户名称
        result.put("name", signInfoHclc.getName());
        //用户的唯一标识可以为客户业务系统内唯一标识
        result.put("uniqueId", signInfoHclc.getOpenId());
        JSONObject json = new JSONObject(result);
        String param = json.toString();

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        try {

            //初始化接口信息
            String url = getApiUrl(signatureSysName, accountsApiName);
            logger.debug("add person account url: {}", url);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");

                //设置返回accountId
                map.put("accountId", data.getString("accountId"));

                String sealId = createTemplateSeals(data.getString("accountId"), signInfoHclc.getOpenId());

                map.put("sealId", sealId);
                map.put("code", "0");
                map.put("message", "个人e签宝账户创建成功！");
            } else {
                logger.error("create person account failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "个人e签宝账户创建失败," + jsonResult.getString("msg"));
            }
        } catch (Exception e) {
            logger.error("create person account failed, msg:{}", e.getMessage());
            map.put("code", "000006");
            map.put("message", "个人e签宝账户创建失败，" + e.getMessage());
        }

        return map;
    }

    public String createTemplateSeals(String accountId, String openId) {

        //业务方交互上下文信息
        JSONObject result = new JSONObject();
        //创建用户返回的天印签章系统的用户id
        result.put("accountId", accountId);
        //印章颜色
        result.put("color", "BLACK");
        //模板类型
        result.put("templateType", "BORDERLESS");
        //用户的唯一标识可以为客户业务系统内唯一标识
        result.put("uniqueId", openId);
        JSONObject json = new JSONObject(result);
        String param = json.toString();

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        try {

            //初始化接口信息
            String url = getApiUrl(signatureSysName, createSealsApiName);
            logger.debug("create seals url: {}", url);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                return data.getString("sealId");
            } else {
                logger.error("create seals failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
                return "-1";
            }
        } catch (Exception e) {
            logger.error("create seals failed, msg:{}", e.getMessage());
            return "-1";
        }

    }

    public Map<String, Object> deletePersonAccount(IRequest iRequest, SignUserInfoHclc signInfoHclc) {
        Map<String, Object> map = new HashMap<>();

        signInfoHclc = this.selectByPrimaryKey(iRequest, signInfoHclc);

        if (Objects.isNull(signInfoHclc)) {
            logger.debug("未找到对应e签宝个人用户信息，请检查！");
            map.put("code", "000002");
            map.put("message", "未找到对应e签宝个人用户信息，请检查！");
            return map;
        }


        String accountId = "";

        //判断个人用户还是法人经办人
        if (signInfoHclc.getCtitype().compareTo(1L) == 0) {
            accountId = signInfoHclc.getAccountId();
        } else {
            accountId = signInfoHclc.getAgentAccountId();
        }

        if (Objects.isNull(accountId) || "".equalsIgnoreCase(accountId)) {
            logger.debug("e签宝个人账户不存在，无需注销！");
            map.put("code", "40051667");
            map.put("message", "e签宝个人账户不存在，无需注销！");
            return map;
        }

        //业务方交互上下文信息
        JSONObject result = new JSONObject();
        //创建内部用户返回的天印签章系统的用户id
        result.put("accountId", accountId);
        //用户的唯一标识可以为客户业务系统内唯一标识
        result.put("uniqueId", signInfoHclc.getOpenId());
        JSONObject json = new JSONObject(result);
        String param = json.toString();

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        try {

            //初始化接口信息
            String url = getApiUrl(signatureSysName, deleteApiName);
            logger.debug("delete person account  url: {}", url);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode")) || "40051667".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                map.put("code", "0");
                map.put("message", "e签宝个人用户注销成功！");
            } else {
                logger.error("delete person account failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "e签宝个人用户注销失败," + jsonResult.getString("msg"));
            }

        } catch (Exception e) {
            logger.error("delete person account failed, msg:{}", e.getMessage());
            map.put("code", "000004");
            map.put("message", "e签宝个人用户注销失败，" + e.getMessage());
        }

        return map;
    }


    public JSONObject createSignFlows(IRequest requestContext, JSONObject params) {

        JSONObject jsonResult = new JSONObject();

        //解析签署人信息集合，替换用户信息为accountId
        JSONArray signers = params.getJSONArray("signers");
        JSONArray signersNew = new JSONArray();
//        String initiatorAccountId = "";
        for (int i = 0; i < signers.size(); i++) {
            JSONObject json1 = signers.getJSONObject(i);
            String idNo = json1.getString("idNo");
            String name = json1.getString("name");
            String role = json1.getString("role");

            if ("HCLC".equalsIgnoreCase(role)) {

                json1.put("accountId", "0d83cfe0-4d86-11ea-b71a-b8599f3574b6");
                json1.put("authorizationOrganizeId", "f858b8e9-5c3a-11ea-8486-506b4bfdce3c");
            } else {

                SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
                signInfoHclc.setAuthFlag("Y");
                signInfoHclc.setName(name);

                //代理店匹配用户名称
                if (Objects.nonNull(idNo)) {
                    signInfoHclc.setIdNo(idNo);
                }

                List<SignUserInfoHclc> signInfoHclcs = signInfoHclcMapper.queryUserInfo(signInfoHclc);
                if (signInfoHclcs.size() == 0) {
                    logger.error("create sign flows failed, account:{} is not defined in wx", name + idNo);
                    jsonResult.put("errCode", "2");
                    jsonResult.put("msg", "创建签署流程失败，用户" + name + idNo + "在移动端未完成实名认证，请先认证！");
                    return jsonResult;
                } else {
                    signInfoHclc = signInfoHclcs.get(0);
                    json1.put("contactMobile", signInfoHclc.getMobile());
                    //用户类型是个人时
                    if (signInfoHclc.getCtitype().compareTo(1L) == 0) {
                        json1.put("accountId", signInfoHclc.getAccountId());
                        json1.put("uniqueId", signInfoHclc.getOpenId());
                        //用户类型是机构时
                    } else {
                        json1.put("accountId", signInfoHclc.getAgentAccountId());
                        json1.put("authorizationOrganizeId", signInfoHclc.getAccountId());
                        json1.put("uniqueId", signInfoHclc.getOpenId());
                    }

//                    //代理店设置发起人
//                    if ("AGENT".equalsIgnoreCase(role)) {
//                        initiatorAccountId = signInfoHclc.getAccountId();
//                    }
                }

                //判断文字签字印章自定义模板是否存在
                if (Objects.nonNull(signInfoHclc.getSealId()) && !"-1".equalsIgnoreCase(signInfoHclc.getSealId())) {
                    //获取签署文档信息
                    JSONArray signDocDetails = json1.getJSONArray("signDocDetails");
                    JSONArray signDocDetailsNew = new JSONArray();
                    //解析签署文档信息
                    for (int j = 0; j < signDocDetails.size(); j++) {
                        JSONObject detail = signDocDetails.getJSONObject(j);

                        //获取签署位置信息
                        JSONArray signPos = detail.getJSONArray("signPos");
                        JSONArray signPosNew = new JSONArray();

                        for (int k = 0; k < signPos.size(); k++) {
                            JSONObject pos = signPos.getJSONObject(k);

                            //个人签字统一更换签字模板
                            if (signInfoHclc.getCtitype().compareTo(1L) == 0) {
                                pos.remove("sealId");
                                pos.put("sealId", signInfoHclc.getSealId());
                            } else {
                                //企业签字判断是否存在PERSON签字，更换签字模板
                                String signIdentity = pos.getString("signIdentity");
                                if ("PERSON".equalsIgnoreCase(signIdentity)) {
                                    pos.remove("sealId");
                                    pos.put("sealId", signInfoHclc.getSealId());
                                }
                            }

                            signPosNew.add(pos);
                        }

                        detail.remove("signPos");
                        detail.put("signPos", signPosNew);

                        signDocDetailsNew.add(detail);
                    }

                    json1.remove("signDocDetails");
                    json1.put("signDocDetails", signDocDetailsNew);

                }

            }


            json1.put("accountType", "2");
            json1.remove("idNo");
            json1.remove("name");
            json1.remove("role");

            signersNew.add(json1);
        }


        JSONObject result = new JSONObject();
        //附件信息集合
        result.put("attachments", params.get("attachments"));
        //第三方业务码
        result.put("bizNo", params.get("bizNo"));
        //签署回调通知地址
        result.put("callbackUrl", listenSignUrl);
        //流程备注
        result.put("comments", params.get("comments"));
//        //抄送人信息集合签署成功后通知抄送人
//        result.put("copyViewers", params.get("copyViewers"));
        //发起人用户id,默认hclc发起
        result.put("initiatorAccountId", "f858b8e9-5c3a-11ea-8486-506b4bfdce3c");
        //签署完成重定向地址
        result.put("redirectUrl", signRedirectUrl);
        //流程文档信息集合
        result.put("signDocs", params.get("signDocs"));
        //签署人信息集合
        result.put("signers", signersNew);
        //流程主题
        result.put("subject", params.get("subject"));

        //一键落章
        result.put("signSceneNo", "QSCJ0001");

        JSONObject json = new JSONObject(result);
        String param = json.toString();

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        SignFlowsInfoHclc signFlowsInfoHclc = new SignFlowsInfoHclc();

        try {

            //初始化接口信息
            String url = getApiUrl(signatureSysName, signFlowsApiName);
            logger.debug("sign flows url: {}", url);

            signFlowsInfoHclc.setContractNo(params.getString("bizNo"));
            signFlowsInfoHclc.setSignAction("SIGN_CREATE");
            signFlowsInfoHclc.setStatus("0");
            signFlowsInfoHclc.setRequestClob(param);
            signFlowsInfoHclc = iSignFlowsInfoHclcService.insertSelective(requestContext, signFlowsInfoHclc);


            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            jsonResult = JSONObject.parseObject(stringResult);
            signFlowsInfoHclc.setResponseClob(stringResult);
            if (!"0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                logger.error("create sign flows failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
            } else {

                JSONObject data = jsonResult.getJSONObject("data");
                signFlowsInfoHclc.setSignFlowId(data.getString("signFlowId"));
                signFlowsInfoHclc.setReturnCode(jsonResult.getString("errCode"));
                signFlowsInfoHclc.setReturnMsg(jsonResult.getString("msg"));

                //解析返回签署信息集合，替换accountId为用户信息
                JSONArray signUrls = data.getJSONArray("signUrls");
                for (int i = 0; i < signUrls.size(); i++) {
                    JSONObject signUrl = signUrls.getJSONObject(i);

                    //建机自己
                    if ("0d83cfe0-4d86-11ea-b71a-b8599f3574b6".equalsIgnoreCase(signUrl.getString("accountId"))) {
                        signUrl.put("name", "日立建机");
                    } else {
                        //根据uniqueId获取用户信息
                        SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
                        signInfoHclc.setOpenId(signUrl.getString("uniqueId"));
                        signInfoHclc = this.selectByPrimaryKey(requestContext, signInfoHclc);

                        signUrl.put("idNo", signInfoHclc.getIdNo());
                        signUrl.put("name", signInfoHclc.getName());
                    }


                    signUrl.remove("accountId");
                    signUrl.remove("accountName");

                }
            }

        } catch (Exception e) {
            logger.error("create sign flows failed, msg:{}", e.getMessage());
            jsonResult.put("errCode", "000004");
            jsonResult.put("msg", "创建签署流程失败，" + e.getMessage());
        }

        if (Objects.nonNull(signFlowsInfoHclc)) {
            iSignFlowsInfoHclcService.updateByPrimaryKey(requestContext, signFlowsInfoHclc);
        }
        return jsonResult;
    }


    public void postSignFlowsResult(IRequest iRequest, JSONObject params) {

        //签署流程id不存在直接返回
        if (Objects.isNull(params.get("flowId"))) {
            return;
        }

        SignFlowsInfoHclc signFlowsInfoHclc = new SignFlowsInfoHclc();

        signFlowsInfoHclc.setSignAction(params.getString("action"));
        signFlowsInfoHclc.setSignFlowId(params.getString("flowId"));
        signFlowsInfoHclc.setResponseClob(params.toString());
        signFlowsInfoHclc.setStatus(params.getString("status"));
        signFlowsInfoHclc.setContractNo(params.getString("bizNo"));
        signFlowsInfoHclc.setSendFlag("N");

        signFlowsInfoHclc = iSignFlowsInfoHclcService.insertSelective(iRequest, signFlowsInfoHclc);

        //签署终结状态回调，获取所有签署流程文档下载地址
        if ("SIGN_FLOW_FINISH".equalsIgnoreCase(params.getString("action"))) {
            Map<String, Object> map = new HashMap<>();
            map = getSignFlowDocUrls(signFlowsInfoHclc.getSignFlowId());
            params.remove("finishDocUrlBeans");
            params.put("finishDocUrlBeans", map.get("signDocUrlList"));
            //角色签署完成状态回调，替换用户信息
        } else if ("SIGN_FLOW_UPDATE".equalsIgnoreCase(params.getString("action"))) {
            JSONObject accountInfo = params.getJSONObject("accountInfo");
            SignUserInfoHclc signUserInfoHclc = new SignUserInfoHclc();
            //判断是否机构用户
            if (Objects.isNull(accountInfo.getString("authOrgId")) || "".equalsIgnoreCase(accountInfo.getString("authOrgId"))) {
                signUserInfoHclc.setAccountId(accountInfo.getString("accountId"));
            } else {
                signUserInfoHclc.setAccountId(accountInfo.getString("authOrgId"));
            }
            JSONObject accountInfoNew = new JSONObject();
            if ("f858b8e9-5c3a-11ea-8486-506b4bfdce3c".equalsIgnoreCase(signUserInfoHclc.getAccountId())) {
                accountInfoNew.put("ctino", "");
                accountInfoNew.put("name", "日立建机");
            } else {
                //获取移动端用户信息
                signUserInfoHclc = signInfoHclcMapper.selectOne(signUserInfoHclc);

                accountInfoNew.put("ctino", signUserInfoHclc.getIdNo());
                accountInfoNew.put("name", signUserInfoHclc.getName());
            }
            params.remove("accountInfo");
            params.put("accountInfo", accountInfoNew);

        }

        try {

            //初始化接口信息
            String url = getApiUrl(hclcSysName, signSendApiName);
            logger.debug("sign flow url: {}", url);

            Map<String, String> headInfo = new HashMap<String, String>();
            headInfo.put("Content-Type", "application/x-www-form-urlencoded");

            JSONObject requestData = new JSONObject();
            requestData.put("requestData", params.toString());

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, requestData, headInfo, signHclcUtils1.APPLICATION_FORM_URLENCODED);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("true".equalsIgnoreCase(jsonResult.getString("success"))) {
                signFlowsInfoHclc.setSendFlag("Y");
                iSignFlowsInfoHclcService.updateByPrimaryKey(iRequest, signFlowsInfoHclc);
            } else {
                logger.error("post sign flow failed, errCode:{} ,msg:{}", jsonResult.getJSONObject("error").getString("code"), jsonResult.getJSONObject("error").getString("message"));
            }


            //签署终结状态回调，签署完成下载签署文件
            if ("SIGN_FLOW_FINISH".equalsIgnoreCase(params.getString("action"))) {
                //初始化签署文件下载接口信息
                String signUrl = getApiUrl(hclcSysName, signFileDownApiName);
                logger.debug("sign flow url: {}", url);

                Map<String, String> downHeadInfo = new HashMap<String, String>();
                headInfo.put("Content-Type", "application/x-www-form-urlencoded");

                //发送http请求
                String stringResult2 = signHclcUtils1.postString(signUrl, params, downHeadInfo, signHclcUtils1.APPLICATION_FORM_URLENCODED);

                //解析返回结果
                JSONObject jsonResult2 = JSONObject.parseObject(stringResult2);
                if (!"true".equalsIgnoreCase(jsonResult2.getString("success"))) {
                    logger.error("down sign file failed, errCode:{} ,msg:{}", jsonResult2.getJSONObject("error").getString("code"), jsonResult2.getJSONObject("error").getString("message"));
                }
            }

        } catch (Exception e) {
            logger.error("post sign flow failed ,msg:{}", e.getMessage());
        }

    }

    public Map<String, Object> getSignFlowDocUrls(String signFlowId) {
        Map<String, Object> map = new HashMap<>();

        //业务方交互上下文信息
        String param = "signFlowId=" + signFlowId + "&intranetFlag=Y";

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature("", projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        try {

            //初始化接口信息
            String url = getApiUrl(signatureSysName, getSignUrlsApiName);
            logger.debug("upload url: {}", url);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.getStr(url, param, headInfo);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                //设置返回accountId
                map.put("signDocUrlList", data.getJSONArray("signDocUrlList"));
                map.put("code", "0");
                map.put("message", "获取签署流程文档下载地址成功！");
            } else {
                logger.error("get sign flow doc urls failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "获取签署流程文档下载地址失败," + jsonResult.getString("msg"));
            }
        } catch (Exception e) {
            logger.error("create person account failed, msg:{}", e.getMessage());
            map.put("code", "000001");
            map.put("message", "获取签署流程文档下载地址失败，请检查！" + e.getMessage());
        }

        return map;
    }

//    public JSONObject cancelSignFlows(IRequest requestContext, JSONObject params) {
//
//        JSONObject jsonResult = new JSONObject();
//
//
//        JSONObject result = new JSONObject();
//        //第三方业务码
//        result.put("bizNo", params.get("bizNo"));
//        //作废原因
//        result.put("reason", params.get("reason"));
//        //原签署流程id
//        result.put("signFlowId", params.get("signFlowId"));
//
//        JSONObject json = new JSONObject(result);
//        String param = json.toString();
//
//        //获取HMAC加密后的X-timevale-signature签名信息
//        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
//        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");
//
//        //设置http请求head信息
//        Map<String, String> headInfo = new HashMap<String, String>();
//        headInfo.put("x-timevale-project-id", projectId);
//        headInfo.put("x-timevale-signature", EncryptedString);
//
//        SignFlowsInfoHclc signFlowsInfoHclc = new SignFlowsInfoHclc();
//
//        try {
//
//            //初始化接口信息
//            String url = getApiUrl(signatureSysName, signFlowsApiName);
//            logger.debug("sign flows url: {}", url);
//
//            signFlowsInfoHclc.setContractNo(params.getString("bizNo"));
//            signFlowsInfoHclc.setSignAction("SIGN_CANCEL");
//            signFlowsInfoHclc.setStatus("5");
//            signFlowsInfoHclc.setRequestClob(param);
//            signFlowsInfoHclc = iSignFlowsInfoHclcService.insertSelective(requestContext, signFlowsInfoHclc);
//
//
//            //发送http请求
//            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
//            String stringResult = signHclcUtils1.postString(url, param, headInfo);
//
//            //解析返回结果
//            jsonResult = JSONObject.parseObject(stringResult);
//            signFlowsInfoHclc.setResponseClob(stringResult);
//            if (!"0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
//                logger.error("create sign flows failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
//            } else {
//
//                JSONObject data = jsonResult.getJSONObject("data");
//                signFlowsInfoHclc.setSignFlowId(data.getString("signFlowId"));
//                signFlowsInfoHclc.setReturnCode(jsonResult.getString("errCode"));
//                signFlowsInfoHclc.setReturnMsg(jsonResult.getString("msg"));
//
//                //解析返回签署信息集合，替换accountId为用户信息
//                JSONArray signUrls = data.getJSONArray("signUrls");
//                for (int i = 0; i < signUrls.size(); i++) {
//                    JSONObject signUrl = signUrls.getJSONObject(i);
//
//                    //建机自己
//                    if ("0d83cfe0-4d86-11ea-b71a-b8599f3574b6".equalsIgnoreCase(signUrl.getString("accountId"))) {
//                        signUrl.put("name", "日立建机");
//                    } else {
//                        //根据uniqueId获取用户信息
//                        SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
//                        signInfoHclc.setOpenId(signUrl.getString("uniqueId"));
//                        signInfoHclc = this.selectByPrimaryKey(requestContext, signInfoHclc);
//
//                        signUrl.put("idNo", signInfoHclc.getIdNo());
//                        signUrl.put("name", signInfoHclc.getName());
//                    }
//
//
//                    signUrl.remove("accountId");
//                    signUrl.remove("accountName");
//
//                }
//            }
//
//        } catch (Exception e) {
//            logger.error("create sign flows failed, msg:{}", e.getMessage());
//            jsonResult.put("errCode", "000004");
//            jsonResult.put("msg", "创建签署流程失败，" + e.getMessage());
//        }
//
//        if (Objects.nonNull(signFlowsInfoHclc)) {
//            iSignFlowsInfoHclcService.updateByPrimaryKey(requestContext, signFlowsInfoHclc);
//        }
//        return jsonResult;
//    }
}
