package com.hand.app.esignHclc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;


/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Service
public class SignInfoHclcFaceServiceImpl extends BaseServiceImpl<SignUserFaceHclc> implements ISignInfoHclcFaceService {

    private final Object lock = new Object();
    @Autowired
    private ISignInfoHclcService iSignInfoHclcService;

    public void postAuthResult(IRequest iRequest, JSONObject params) {

        synchronized (lock) {

            if (Objects.isNull(params.get("contextId"))) {
                return;
            }

            SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
            signInfoHclcFace.setAuthId(Long.valueOf(params.get("contextId").toString()));
            signInfoHclcFace = this.selectByPrimaryKey(iRequest, signInfoHclcFace);

            //判断认证识别流程是否存在
            if (Objects.nonNull(signInfoHclcFace) && !"SUCCESS".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {

                //判断认证返回结果成功
                if ("true".equalsIgnoreCase(params.get("success").toString())) {
                    //更新认证明细表状态
                    signInfoHclcFace.setAuthStatus("SUCCESS");
                    signInfoHclcFace.setVerifyCode(params.get("verifycode").toString());

                    SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
                    signInfoHclc.setOpenId(signInfoHclcFace.getOpenId());
                    signInfoHclc = iSignInfoHclcService.selectByPrimaryKey(iRequest, signInfoHclc);
                    //更新用户认证状态为Y
                    if (signInfoHclc.getCtitype().compareTo(1L) == 0 || (signInfoHclc.getCtitype().compareTo(2L) == 0 && "2".equalsIgnoreCase(signInfoHclcFace.getAuthType()))) {
                        signInfoHclc.setAuthFlag("Y");
                        iSignInfoHclcService.updateByPrimaryKeySelective(iRequest, signInfoHclc);
                    }
                } else {
                    //更新认证明细表状态
                    signInfoHclcFace.setAuthStatus("FAIL");
                    signInfoHclcFace.setVerifyCode(params.get("verifycode").toString());
                }
                this.updateByPrimaryKey(iRequest, signInfoHclcFace);
            }
        }
    }
}
