package com.hand.app.esignHclc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esign.utils.AlgorithmHelper;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.service.IOrganSignInfoHclcService;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.utils.HttpUtil;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Service
public class OrganSignInfoHclcServiceImpl extends BaseServiceImpl<SignUserInfoHclc> implements IOrganSignInfoHclcService {
    @Value("${tsign.project.id}")
    private String projectId;
    @Value("${tsign.project.secret}")
    private String projectSecret;
    @Value("${tsign.api.notifyUrl}")
    private String notifyUrl;
    @Value("${tsign.face.api.appId}")
    private String appId;
    @Value("${tsign.face.api.secret}")
    private String secret;
    @Autowired
    private ISignInfoHclcFaceService signInfoHclcFaceService;
    @Autowired
    private ISignInfoHclcService iSignInfoHclcService;

    //用户认证接口信息
    public static final String indivSysName = "HCLC_FACE_API";
    public static final String tokenApiName = "getToken";
    public static final String orgApiName = "getOrgAuthUrl";
    public static final String getOrgIdApiName = "getOrgByThirdId";
    //电子签章接口信息
    public static final String signatureSysName = "HCLC_ELECTRONIC_SIGNATURE";
    public static final String organsApiName = "outerOrgans";
    public static final String deleteApiName = "organizationsDelete";
    private static final String HASH_ALGORITHM = "HmacSHA256";

    private final static int HTTP_OK = 200;

    @Autowired
    IHapInterfaceHeaderService headerService;

    private Logger logger = LoggerFactory.getLogger(getClass());

    public Map<String, Object> getOrganIndividualFaceUrl(IRequest iRequest, SignUserInfoHclc info) {

        Map<String, Object> mapOrgan = new HashMap<>();

        if (Objects.isNull(info.getOpenId()) || "undefined".equalsIgnoreCase(info.getOpenId())) {
            logger.error("关键参数openId不存在，调用失败!");
            mapOrgan.put("code", "1");
            mapOrgan.put("message", "关键参数openId不存在，调用失败!");
            return mapOrgan;
        }

        //查询用户信息
        SignUserInfoHclc signInfoHclc = mapper.selectByPrimaryKey(info);

        //初始化创建用户判断
        String accountStatus = null;
        String getUrlType = null;

        //用户信息不存在，新增用户信息，创建e签宝经办人账户，获取经办人人脸核验url
        if (Objects.isNull(signInfoHclc)) {
            info.setCtitype(2L);
            info.setAuthFlag("N");
            signInfoHclc = this.insertSelective(iRequest, info);
            accountStatus = "AGENT_ADD";
            getUrlType = "AGENT";
        } else {
            signInfoHclc.setCtitype(2L);
            signInfoHclc.setAgentType(info.getAgentType());

            if ("Y".equalsIgnoreCase(signInfoHclc.getAuthFlag())) {
                mapOrgan.put("code", "2");
                mapOrgan.put("message", "机构认证已完成，无需重复验证！");
                return mapOrgan;
            }

            //移动端用户信息发生变更，需要注销e签宝账户，重新创建，并获取核验url
            if (!info.getAgentIdNo().equalsIgnoreCase(signInfoHclc.getAgentIdNo()) || !info.getAgentName().equalsIgnoreCase(signInfoHclc.getAgentName()) || !info.getMobile().equalsIgnoreCase(signInfoHclc.getMobile())) {
                //e签宝账户不存在，需要创建e签宝账户
                if (Objects.isNull(signInfoHclc.getAgentAccountId())) {
                    accountStatus = "AGENT_ADD";
                    getUrlType = "AGENT";
                }
                //e签宝账户已存在，注销e签宝账户重新创建
                else {
                    accountStatus = "AGENT_MODIFY";
                    getUrlType = "AGENT";
                }

            }
            //移动端用户信息未发生变更
            else {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                //存在人脸核验记录，获取原核验信息判断是否核验完成
                if (Objects.nonNull(signInfoHclc.getFaceAuthId())) {
                    //查询经办人e签宝人脸核验信息
                    signInfoHclcFace.setAuthId(signInfoHclc.getFaceAuthId());
                    signInfoHclcFace = signInfoHclcFaceService.selectByPrimaryKey(iRequest, signInfoHclcFace);

                    //判断人脸核身认证状态，核验完成直接获取机构核验url
                    if ("SUCCESS".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                        getUrlType = "ORG";
                    } else if ("FAIL".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                        accountStatus = "AGENT_EXISTS";
                        getUrlType = "AGENT";
                    } else {
                        //返回原核验url
                        mapOrgan.put("code", "0");
                        mapOrgan.put("url", signInfoHclcFace.getUrl());
                        mapOrgan.put("message", "获取url成功！");
                        return mapOrgan;
                    }

                }  //不存在人脸核验记录，判断是否存在e签宝用户创建记录
                else {
                    //e签宝账户不存在，需要新增
                    if (Objects.isNull(signInfoHclc.getAgentAccountId())) {
                        accountStatus = "AGENT_ADD";
                        getUrlType = "AGENT";
                    }
                    //e签宝账户已存在，不需要新增，直接获取人脸核验url
                    else {
                        accountStatus = "AGENT_EXISTS";
                        getUrlType = "AGENT";
                    }
                }
            }
        }

        //经办人人脸识别url
        if ("AGENT".equalsIgnoreCase(getUrlType)) {
            //初始化经办人人脸识别信息
            SignUserInfoHclc agentSignInfo = new SignUserInfoHclc();
            agentSignInfo.setOpenId(info.getOpenId());
            agentSignInfo.setIdNo(info.getAgentIdNo());
            agentSignInfo.setMobile(info.getMobile());
            agentSignInfo.setName(info.getAgentName());
            agentSignInfo.setCtitype(signInfoHclc.getCtitype());

            if (!"AGENT_EXISTS".equalsIgnoreCase(accountStatus)) {
                //移动端用户信息发生变更，先注销e签宝用户
                if ("AGENT_MODIFY".equalsIgnoreCase(accountStatus)) {

                    if (Objects.nonNull(signInfoHclc.getAccountId())) {
                        mapOrgan = deleteOrgansAccount(iRequest, signInfoHclc);

                        if (!"0".equalsIgnoreCase(mapOrgan.get("code").toString()) && !"40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                            return mapOrgan;
                        }
                        //注销成功
                        signInfoHclc.setAccountId("");
//                            signInfoHclc.setAuthAccountId("");
                        //重新设置机构用户信息
                        signInfoHclc.setIdNo(info.getIdNo());
                        signInfoHclc.setName(info.getName());
                        signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                        signInfoHclc.setLegalName(info.getLegalName());
                        signInfoHclc.setOrgAuthId(null);
                    }


                    agentSignInfo.setAccountId(signInfoHclc.getAgentAccountId());
                    mapOrgan = iSignInfoHclcService.deletePersonAccount(iRequest, agentSignInfo);
                    //注销成功
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        agentSignInfo.setAccountId("");
                        signInfoHclc.setAgentAccountId("");
                        signInfoHclc.setAuthAgentAccountId("");
                        //重新设置经办人信息
                        signInfoHclc.setAgentIdNo(info.getAgentIdNo());
                        signInfoHclc.setAgentName(info.getAgentName());
                        if (signInfoHclc.getAgentType().compareTo(1L) == 0) {
                            signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                            signInfoHclc.setLegalName(info.getLegalName());
                        }
                        signInfoHclc.setMobile(info.getMobile());
                        signInfoHclc.setAgentType(info.getAgentType());
                        signInfoHclc.setFaceAuthId(null);
                    }
                }

                //注销e签宝用户或者只创建e签宝账户
                if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {

                    //创建e签宝账户
                    mapOrgan = iSignInfoHclcService.addPersonAccount(agentSignInfo);
                    //创建成功
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setAgentAccountId(mapOrgan.get("accountId").toString());
                        signInfoHclc.setSealId(mapOrgan.get("sealId").toString());
                        if ("AGENT_ADD".equalsIgnoreCase(accountStatus)) {
                            //重新设置经办人信息
                            signInfoHclc.setAgentIdNo(info.getAgentIdNo());
                            signInfoHclc.setAgentName(info.getAgentName());
                            if (signInfoHclc.getAgentType().compareTo(1L) == 0) {
                                signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                                signInfoHclc.setLegalName(info.getLegalName());
                            }
                            signInfoHclc.setMobile(info.getMobile());
                            signInfoHclc.setAgentType(info.getAgentType());
                        }
                    }
                    signInfoHclc.setCreateCode(mapOrgan.get("code").toString());
                    signInfoHclc.setCreateMessage(mapOrgan.get("message").toString());
                }
            }


            if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                //初始化接口密钥参数信息
                SignHclcUtils signHclcUtils = new SignHclcUtils();
                agentSignInfo = signHclcUtils.initProject(agentSignInfo, appId, secret, notifyUrl);

                //获取鉴权Token
                String tokenApiUrl = iSignInfoHclcService.getApiUrl(indivSysName, tokenApiName);
                logger.debug("upload url: {}", tokenApiUrl);
                String token = signHclcUtils.getFaceApiToken(tokenApiUrl, agentSignInfo.getAppId(), agentSignInfo.getSecret());

                //获取鉴权Token接口结果返回成功
                if (Objects.nonNull(token)) {

//                    agentSignInfo.setAccountId(signInfoHclc.getAgentAccountId());

//                    //获取身份验证公有云账户id
//                    if (signInfoHclc.getAuthAgentAccountId() == null || "".equalsIgnoreCase(signInfoHclc.getAuthAgentAccountId())) {
//                        mapOrgan = iSignInfoHclcService.getByThirdId(agentSignInfo, token);
//                        if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
//                            signInfoHclc.setAuthAgentAccountId(mapOrgan.get("authAccountId").toString());
//                        }
//                    }

//                    if (signInfoHclc.getAuthAgentAccountId() == null || "".equalsIgnoreCase(signInfoHclc.getAuthAgentAccountId())) {
//                        mapOrgan.put("code", "10");
//                        mapOrgan.put("message", "获取验证公有云accountId失败，请检查！");
//                    } else {
//
//                        agentSignInfo.setAuthAccountId(signInfoHclc.getAuthAgentAccountId());

                    //设置经办人人脸验证成功跳转地址
                    agentSignInfo.setRedirectUrl(info.getRedirectUrl());
                    //获取个人核身认证地址
                    mapOrgan = iSignInfoHclcService.getFaceUrlHttp(iRequest, agentSignInfo, token);

                    //接口结果返回成功
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setFaceAuthId(Long.valueOf(mapOrgan.get("faceAuthId").toString()));
                    }
//                    }
                }
                //获取鉴权Token接口结果返回失败
                else {
                    mapOrgan.put("code", "2");
                    mapOrgan.put("message", "获取鉴权Token失败，请检查！");
                }
            }

        } else {
            //查询e签宝机构打款核验状态
            SignUserFaceHclc signInfoHclcOrg = new SignUserFaceHclc();
            if (Objects.nonNull(signInfoHclc.getOrgAuthId())) {
                signInfoHclcOrg.setAuthId(signInfoHclc.getOrgAuthId());
                signInfoHclcOrg = signInfoHclcFaceService.selectByPrimaryKey(iRequest, signInfoHclcOrg);
            }

            //移动端用户信息发生变更，需要注销e签宝账户，重新创建，并获取企业核验url
            if (!info.getIdNo().equalsIgnoreCase(signInfoHclc.getIdNo()) || !info.getName().equalsIgnoreCase(signInfoHclc.getName()) || !info.getLegalIdNo().equalsIgnoreCase(signInfoHclc.getLegalIdNo()) || !info.getLegalName().equalsIgnoreCase(signInfoHclc.getLegalName())) {

                //判断人脸核身认证状态，核验完成直接结束任务
                if (Objects.nonNull(signInfoHclcOrg)) {
                    if ("SUCCESS".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
                        mapOrgan.put("code", "10");
                        mapOrgan.put("message", "企业对公打款认证已完成，无需重复验证！");
                        return mapOrgan;
                    }
//                    else if ("AUTHING".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
//                        mapOrgan.put("code", "11");
//                        mapOrgan.put("message", "企业对公打款认证中，请耐心等待认证结果！");
//                        return mapOrgan;
//                    }
                }

                //e签宝账户不存在，需要新增
                if (Objects.isNull(signInfoHclc.getAccountId())) {
                    accountStatus = "ORG_ADD";
                }
                //e签宝账户已存在，需要注销，重新创建e签宝账户
                else {
                    accountStatus = "ORG_MODIFY";
                }

            }//移动端用户信息未发生变更
            else {
                //存在对应核验url信息
                if (Objects.nonNull(signInfoHclcOrg.getAuthId())) {
                    //判断对公打款认证状态，核验完成直接结束任务
                    if ("SUCCESS".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
                        mapOrgan.put("code", "10");
                        mapOrgan.put("message", "企业对公打款认证已完成，无需重复验证！");
                        return mapOrgan;
                    } else if ("FAIL".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
                        accountStatus = "ORG_EXISTS";
                    } else {
                        //返回原核验url
                        mapOrgan.put("code", "0");
                        mapOrgan.put("url", signInfoHclcOrg.getUrl());
                        mapOrgan.put("message", "获取url成功！");
                        return mapOrgan;
                    }
                }
                //不存在对应核验完成url，重新获取url
                else {
                    //e签宝账户不存在，需要新增企业账户
                    if (Objects.isNull(signInfoHclc.getAccountId())) {
                        accountStatus = "ORG_ADD";
                    }
                    //e签宝账户已存在，不需要新增，直接获取企业核验url
                    else {
                        accountStatus = "ORG_EXISTS";
                    }
                }
            }

            if (!"ORG_EXISTS".equalsIgnoreCase(accountStatus)) {
                //移动端用户信息发生变更，先注销e签宝用户
                if ("ORG_MODIFY".equalsIgnoreCase(accountStatus)) {
                    mapOrgan = deleteOrgansAccount(iRequest, signInfoHclc);
                    //注销成功
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setAccountId("");
//                        signInfoHclc.setAuthAccountId("");
                        //重新设置机构用户信息
                        signInfoHclc.setIdNo(info.getIdNo());
                        signInfoHclc.setName(info.getName());
                        signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                        signInfoHclc.setLegalName(info.getLegalName());
                        signInfoHclc.setOrgAuthId(null);
                    }
                }

                //创建e签宝账户
                if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                    //初始化经办人人脸识别信息
                    SignUserInfoHclc ogrSignInfo = new SignUserInfoHclc();
                    ogrSignInfo.setAgentAccountId(signInfoHclc.getAgentAccountId());
                    ogrSignInfo.setAgentIdNo(signInfoHclc.getAgentIdNo());
                    ogrSignInfo.setLegalIdNo(info.getLegalIdNo());
                    ogrSignInfo.setLegalName(info.getLegalName());
                    ogrSignInfo.setIdNo(info.getIdNo());
                    ogrSignInfo.setName(info.getName());
                    ogrSignInfo.setOpenId(signInfoHclc.getOpenId());


                    mapOrgan = addOrgansAccount(ogrSignInfo);
                    //创建成功
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setAccountId(mapOrgan.get("organizeId").toString());
                        if ("ORG_ADD".equalsIgnoreCase(accountStatus)) {
                            //重新设置机构用户信息
                            signInfoHclc.setIdNo(info.getIdNo());
                            signInfoHclc.setName(info.getName());
                            signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                            signInfoHclc.setLegalName(info.getLegalName());
                        }
                    }
                    signInfoHclc.setCreateCode(mapOrgan.get("code").toString());
                    signInfoHclc.setCreateMessage(mapOrgan.get("message").toString());
                }
            }

            //用户创建成功
            if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                //初始化接口密钥参数信息
                SignHclcUtils signHclcUtils = new SignHclcUtils();
                signInfoHclc = signHclcUtils.initProject(signInfoHclc, appId, secret, notifyUrl);

                //获取鉴权Token
                String tokenApiUrl = iSignInfoHclcService.getApiUrl(indivSysName, tokenApiName);
                logger.debug("upload url: {}", tokenApiUrl);
                String token = signHclcUtils.getFaceApiToken(tokenApiUrl, signInfoHclc.getAppId(), signInfoHclc.getSecret());

                if (Objects.nonNull(token)) {

//                    //获取身份验证公有云账户id
//                    if (signInfoHclc.getAuthAccountId() == null || "".equalsIgnoreCase(signInfoHclc.getAuthAccountId())) {
//                        mapOrgan = getByThirdId(signInfoHclc, token);
//                        if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
//                            signInfoHclc.setAuthAccountId(mapOrgan.get("authOrgAccountId").toString());
//                        }
//                    }

//                    if (signInfoHclc.getAuthAccountId() == null || "".equalsIgnoreCase(signInfoHclc.getAuthAccountId())) {
//                        mapOrgan.put("code", "10");
//                        mapOrgan.put("message", "获取验证公有云accountId失败，请检查！");
//                    } else {

                    signInfoHclc.setRedirectUrl(info.getRedirectUrl());
                    //获取组织机构核身地址
                    mapOrgan = this.getOrgAuthUrlHttp(iRequest, signInfoHclc, token);
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setOrgAuthId(Long.valueOf(mapOrgan.get("orgAuthId").toString()));
                    }
//                    }

                } else {
                    mapOrgan.put("code", "2");
                    mapOrgan.put("message", "获取鉴权Token失败，请检查！");
                }
            }

        }
        this.updateByPrimaryKey(iRequest, signInfoHclc);
        return mapOrgan;
    }

    public Map<String, Object> getOrgAuthUrlHttp(IRequest iRequest, SignUserInfoHclc info, String token) {

        //初始化人脸核验流程初始化数据
        SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
        signInfoHclcFace.setOpenId(info.getOpenId());
        signInfoHclcFace.setAuthStatus("NEW");
        signInfoHclcFace.setAuthType("2");
        signInfoHclcFace = signInfoHclcFaceService.insertSelective(iRequest, signInfoHclcFace);

        //业务方交互上下文信息
        JSONObject json1 = new JSONObject();
        json1.put("contextId", signInfoHclcFace.getAuthId());
        json1.put("notifyUrl", info.getNotifyUrl());
        json1.put("redirectUrl", info.getRedirectUrl());

        //企业/组织认证基本信息
        JSONObject json2 = new JSONObject();
        //组织机构名称
        json2.put("name", info.getName());
        //组织机构证件号
        json2.put("certNo", info.getIdNo());
        //组织机构证件类型-统一社会信用代码
        json2.put("certType", "ORGANIZATION_USC_CODE");
        //法定代表人证件号
        json2.put("legalRepCertNo", info.getLegalIdNo());
        //法定代表人证件类型-中国大陆身份证
        json2.put("egalRepCertType", "INDIVIDUAL_CH_IDCARD");
        //法定代表人姓名
        json2.put("legalRepName", info.getLegalName());
        //经办人姓名
        json2.put("agentName", info.getAgentName());
        //经办人身份证号
        json2.put("agentIdNo", info.getAgentIdNo());
        //法定代表人地区/国籍
//        json2.put("legalRepNationality", "");
        //经办人身份1	企业法定代表人;2	企业授权代理人
        json2.put("operatorType", info.getAgentType());
        //组织核验类型，“1”:三要素核验；“2”：四要素核验；不填为不指定核验类型
        json2.put("verifyType", "2");

        //认证配置信息
        JSONObject json3 = new JSONObject();
        String[] str = new String[]{"name", "certNo", "legalRepName", "legalRepCertNo", "agentName", "agentIdNo"};
        json3.put("indivUneditableInfo", str);

        JSONObject result = new JSONObject();
//        result.put("agentAccountId", info.getAuthAgentAccountId());
        result.put("authType", "ORG_BANK_TRANSFER");//组织机构对公账户打款认证
        result.put("contextInfo", json1);
        result.put("orgEntity", json2);
        result.put("configParams", json3);
//        result.put("repeatIdentity", false);
        JSONObject json = new JSONObject(result);
//        String param = json.toString();

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", info.getAppId());
        headInfo.put("X-Tsign-Open-Token", token);
        Map<String, Object> map = new HashMap<>();

        try {
            //初始化接口信息
            String orgApiurl = iSignInfoHclcService.getApiUrl(indivSysName, orgApiName);
//            orgApiurl = orgApiurl.replace("{accountId}", info.getAuthAccountId());
            logger.debug("upload url: {}", orgApiurl);

            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            //发送http请求
            String stringResult = signHclcUtils1.postString(orgApiurl, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                signInfoHclcFace.setFlowId(data.getString("flowId"));
                signInfoHclcFace.setUrl(data.getString("url"));
                signInfoHclcFace.setShortLink(data.getString("shortLink"));
                signInfoHclcFace.setAuthStatus("AUTHING");

                map.put("code", "0");
                map.put("orgAuthId", signInfoHclcFace.getAuthId());
                map.put("url", data.getString("url"));
                map.put("AuthType", "ORG");
                map.put("message", "获取url成功！");
            } else {
                map.put("code", jsonResult.getString("code"));
                map.put("message", "获取组织机构实名认证地址失败," + jsonResult.getString("message"));
            }
            signInfoHclcFace.setReturnCode(jsonResult.getString("code"));
            signInfoHclcFace.setReturnMessage(jsonResult.getString("message"));
            signInfoHclcFaceService.updateByPrimaryKey(iRequest, signInfoHclcFace);

        } catch (Exception e) {
            map.put("code", "17");
            map.put("message", "访问e签宝组织机构实名认证地址失败，" + e.getMessage());
            signInfoHclcFace.setReturnCode("3");
            signInfoHclcFace.setReturnMessage(e.getMessage());
            signInfoHclcFaceService.updateByPrimaryKey(iRequest, signInfoHclcFace);
        }

        return map;
    }


    public Map<String, Object> addOrgansAccount(SignUserInfoHclc signInfoHclc) {
        Map<String, Object> map = new HashMap<>();

        //业务方交互上下文信息
        JSONObject result = new JSONObject();
        //默认经办人id agentUniqueId和agentUniqueId都不为空的情况，以accountId为准
        result.put("agentAccountId", signInfoHclc.getAgentAccountId());
        //默认经办人唯一标识
        result.put("agentUniqueId", signInfoHclc.getOpenId());
        //银行卡号
        result.put("cardNo", "");
        //当前机构联系邮箱
        result.put("email", "");
        //法定代表人证件号码
        result.put("legalLicenseNumber", signInfoHclc.getLegalIdNo());
        //法定代表人证件类型：IDCard-身份证号码，Passport-中国护照，HMPass-港澳居民来往内地通行证，MTP-台胞证，Other-其它
        result.put("legalLicenseType", "IDCard");
        //法定代表人手机号
        result.put("legalMobile", "");
        //法定代表人姓名
        result.put("legalName", signInfoHclc.getLegalName());
        //证照号码
        result.put("licenseNumber", signInfoHclc.getIdNo());
        //证照类型 ：ORANO-机构代码证，SOCNO-社会信用代码，BUSNO-工商注册号
        result.put("licenseType", "SOCNO");
        //机构名称
        result.put("organizeName", signInfoHclc.getName());
        //机构唯一标识
        result.put("organizeNo", signInfoHclc.getOpenId() + "-ORG");
        JSONObject json = new JSONObject(result);
        String param = json.toString();

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        try {

            //初始化接口信息
            String url = iSignInfoHclcService.getApiUrl(signatureSysName, organsApiName);
            logger.debug("create organs account url: {}", url);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("organizeId", data.getString("organizeId"));
                map.put("code", "0");
                map.put("message", "机构e签宝账户创建成功！");
            } else {
                logger.error("create organs account failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "机构e签宝账户创建失败," + jsonResult.getString("msg"));
            }

        } catch (Exception e) {
            logger.error("create organs account failed, msg:{}", e.getMessage());
            map.put("code", "000015");
            map.put("message", "机构e签宝账户创建失败，" + e.getMessage());
        }
        return map;
    }

    public Map<String, Object> deleteOrgansAccount(IRequest iRequest, SignUserInfoHclc signInfoHclc) {
        Map<String, Object> map = new HashMap<>();

        signInfoHclc = iSignInfoHclcService.selectByPrimaryKey(iRequest, signInfoHclc);

        if (Objects.isNull(signInfoHclc)) {
            logger.debug("未找到对应e签宝机构用户信息，请检查！");
            map.put("code", "000002");
            map.put("message", "未找到对应e签宝机构用户信息，请检查！");
            return map;
        }

        if (Objects.isNull(signInfoHclc.getAccountId()) || "".equalsIgnoreCase(signInfoHclc.getAccountId())) {
            logger.debug("e签宝机构账户 accountId: {} 不存在，无需注销！", signInfoHclc.getAccountId());
            map.put("code", "40051667");
            map.put("message", "e签宝机构账户不存在，无需注销！");
            return map;
        }

        //业务方交互上下文信息
        JSONObject result = new JSONObject();
        //机构名称
        result.put("organizeId", signInfoHclc.getAccountId());
        //机构唯一标识
        result.put("organizeNo", signInfoHclc.getOpenId() + "-ORG");
        JSONObject json = new JSONObject(result);
        String param = json.toString();

        //获取HMAC加密后的X-timevale-signature签名信息
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = algorithmHelper.getXtimevaleSignature(param, projectSecret, HASH_ALGORITHM, "UTF-8");

        //设置http请求head信息
        Map<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", projectId);
        headInfo.put("x-timevale-signature", EncryptedString);

        try {

            //初始化接口信息
            String url = iSignInfoHclcService.getApiUrl(signatureSysName, deleteApiName);
            logger.debug("upload url: {}", url);

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, signHclcUtils1.APPLICATION_JSON);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode")) || "40051667".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                map.put("code", "0");
                map.put("message", "e签宝机构用户注销成功！");
            } else {
                logger.error("delete organs account failed, errCode:{} ,msg:{}", jsonResult.getString("errCode"), jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "e签宝机构用户注销失败," + jsonResult.getString("msg"));
            }

        } catch (Exception e) {
            logger.error("delete organs account failed, msg:{}", e.getMessage());
            map.put("code", "000013");
            map.put("message", "e签宝机构用户注销失败，" + e.getMessage());
        }

        return map;
    }

    /***
     * 查询机构账户（按照第三方用户ID查询）;
     * @param info
     * @param token
     ***/
    public Map<String, Object> getByThirdId(SignUserInfoHclc info, String token) {
        Map<String, Object> map = new HashMap<>();

        //设置http请求head信息
        JSONObject headInfo = new JSONObject();
        headInfo.put("X-Tsign-Open-App-Id", info.getAppId());
        headInfo.put("X-Tsign-Open-Token", token);

        String param = "thirdPartyUserId=" + info.getIdNo();

        try {
            //初始化接口url信息
            String orgApiurl = iSignInfoHclcService.getApiUrl(indivSysName, getOrgIdApiName) + "?" + param;
            logger.debug("upload url: {}", orgApiurl);

            //发送http请求
            HttpResponse execute = HttpUtil.getJson(orgApiurl, headInfo);
            int httpReponseCode;
            String stringResult = null;
            JSONObject responseBody = new JSONObject();
            if (execute != null) {
                httpReponseCode = execute.getStatusLine().getStatusCode();
                if (httpReponseCode != HTTP_OK) {
                    responseBody.put("code", httpReponseCode);
                    responseBody.put("message", execute.getStatusLine().getReasonPhrase());
                    stringResult = responseBody.toString();
                } else {
                    stringResult = HttpUtil.HttpResponseParseJson(execute);
                }
                //解析返回结果
                JSONObject jsonResult = JSONObject.parseObject(stringResult);
                if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                    JSONObject data = jsonResult.getJSONObject("data");

                    map.put("code", "0");
                    map.put("authOrgAccountId", data.getString("orgId"));
                    map.put("message", "获取身份认证账户成功！");
                } else {
                    map.put("code", jsonResult.getString("code"));
                    map.put("message", "获取身份认证账户失败," + jsonResult.getString("message"));
                }
            } else {
                map.put("code", "10");
                map.put("message", "获取身份认证账户发送网络请求失败，请检查身份认证地址信息！");
            }
        } catch (Exception e) {
            map.put("code", "9");
            map.put("message", e.getMessage());
        }

        return map;
    }
}
