package com.hand.app.esignHclc.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esignHclc.dto.SignUserAttachInfo;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.dto.SignUserInfoHclcHis;
import com.hand.app.esignHclc.service.*;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.formbean.AttachmentInfo;
import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class SignHclcController extends BaseController {
    @Autowired
    private ISignInfoHclcService signHclcService;
    @Autowired
    private IOrganSignInfoHclcService organSignHclcService;
    @Autowired
    private ISignInfoHclcFaceService signInfoHclcFaceService;
    @Autowired
    private ISignUserInfoHclcHisService signUserInfoHclcHisService;
    @Autowired
    private ISignUserAttachInfoService iSignUserAttachInfoService;


    /**
     * 根据openid获取用户信息
     *
     * @param request
     * @param dto     根据openid获取用户信息
     * @return responseData
     */
    @ResponseBody
    @RequestMapping(value = "/sign/info/hclc/query/by/openid")
    public ResponseData query(HttpServletRequest request, SignUserInfoHclc dto) {
        IRequest requestContext = createRequestContext(request);
        List<SignUserInfoHclc> signInfoHclcs = new ArrayList<>();
        SignUserInfoHclc signInfoHclc = signHclcService.selectByPrimaryKey(requestContext, dto);

        if (Objects.nonNull(signInfoHclc)) {
            //获取人脸核验状态
            if (Objects.nonNull(signInfoHclc.getFaceAuthId())) {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                signInfoHclcFace.setAuthId(signInfoHclc.getFaceAuthId());
                signInfoHclcFace = signInfoHclcFaceService.selectByPrimaryKey(requestContext, signInfoHclcFace);
                signInfoHclc.setFaceAuthStatus(signInfoHclcFace.getAuthStatus());
            }

            //获取机构对公打款状态
            if (Objects.nonNull(signInfoHclc.getOrgAuthId())) {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                signInfoHclcFace.setAuthId(signInfoHclc.getOrgAuthId());
                signInfoHclcFace = signInfoHclcFaceService.selectByPrimaryKey(requestContext, signInfoHclcFace);
                signInfoHclc.setOrgAuthStatus(signInfoHclcFace.getAuthStatus());
            }

            SignUserAttachInfo signUserAttachInfo = new SignUserAttachInfo();
            signUserAttachInfo.setOpenId(signInfoHclc.getOpenId());
            List<SignUserAttachInfo> signUserAttachInfos = new ArrayList<>();
            //身份证附件Id
            {
                signUserAttachInfo.setAttachmentType("app_file_id_card");
                signUserAttachInfos = iSignUserAttachInfoService.select(requestContext, signUserAttachInfo, 1, 1);
                if (signUserAttachInfos.size() > 0 && Objects.nonNull(signUserAttachInfos.get(0).getAttachmentIdHclc())) {
                    signInfoHclc.setAttachmentId(signUserAttachInfos.get(0).getAttachmentIdHclc().toString());
                }
            }

            //营业执照附件Id
            {
                signUserAttachInfo.setAttachmentType("app_file_bus_lic");
                signUserAttachInfos = iSignUserAttachInfoService.select(requestContext, signUserAttachInfo, 1, 1);
                if (signUserAttachInfos.size() > 0 && Objects.nonNull(signUserAttachInfos.get(0).getAttachmentIdHclc())) {
                    signInfoHclc.setOrgAttachmentId(signUserAttachInfos.get(0).getAttachmentIdHclc().toString());
                }
            }
        }

        if (signInfoHclc != null) {
            signInfoHclcs.add(signInfoHclc);
        }
        return new ResponseData(signInfoHclcs);
    }

    /**
     * 创建个人用户
     *
     * @param request
     * @param dto     创建个人用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/accounts/outerAccounts/create")
    public Map<String, Object> addPersonAccount(HttpServletRequest request,
                                                @RequestBody SignUserInfoHclc dto) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);
        map = signHclcService.addPersonAccount(dto);
        if ("0".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            dto.setAccountId(map.get("accountId").toString());
            signHclcService.updateByPrimaryKey(createRequestContext(request), dto);
        }
        return map;

    }

    /**
     * 注销个人用户
     *
     * @param request
     * @param dto     注销个人用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/accounts/outerAccounts/delete")
    public Map<String, Object> deletePersonAccount(HttpServletRequest request,
                                                   @RequestBody SignUserInfoHclc dto) {
        IRequest iRequest = createRequestContext(request);
        Map<String, Object> map = new HashMap<>();
        if (Objects.isNull(dto.getOpenId())) {
            map.put("code", "000005");
            map.put("message", "关键参数openId不存在，调用失败!");
            return map;
        }
        map = signHclcService.deletePersonAccount(iRequest, dto);
        if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            SignUserInfoHclcHis signUserInfoHclcHis = new SignUserInfoHclcHis();
            BeanUtils.copyProperties(dto, signUserInfoHclcHis);
            signUserInfoHclcHisService.insert(iRequest, signUserInfoHclcHis);
            signHclcService.deleteByPrimaryKey(dto);
        }
        return map;

    }

    /**
     * 创建机构用户
     *
     * @param request
     * @param dto     创建机构用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/organizations/outerOrgans/create")
    public Map<String, Object> addOrgansAccount(HttpServletRequest request,
                                                @RequestBody SignUserInfoHclc dto) {

        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);
        map = organSignHclcService.addOrgansAccount(dto);
        if ("0".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            dto.setAccountId(map.get("organizeId").toString());
            signHclcService.updateByPrimaryKey(createRequestContext(request), dto);
        }
        return map;

    }

    /**
     * 注销机构用户
     *
     * @param request
     * @param dto     注销机构用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/organizations/outerOrgans/delete")
    public Map<String, Object> deleteOrgansAccount(HttpServletRequest request,
                                                   @RequestBody SignUserInfoHclc dto) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);

        if (Objects.isNull(dto.getOpenId())) {
            map.put("code", "000005");
            map.put("message", "关键参数openId不存在，调用失败!");
        }

        //注销机构账户
        map = organSignHclcService.deleteOrgansAccount(iRequest, dto);
        if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            //复制用户信息到历史表
            SignUserInfoHclcHis signUserInfoHclcHis = new SignUserInfoHclcHis();
            BeanUtils.copyProperties(dto, signUserInfoHclcHis);
            signUserInfoHclcHisService.insert(iRequest, signUserInfoHclcHis);

            //重置结构用户信息为空
            dto.setAccountId("");
            dto.setAuthAccountId("");
            dto.setOrgAuthId(null);
            dto.setAuthFlag("N");
            dto.setCreateCode("");
            dto.setCreateMessage("");

            //注销经办人用户
            //初始化经办人人脸识别信息
            SignUserInfoHclc agentSignInfo = new SignUserInfoHclc();
            agentSignInfo.setOpenId(dto.getOpenId());
            agentSignInfo.setIdNo(dto.getAgentIdNo());
            agentSignInfo.setMobile(dto.getMobile());
            agentSignInfo.setName(dto.getAgentName());
            agentSignInfo.setAccountId(dto.getAgentAccountId());
            map = signHclcService.deletePersonAccount(iRequest, agentSignInfo);
            if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
                signHclcService.deleteByPrimaryKey(dto);
            } else {
                signHclcService.updateByPrimaryKey(iRequest, dto);
            }
            //机构已注销，ccountaId为空的情况
        } else if ("000012".equalsIgnoreCase(map.get("code").toString())) {
            //注销经办人用户
            map = signHclcService.deletePersonAccount(iRequest, dto);
            if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
                signHclcService.deleteByPrimaryKey(dto);
            }
        }

        return map;

    }

    /**
     * 获取人身核验地址
     *
     * @param request
     * @param dto     获取人身核验地址
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/face")
    public Map<String, Object> getIndividualFaceUrl(HttpServletRequest request,
                                                    @RequestBody SignUserInfoHclc dto) {
        return signHclcService.getIndividualFaceUrl(createRequestContext(request), dto);

    }

    /**
     * 获取机构核验地址
     *
     * @param request
     * @param dto     获取机构核验地址
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/face/Organ")
    public Map<String, Object> getOrganIndividualFaceUrl(HttpServletRequest request,
                                                         @RequestBody SignUserInfoHclc dto) {
        return organSignHclcService.getOrganIndividualFaceUrl(createRequestContext(request), dto);

    }

    /**
     * 下载微信图片资源上传业务系统
     *
     * @param request
     * @param dto     下载微信图片资源上传业务系统
     */
    @RequestMapping(value = "/auth/upload/image/hls/from/wx", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject uploadHlsFromWx(HttpServletRequest request, @RequestBody AttachmentInfo dto) {
        return signHclcService.uploadHlsFromWx(createRequestContext(request), dto);
    }

    /**
     * 文件直传
     *
     * @param request
     * @param dto     文件直传
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/sign/files/upload")
    public Map<String, Object> signFileUpload(HttpServletRequest request,
                                              @RequestBody AttachmentInfo dto) {
        return signHclcService.signFileUpload(createRequestContext(request), dto);

    }

    /**
     * 创建签署流程
     *
     * @param request
     * @param params  创建签署流程
     * @return Map
     */
    @ResponseBody
    @RequestMapping(value = "/sign/flows/create", method = RequestMethod.POST)
    public JSONObject createSignFlows(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        return signHclcService.createSignFlows(createRequestContext(request), params);
    }


    /**
     * 创建印章
     *
     * @param request
     * @param dto     创建签署流程
     * @return Map
     */
    @ResponseBody
    @RequestMapping(value = "/sign/seal/create", method = RequestMethod.POST)
    public JSONObject createPersonSeal(HttpServletRequest request,
                                      @RequestBody SignUserInfoHclc dto) {
        JSONObject json = new JSONObject();
        String sealId = signHclcService.createTemplateSeals(dto.getAccountId(), dto.getOpenId());
        json.put("sealId", sealId);
        return json;
    }

//    /**
//     * 创建签署流程
//     *
//     * @param request
//     * @param params  创建签署流程
//     * @return Map
//     */
//    @ResponseBody
//    @RequestMapping(value = "/sign/flows/cancel", method = RequestMethod.POST)
//    public JSONObject cancelSignFlows(HttpServletRequest request,
//                                      @RequestBody(required = true) JSONObject params) {
//        return signHclcService.cancelSignFlows(createRequestContext(request), params);
//    }
}
