package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.hap.core.IRequest;
import com.hand.app.appManger.dto.AppRoleModule;
import com.hand.app.appManger.service.IAppRoleModuleService;
import javax.servlet.http.HttpServletRequest;
import com.hand.hap.system.controllers.BaseController;

import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class AppRoleModuleController extends BaseController {
    @Autowired
    private IAppRoleModuleService appRoleModule;

    /**
     * PC端使用 包含未启用的
     * @param request
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/app/query/RoleModule", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryRoleModule(HttpServletRequest request, @RequestParam("roleId") String roleId) {
        return appRoleModule.selectRoleModule(createRequestContext(request),roleId);
    }

    @RequestMapping(value = "/app/queryRoleAllModule", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryRoleAllModule(HttpServletRequest request, @RequestParam("roleId") String roleId) {
        return appRoleModule.selectRoleAllModule(createRequestContext(request),roleId);
    }

    @RequestMapping(value = "/app/addRoleModule", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public ResponseData addRoleModule(HttpServletRequest request, @RequestBody List<AppRoleModule> dto, BindingResult result) {
        getValidator().validate(dto, result);

        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return  new ResponseData(appRoleModule.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/app/deleteRoleModule", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deleteRoleModule(HttpServletRequest request,  @RequestBody List<AppRoleModule> roleModule) {
        return appRoleModule.batchDelete(roleModule);
    }

}
