-- Create table
create sequence NOTIFICATION_TEMPLATE_S;
create table NOTIFICATION_TEMPLATE
(
  TEMPLATE_ID                    NUMBER(38) not null,
  CONTENT               CLOB not null,
  TEMPLATE_NAME            VARCHAR2(255) not null,
  TEMPLATE_CODE               VARCHAR2(255) default null,
  KEY_NAME             VARCHAR2(255) default NULL,
  APP_ID                NUMBER(38) default null,
  TAG_IDS varchar(255) DEFAULT '',
  TEMPLATE_KEY varchar(255) DEFAULT NULL,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table NOTIFICATION_TEMPLATE
  is '微信模板消息模板';
-- Add comments to the columns
comment on column NOTIFICATION_TEMPLATE.CONTENT
  is '模板内容';
comment on column NOTIFICATION_TEMPLATE.TEMPLATE_NAME
  is '模板名称';
comment on column NOTIFICATION_TEMPLATE.TEMPLATE_CODE
  is '模板代号';
comment on column NOTIFICATION_TEMPLATE.KEY_NAME
  is '';
comment on column NOTIFICATION_TEMPLATE.APP_ID
  is '微信应用的account_id';
comment on column NOTIFICATION_TEMPLATE.TAG_IDS
  is '';
comment on column NOTIFICATION_TEMPLATE.TEMPLATE_KEY
  is '微信方的模板id';
-- Create/Recreate primary, unique and foreign key constraints
alter table NOTIFICATION_TEMPLATE
  add primary key (TEMPLATE_ID)
  using index ;
