-- Create table
create sequence ENTERPRISE_APP_DEPARTMENT_S;
create table ENTERPRISE_APP_DEPARTMENT
(
  ID                    NUMBER(38) not null,
  DEPARTMENT_ID         NUMBER(38) not null,
  APP_ID                NUMBER(38) not null,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table ENTERPRISE_APP_DEPARTMENT
  is '企业微信应用与部门对应表';
-- Add comments to the columns
comment on column ENTERPRISE_APP_DEPARTMENT.DEPARTMENT_ID
  is '部门id，与部门表的id对应';
comment on column ENTERPRISE_APP_DEPARTMENT.APP_ID
  is '企业应用id，与企业应用表的id对应';
-- Create/Recreate primary, unique and foreign key constraints
alter table ENTERPRISE_APP_DEPARTMENT
  add constraint ENTERPRISE_APP_DPT_PK primary key (ID)
  using index ;
alter table ENTERPRISE_APP_DEPARTMENT
  add constraint ENTERPRISE_APP_DPT_U1 unique (APP_ID, DEPARTMENT_ID)
  using index ;

-- Create table
create sequence ENTERPRISE_APP_MEMBER_S;
create table ENTERPRISE_APP_MEMBER
(
  ID                    NUMBER(38) not null,
  MEMBER_ID             NUMBER(38) not null,
  APP_ID                NUMBER(38) not null,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table ENTERPRISE_APP_MEMBER
  is '企业微信应用与用户对应表';
-- Add comments to the columns
comment on column ENTERPRISE_APP_MEMBER.MEMBER_ID
  is '用户id，与member表的member_id对应';
comment on column ENTERPRISE_APP_MEMBER.APP_ID
  is '企业应用id，与企业应用表的id对应';
-- Create/Recreate primary, unique and foreign key constraints
alter table ENTERPRISE_APP_MEMBER
  add constraint ENTERPRISE_APP_MB_PK primary key (ID)
  using index;
alter table ENTERPRISE_APP_MEMBER
  add constraint ENTERPRISE_APP_MB_U1 unique (APP_ID, MEMBER_ID)
  using index;

-- Create table
create sequence MP_NEWS_THUMB_PICTURE_S;
create table MP_NEWS_THUMB_PICTURE
(
  ID                    NUMBER(38) not null,
  ORIGINAL_NAME         VARCHAR2(100) not null,
  ACCOUNT_ID            NUMBER(38) not null,
  FILE_NAME             VARCHAR2(100) not null,
  URL                   VARCHAR2(100) not null,
  DESCRIPTION           VARCHAR2(200),
  MEDIAID               VARCHAR2(100),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table MP_NEWS_THUMB_PICTURE
  is '图文消息封面表';
-- Add comments to the columns
comment on column MP_NEWS_THUMB_PICTURE.ORIGINAL_NAME
  is '初始名称';
comment on column MP_NEWS_THUMB_PICTURE.ACCOUNT_ID
  is '公众号id';
comment on column MP_NEWS_THUMB_PICTURE.FILE_NAME
  is '存储文件名';
comment on column MP_NEWS_THUMB_PICTURE.URL
  is '访问url';
comment on column MP_NEWS_THUMB_PICTURE.DESCRIPTION
  is '描述';
comment on column MP_NEWS_THUMB_PICTURE.MEDIAID
  is '微信返回的mediaId';
-- Create/Recreate primary, unique and foreign key constraints
alter table MP_NEWS_THUMB_PICTURE
  add constraint MP_NEWS_THUMB_PIC_PK primary key (ID)
  using index ;



-- Create table
create sequence SUB_BUTTON_S;
create table SUB_BUTTON
(
  BUTTON_ID             NUMBER(38) not null,
  NAME                  VARCHAR2(255) not null,
  BUTTON_TYPE           VARCHAR2(255),
  PARENT_ID             NUMBER(38),
  URL                   VARCHAR2(255),
  WECHAT_ID             NUMBER(38),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1,
  ATTRIBUTE_CATEGORY    VARCHAR2(30),
  ATTRIBUTE1            VARCHAR2(240),
  ATTRIBUTE2            VARCHAR2(240),
  ATTRIBUTE3            VARCHAR2(240),
  ATTRIBUTE4            VARCHAR2(240),
  ATTRIBUTE5            VARCHAR2(240),
  ATTRIBUTE6            VARCHAR2(240),
  ATTRIBUTE7            VARCHAR2(240),
  ATTRIBUTE8            VARCHAR2(240),
  ATTRIBUTE9            VARCHAR2(240),
  ATTRIBUTE10           VARCHAR2(240),
  ATTRIBUTE11           VARCHAR2(240),
  ATTRIBUTE12           VARCHAR2(240),
  ATTRIBUTE13           VARCHAR2(240),
  ATTRIBUTE14           VARCHAR2(240),
  ATTRIBUTE15           VARCHAR2(240)
);
-- Add comments to the columns
comment on column SUB_BUTTON.BUTTON_ID
  is '菜单id';
comment on column SUB_BUTTON.NAME
  is '菜单名称';
comment on column SUB_BUTTON.BUTTON_TYPE
  is '菜单类型';
comment on column SUB_BUTTON.PARENT_ID
  is '父级菜单id';
comment on column SUB_BUTTON.URL
  is '跳转url';
comment on column SUB_BUTTON.WECHAT_ID
  is '公众号id';
-- Create/Recreate primary, unique and foreign key constraints
alter table SUB_BUTTON
  add constraint SUB_BUTTON_PK primary key (BUTTON_ID)
  using index ;



-- Create table
create sequence WECHAT_MATERIAL_S;
create table WECHAT_MATERIAL
(
  MATERIAL_ID           NUMBER(38) not null,
  ACCOUNT_ID            NUMBER(38) not null,
  TYPE                  VARCHAR2(100),
  MEDIA_TYPE            VARCHAR2(100),
  CREATED_AT            NUMBER(38),
  VALID_AT              NUMBER(38),
  DIRECTORY             VARCHAR2(100),
  CONTENT_SOURCE_URL    VARCHAR2(200),
  REMOTE_URL            VARCHAR2(200),
  CONTENT               VARCHAR2(2000),
  SHOW_COVER_PIC        NUMBER(10),
  MEDIA_ID              VARCHAR2(100),
  DESCRIPTION           VARCHAR2(2000),
  TITLE                 VARCHAR2(200),
  AUTHOR                VARCHAR2(200),
  DIGEST                VARCHAR2(200),
  MATERIAL_DESC         VARCHAR2(1000),
  THUMB_MEDIA_ID        VARCHAR2(100),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table WECHAT_MATERIAL
  is '素材表';
-- Add comments to the columns
comment on column WECHAT_MATERIAL.ACCOUNT_ID
  is '公众号id';
comment on column WECHAT_MATERIAL.TYPE
  is '素材类型，临时或永久(TEMP or PERM)';
comment on column WECHAT_MATERIAL.MEDIA_TYPE
  is '素材媒体文件类型,image,voice,video,file,thumb';
comment on column WECHAT_MATERIAL.CREATED_AT
  is '微信后台创建时间戳';
comment on column WECHAT_MATERIAL.VALID_AT
  is '有效截止时间戳';
comment on column WECHAT_MATERIAL.DIRECTORY
  is '文件存储目录';
comment on column WECHAT_MATERIAL.CONTENT_SOURCE_URL
  is '图文消息的原文链接';
comment on column WECHAT_MATERIAL.REMOTE_URL
  is '图文页或者视频素材的url';
comment on column WECHAT_MATERIAL.CONTENT
  is '图文消息内容的html';
comment on column WECHAT_MATERIAL.SHOW_COVER_PIC
  is '图文消息是否显示封面';
comment on column WECHAT_MATERIAL.MEDIA_ID
  is '微信后台返回的media_id';
comment on column WECHAT_MATERIAL.DESCRIPTION
  is '视频素材的描述';
comment on column WECHAT_MATERIAL.TITLE
  is '视频或图文消息的标题';
comment on column WECHAT_MATERIAL.AUTHOR
  is '作者';
comment on column WECHAT_MATERIAL.DIGEST
  is '摘要';
comment on column WECHAT_MATERIAL.MATERIAL_DESC
  is '素材描述';
comment on column WECHAT_MATERIAL.THUMB_MEDIA_ID
  is '图文笑死的封面图片素材id(必须是永久素材的media_id)';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_MATERIAL
  add constraint WECHAT_MATERIAL_PK primary key (MATERIAL_ID)
  using index ;
-- Create/Recreate indexes
create index WECHAT_MATERIAL_N1 on WECHAT_MATERIAL (ACCOUNT_ID);


-- Create table
create sequence WECHAT_ACCOUNT_S;
create table WECHAT_ACCOUNT
(
  ACCOUNT_ID            NUMBER(38) not null,
  ACCOUNT_CODE          VARCHAR2(100) not null,
  NAME                  VARCHAR2(100),
  COMPANY_NAME          VARCHAR2(100),
  APP_ID                VARCHAR2(100),
  SECRET                VARCHAR2(200),
  ACCOUNT_TYPE          NUMBER(10) not null,
  IS_ENABLE             VARCHAR2(1) default 'Y',
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table WECHAT_ACCOUNT
  is '微信公众号表，包括企业号、订阅号、服务号';
-- Add comments to the columns
comment on column WECHAT_ACCOUNT.ACCOUNT_CODE
  is '公众号编号';
comment on column WECHAT_ACCOUNT.NAME
  is '公众号名称';
comment on column WECHAT_ACCOUNT.COMPANY_NAME
  is '企业号公司名称';
comment on column WECHAT_ACCOUNT.APP_ID
  is '订阅号与服务号的appId';
comment on column WECHAT_ACCOUNT.SECRET
  is '订阅号与服务号的secret,企业号通讯录的corpsecret';
comment on column WECHAT_ACCOUNT.ACCOUNT_TYPE
  is '公众号类型，1表示企业号、2表示订阅号、3表示服务号';
comment on column WECHAT_ACCOUNT.IS_ENABLE
  is '是否启用';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_ACCOUNT
  add constraint WECHAT_ACCOUNT_PK primary key (ACCOUNT_ID)
  using index ;
alter table WECHAT_ACCOUNT
  add constraint WECHAT_ACCOUNT_U1 unique (ACCOUNT_CODE)
  using index ;
alter table WECHAT_ACCOUNT
  add constraint WECHAT_ACCOUNT_U2 unique (APP_ID)
  using index ;



-- Create table
create sequence WECHAT_DEPARTMENT_S;
create table WECHAT_DEPARTMENT
(
  ID                    NUMBER(38) not null,
  DEPARTMENT_ID         NUMBER(38) not null,
  DEPARTMENT_NAME       VARCHAR2(255),
  PARENT_ID              NUMBER(38) not null,
  ACCOUNT_ID            NUMBER(38) not null,
  DEPARTMENT_ORDER      NUMBER(38) not null,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1,
  ATTRIBUTE_CATEGORY    VARCHAR2(30),
  ATTRIBUTE1            VARCHAR2(240),
  ATTRIBUTE2            VARCHAR2(240),
  ATTRIBUTE3            VARCHAR2(240),
  ATTRIBUTE4            VARCHAR2(240),
  ATTRIBUTE5            VARCHAR2(240),
  ATTRIBUTE6            VARCHAR2(240),
  ATTRIBUTE7            VARCHAR2(240),
  ATTRIBUTE8            VARCHAR2(240),
  ATTRIBUTE9            VARCHAR2(240),
  ATTRIBUTE10           VARCHAR2(240),
  ATTRIBUTE11           VARCHAR2(240),
  ATTRIBUTE12           VARCHAR2(240),
  ATTRIBUTE13           VARCHAR2(240),
  ATTRIBUTE14           VARCHAR2(240),
  ATTRIBUTE15           VARCHAR2(240)
);
-- Add comments to the columns
comment on column WECHAT_DEPARTMENT.ID
  is '部门id';
comment on column WECHAT_DEPARTMENT.DEPARTMENT_ID
  is '部门id';
comment on column WECHAT_DEPARTMENT.DEPARTMENT_NAME
  is '部门名称';
comment on column WECHAT_DEPARTMENT.PARENT_ID
  is '父级部门id';
comment on column WECHAT_DEPARTMENT.ACCOUNT_ID
  is '企业号id';
comment on column WECHAT_DEPARTMENT.DEPARTMENT_ORDER
  is '在父部门中的次序';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_DEPARTMENT
  add constraint WECHAT_DEPARTMENT_PK primary key (ID)
  using index ;
alter table WECHAT_DEPARTMENT
  add constraint WECHAT_DEPARTMENT_U1 unique (DEPARTMENT_ID, ACCOUNT_ID)
  using index ;


-- Create table
create sequence WECHAT_ENTERPRISE_APP_S;
create table WECHAT_ENTERPRISE_APP
(
  ID                    NUMBER(38) not null,
  WX_CODE               VARCHAR2(100) not null,
  ACCOUNT_ID            NUMBER(38) not null,
  CORP_ID               VARCHAR2(100) not null,
  IS_ENABLE             VARCHAR2(1) default 'Y',
  SECRET                VARCHAR2(200) not null,
  NAME                  VARCHAR2(100) not null,
  AGENT_ID              VARCHAR2(100),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1,
  WECHAT_ID             VARCHAR2(100)
);
-- Add comments to the table
comment on table WECHAT_ENTERPRISE_APP
  is '企业号应用表';
-- Add comments to the columns
comment on column WECHAT_ENTERPRISE_APP.ID
  is 'id';
comment on column WECHAT_ENTERPRISE_APP.WX_CODE
  is '应用编号';
comment on column WECHAT_ENTERPRISE_APP.ACCOUNT_ID
  is '企业号id';
comment on column WECHAT_ENTERPRISE_APP.CORP_ID
  is '企业号的corpId';
comment on column WECHAT_ENTERPRISE_APP.IS_ENABLE
  is '是否启用';
comment on column WECHAT_ENTERPRISE_APP.SECRET
  is 'secret';
comment on column WECHAT_ENTERPRISE_APP.NAME
  is '应用名称';
comment on column WECHAT_ENTERPRISE_APP.AGENT_ID
  is '企业号应用内的agentId';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_ENTERPRISE_APP
  add constraint WECHAT_ENTERPRISE_APP_PK primary key (ID)
  using index ;
alter table WECHAT_ENTERPRISE_APP
  add constraint ENTERPRISE_APP_U1 unique (WX_CODE)
  using index ;
-- Create/Recreate indexes
create index WECHAT_ENTERPRISE_APP_N1 on WECHAT_ENTERPRISE_APP (CORP_ID);



-- Create table
CREATE sequence MEMBER_ADDITIONAL_INFO_S;
create table MEMBER_ADDITIONAL_INFO
(
  ID                    NUMBER(38) not null,
  MEMBER_ID             NUMBER(38) not null,
  MOBILE                VARCHAR2(100),
  EMAIL                 VARCHAR2(100),
  POSITION              VARCHAR2(100),
  ISLEADER              NUMBER(10),
  HIDE_MOBILE           NUMBER(10),
  TELEPHONE             VARCHAR2(100),
  ENGLISH_NAME          VARCHAR2(100),
  EXTATTR               VARCHAR2(100),
  NICKNAME              VARCHAR2(100),
  CITY                  VARCHAR2(100),
  COUNTRY               VARCHAR2(100),
  PROVINCE              VARCHAR2(100),
  LANGUAGE              VARCHAR2(100),
  REMARK                VARCHAR2(100),
  GROUPID               NUMBER(38),
  SUBSCRIBE_TIME        NUMBER(38),
  UNION_ID              VARCHAR2(100),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table MEMBER_ADDITIONAL_INFO
  is '用户附加信息表';
-- Add comments to the columns
comment on column MEMBER_ADDITIONAL_INFO.MEMBER_ID
  is '成员表中的主键id';
comment on column MEMBER_ADDITIONAL_INFO.MOBILE
  is '手机号';
comment on column MEMBER_ADDITIONAL_INFO.EMAIL
  is '邮箱';
comment on column MEMBER_ADDITIONAL_INFO.POSITION
  is '职位';
comment on column MEMBER_ADDITIONAL_INFO.ISLEADER
  is '是否上级';
comment on column MEMBER_ADDITIONAL_INFO.TELEPHONE
  is '电话号码';
comment on column MEMBER_ADDITIONAL_INFO.ENGLISH_NAME
  is '英文名';
comment on column MEMBER_ADDITIONAL_INFO.EXTATTR
  is '扩展属性';
comment on column MEMBER_ADDITIONAL_INFO.NICKNAME
  is '昵称';
comment on column MEMBER_ADDITIONAL_INFO.CITY
  is '城市';
comment on column MEMBER_ADDITIONAL_INFO.COUNTRY
  is '国家';
comment on column MEMBER_ADDITIONAL_INFO.PROVINCE
  is '省';
comment on column MEMBER_ADDITIONAL_INFO.LANGUAGE
  is '语言';
comment on column MEMBER_ADDITIONAL_INFO.REMARK
  is '备注';
comment on column MEMBER_ADDITIONAL_INFO.GROUPID
  is '用户所在的分组ID（兼容旧的用户分组接口）';
comment on column MEMBER_ADDITIONAL_INFO.SUBSCRIBE_TIME
  is '关注时间戳';
comment on column MEMBER_ADDITIONAL_INFO.UNION_ID
  is '只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段';
-- Create/Recreate primary, unique and foreign key constraints
alter table MEMBER_ADDITIONAL_INFO
  add constraint MEMBER_ADT_INFO_PK primary key (ID)
  using index ;
alter table MEMBER_ADDITIONAL_INFO
  add constraint WECHAT_MEMBER_ADT_INFO_U1 unique (MEMBER_ID)
  using index ;


-- Create table
create sequence WECHAT_MEMBER_DEPARTMENT_S;
create table WECHAT_MEMBER_DEPARTMENT
(
  ID                    NUMBER(38) not null,
  MEMBER_ID             NUMBER(38) not null,
  DEPARTMENT_ID         NUMBER(38) not null,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table WECHAT_MEMBER_DEPARTMENT
  is '通讯录成员、部门对应表';
-- Add comments to the columns
comment on column WECHAT_MEMBER_DEPARTMENT.MEMBER_ID
  is '成员id,与成员表member_id对应';
comment on column WECHAT_MEMBER_DEPARTMENT.DEPARTMENT_ID
  is '部门id,与部门表的id对应';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_MEMBER_DEPARTMENT
  add constraint WECHAT_MEMBER_DEPARTMENT_PK primary key (ID)
  using index ;
alter table WECHAT_MEMBER_DEPARTMENT
  add constraint WECHAT_MEMBER_DEPARTMENT_U1 unique (MEMBER_ID, DEPARTMENT_ID)
  using index ;


-- Create table
create sequence WECHAT_MEMBER_S;
create table WECHAT_MEMBER
(
  MEMBER_ID             NUMBER(38) not null,
  NAME                  VARCHAR2(500) not null,
  ACCOUNT_ID            NUMBER(38) not null,
  MEMBER_ORDER          NUMBER(38),
  STATUS                NUMBER(10),
  ENABLE                NUMBER(10),
  OPEN_ID               VARCHAR2(100),
  USER_ID               VARCHAR2(100),
  AVATAR                VARCHAR2(200),
  GENDER                VARCHAR2(100),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table WECHAT_MEMBER
  is '通讯录成员表，包括订阅号和服务号的粉丝';
-- Add comments to the columns
comment on column WECHAT_MEMBER.NAME
  is '成员名称';
comment on column WECHAT_MEMBER.ACCOUNT_ID
  is '公众号ID';
comment on column WECHAT_MEMBER.MEMBER_ORDER
  is '排序';
comment on column WECHAT_MEMBER.STATUS
  is '激活状态';
comment on column WECHAT_MEMBER.ENABLE
  is '启用状态';
comment on column WECHAT_MEMBER.OPEN_ID
  is '用户唯一性标识';
comment on column WECHAT_MEMBER.USER_ID
  is '成员id';
comment on column WECHAT_MEMBER.AVATAR
  is '头像url';
comment on column WECHAT_MEMBER.GENDER
  is '性别';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_MEMBER
  add constraint WECHAT_MEMBER_PK primary key (MEMBER_ID)
  using index ;


-- Create table
create sequence WECHAT_MEMBER_TAG_S;
create table WECHAT_MEMBER_TAG
(
  ID                    NUMBER(38) not null,
  MEMBER_ID             NUMBER(38) not null,
  TAG_ID                NUMBER(38) not null,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table WECHAT_MEMBER_TAG
  is '通讯录成员、标签对应表';
-- Add comments to the columns
comment on column WECHAT_MEMBER_TAG.MEMBER_ID
  is '成员id,与成员表member_id对应';
comment on column WECHAT_MEMBER_TAG.TAG_ID
  is '部门id,与标签表的id对应';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_MEMBER_TAG
  add constraint WECHAT_MEMBER_TAG_PK primary key (ID)
  using index ;
alter table WECHAT_MEMBER_TAG
  add constraint WECHAT_MEMBER_TAG_U1 unique (MEMBER_ID, TAG_ID)
  using index ;


-- Create table
create sequence WECHAT_MENU_S;
create table WECHAT_MENU
(
  ID                    NUMBER(38) not null,
  WECHAT_ACCOUNT_ID     NUMBER(38) not null,
  PARENT_MENU_ID        NUMBER(38),
  STATE                 NUMBER(10),
  NAME                  VARCHAR2(100),
  TYPE                  VARCHAR2(100),
  MENU_KEY              VARCHAR2(500),
  URL                   VARCHAR2(500),
  SEQ                   NUMBER(10),
  IS_PUBLISHED          VARCHAR2(10),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1,
  REDIRECT_URI          VARCHAR2(500),
  SCOPE                 VARCHAR2(100)
);
-- Add comments to the columns
comment on column WECHAT_MENU.ID
  is 'id';
comment on column WECHAT_MENU.WECHAT_ACCOUNT_ID
  is '微信公众号或者应用id';
comment on column WECHAT_MENU.PARENT_MENU_ID
  is '父菜单的id';
comment on column WECHAT_MENU.STATE
  is '菜单的state标识';
comment on column WECHAT_MENU.NAME
  is '菜单名称';
comment on column WECHAT_MENU.TYPE
  is '菜单内容类型';
comment on column WECHAT_MENU.MENU_KEY
  is '菜单按钮对应的key';
comment on column WECHAT_MENU.URL
  is '菜单按钮对应的url';
comment on column WECHAT_MENU.SEQ
  is '菜单序号';
comment on column WECHAT_MENU.IS_PUBLISHED
  is '是否发布';
comment on column WECHAT_MENU.REDIRECT_URI
  is '重定向uri';
comment on column WECHAT_MENU.SCOPE
  is '微信权限认证域';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_MENU
  add constraint WECHAT_MENU_PK primary key (ID)
  using index ;



-- Create table
create sequence WECHAT_SUNECM_DATA_S;
create table WECHAT_SUNECM_DATA
(
  SUN_ECM_ID            NUMBER(38) not null,
  BATCH_ID              VARCHAR2(500),
  CONTRACT_NUM          VARCHAR2(200),
  QUERY_TIME            VARCHAR2(50),
  FILE_NAME             VARCHAR2(200),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_SUNECM_DATA
  add constraint SUN_ECM_ID_PK primary key (SUN_ECM_ID)
  using index ;



-- Create table
create sequence WECHAT_TAG_S;
create table WECHAT_TAG
(
  ID                    NUMBER(38) not null,
  TAG_ID                VARCHAR2(200) not null,
  TAG_NAME              VARCHAR2(255),
  ACCOUNT_ID            NUMBER(38) not null,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table WECHAT_TAG
  is '用户标签表';
-- Add comments to the columns
comment on column WECHAT_TAG.TAG_ID
  is '标签id';
comment on column WECHAT_TAG.TAG_NAME
  is '标签名称';
comment on column WECHAT_TAG.ACCOUNT_ID
  is '公众号id';
-- Create/Recreate primary, unique and foreign key constraints
alter table WECHAT_TAG
  add constraint WECHAT_TAG_PK primary key (ID)
  using index ;
alter table WECHAT_TAG
  add constraint WECHAT_TAG_U1 unique (TAG_ID, ACCOUNT_ID)
  using index ;


-- Create table
create sequence WX_AUTO_RECOVER_S;
create table WX_AUTO_RECOVER
(
  WX_RECOVER_ID         NUMBER(38) not null,
  SEQ                   NUMBER(38),
  CONTENT               VARCHAR2(2000) not null,
  RE_CONTENT            CLOB not null,
  USABLE                VARCHAR2(200),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1,
  CONTENT_URL           VARCHAR2(200),
  DESCRIPTION           VARCHAR2(500),
  TITLE                 VARCHAR2(500),
  PIC_URL               VARCHAR2(500)
);

-- Create/Recreate primary, unique and foreign key constraints
alter table WX_AUTO_RECOVER
  add constraint WX_AUTO_RECOVER_PK primary key (WX_RECOVER_ID)
  using index ;



-- Create table
create sequence  RESPONSE_MESSAGE_S;
create table RESPONSE_MESSAGE
(
  ID                    NUMBER(38) not null,
  WECHAT_APP_ID         NUMBER(38),
  MSG_TYPE              VARCHAR2(30) not null,
  CONTENT               CLOB,
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the table
comment on table RESPONSE_MESSAGE
  is '微信回复消息/欢迎消息表';
-- Add comments to the columns
comment on column RESPONSE_MESSAGE.WECHAT_APP_ID
  is '微信应用Id';
comment on column RESPONSE_MESSAGE.MSG_TYPE
  is '微信消息类型';
comment on column RESPONSE_MESSAGE.CONTENT
  is '文本消息内容';
-- Create/Recreate primary, unique and foreign key constraints
alter table RESPONSE_MESSAGE
  add primary key (ID)
  using index ;

