drop table IF EXISTS ENTERPRISE_APP_DEPARTMENT;
create table enterprise_app_department(
	id BIGINT (20) NOT NULL auto_increment,
	department_id BIGINT (20) NOT NULL  COMMENT '部门id，与部门表的id对应',
	app_id BIGINT (20) NOT NULL  COMMENT '企业应用id，与企业应用表的id对应',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id),
	UNIQUE KEY `ENTERPRISE_APP_DPT_U1`(`APP_ID`, `DEPARTMENT_ID`)
) COMMENT = '企业微信应用与部门对应表';


drop table IF EXISTS ENTERPRISE_APP_MEMBER;
create table ENTERPRISE_APP_MEMBER(
	id BIGINT (20) NOT NULL auto_increment,
	member_id BIGINT (20) NOT NULL COMMENT '用户id，与member表的member_id对应',
	app_id BIGINT (20) NOT NULL COMMENT '企业应用id，与企业应用表的id对应',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id),
	UNIQUE KEY `ENTERPRISE_APP_MB_U1`(`APP_ID`, `MEMBER_ID`)
) COMMENT = '企业微信应用与用户对应表';

drop table IF EXISTS MP_NEWS_THUMB_PICTURE;
create table mp_news_thumb_picture(
	id BIGINT (20) NOT NULL auto_increment,
	original_name varchar(100) COMMENT  '初始名称',
	account_id BIGINT (20) COMMENT '公众号id',
	file_name  varchar(100) COMMENT '存储文件名',
	url  varchar(100) COMMENT '访问url',
	description varchar(100) COMMENT '描述',
	mediaid varchar(100) COMMENT '微信返回的mediaId',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id)
) COMMENT = '图文消息封面表';

drop table IF EXISTS SUB_BUTTON;
create table sub_button(
	button_id BIGINT (20) NOT NULL auto_increment COMMENT '菜单id',
	name varchar(255) COMMENT '菜单名称',
	button_type varchar(255) COMMENT '菜单类型',
	parent_id  BIGINT (20) COMMENT '父级菜单id',
	url  varchar(255) COMMENT '跳转url',
	wechat_id BIGINT (20) COMMENT '公众号id',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	attribute_category varchar(30),
	attribute1	varchar(240),
	attribute2	varchar(240),
	attribute3	varchar(240),
	attribute4	varchar(240),
	attribute5	varchar(240),
	attribute6	varchar(240),
	attribute7	varchar(240),
	attribute8	varchar(240),
	attribute9	varchar(240),
	attribute10	varchar(240),
	attribute12	varchar(240),
	attribute13	varchar(240),
	attribute14	varchar(240),
	attribute15	varchar(240),
	attribute16	varchar(240),
	attribute17	varchar(240),
	attribute18	varchar(240),
	attribute19	varchar(240),
	PRIMARY KEY (button_id)
);

drop table IF EXISTS WECHAT_MATERIAL;
create table WECHAT_MATERIAL(
	material_id BIGINT (20) NOT NULL auto_increment,
	account_id BIGINT (20) COMMENT '公众号id',
	type varchar(100) COMMENT '素材类型，临时或永久(TEMP or PERM)',
	media_type  varchar(100) COMMENT '素材媒体文件类型,image,voice,video,file,thumb',
	created_at  BIGINT (20) COMMENT '微信后台创建时间戳',
	valid_at BIGINT (20) COMMENT '有效截止时间戳',
	directory varchar(100) COMMENT '文件存储目录',
	content_source_url varchar(200) COMMENT '图文消息的原文链接',
	remote_url varchar(200) COMMENT '图文页或者视频素材的url',
	content	 varchar(2000) COMMENT '图文消息内容的html',
	show_cover_pic BIGINT (10) COMMENT '图文消息是否显示封面',
	media_id varchar(100) COMMENT '微信后台返回的media_id',
	description varchar(2000) COMMENT '视频素材的描述',
	title	varchar(200) COMMENT '视频或图文消息的标题',
	author varchar(200) COMMENT '作者',
	digest varchar(200) COMMENT '摘要',
	material_desc varchar(1000) COMMENT '素材描述',
	thumb_media_id varchar(100),
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (material_id),
	KEY `WECHAT_MATERIAL_N1`(`ACCOUNT_ID`)
) COMMENT = '素材表';

drop table IF EXISTS WECHAT_ACCOUNT;
create table wechat_account(
	account_id BIGINT (20) NOT NULL auto_increment,
	account_code varchar(100) NOT NULL COMMENT '公众号编号',
	name varchar(100) COMMENT '公众号名称',
	company_name  varchar(100) COMMENT '企业号公司名称',
	app_id  varchar(100) NOT NULL COMMENT '订阅号与服务号的appId',
	secret varchar(200) COMMENT '订阅号与服务号的secret,企业号通讯录的corpsecret',
	account_type BIGINT(10) COMMENT '公众号类型，1表示企业号、2表示订阅号、3表示服务号',
	is_enable varchar(1) COMMENT '是否启用',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (account_id),
	UNIQUE KEY `WECHAT_ACCOUNT_U1`(`ACCOUNT_CODE`),
	UNIQUE KEY `WECHAT_ACCOUNT_U2`(`APP_ID`)
) COMMENT = '微信公众号表，包括企业号、订阅号、服务号';

drop table IF EXISTS WECHAT_DEPARTMENT;
create table wechat_department(
	id BIGINT (20) NOT NULL auto_increment,
	department_id BIGINT (20) NOT NULL COMMENT '部门id',
	department_name varchar(255) COMMENT '部门名称',
	parent_id  BIGINT (20) COMMENT '父级部门id',
	account_id  BIGINT (20) NOT NULL COMMENT '企业号id',
	department_order BIGINT (20) COMMENT '在父部门中的次序',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	attribute_category varchar(30),
	attribute1	varchar(240),
	attribute2	varchar(240),
	attribute3	varchar(240),
	attribute4	varchar(240),
	attribute5	varchar(240),
	attribute6	varchar(240),
	attribute7	varchar(240),
	attribute8	varchar(240),
	attribute9	varchar(240),
	attribute10	varchar(240),
	attribute12	varchar(240),
	attribute13	varchar(240),
	attribute14	varchar(240),
	attribute15	varchar(240),
	attribute16	varchar(240),
	attribute17	varchar(240),
	attribute18	varchar(240),
	attribute19	varchar(240),
	PRIMARY KEY (id),
	UNIQUE KEY `WECHAT_DEPARTMENT_U1`(`DEPARTMENT_ID`,`ACCOUNT_ID`)
);

drop table IF EXISTS wechat_enterprise_app;
create table wechat_enterprise_app(
	id BIGINT (20) NOT NULL auto_increment,
	wx_code varchar(100) NOT NULL COMMENT '应用编号',
	account_id  BIGINT (20) COMMENT '企业号id',
	corp_id varchar(100) COMMENT '企业号的corpId',
	is_enable varchar(1) COMMENT '是否启用',
	secret varchar(200) COMMENT 'secret',
	name varchar(100) COMMENT '应用名称',
	agent_id varchar(100) COMMENT '企业号应用内的agentId',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	wechat_id varchar(100),
	PRIMARY KEY (id),
	UNIQUE KEY `WECHAT_ENTERPRISE_APP_N1`(`CORP_ID`),
	KEY `ENTERPRISE_APP_U1`(`WX_CODE`)
) COMMENT = '企业号应用表';

drop table IF EXISTS MEMBER_ADDITIONAL_INFO;
create table member_additional_info(
	id BIGINT (20) NOT NULL auto_increment,
	member_id BIGINT (20) NOT NULL COMMENT '成员表中的主键id',
	mobile  varchar(100) COMMENT '手机号',
	email varchar(100) COMMENT '邮箱',
	position varchar(100) COMMENT '职位',
	isleader BIGINT (10) COMMENT '是否上级',
	hide_mobile BIGINT (10),
	telephone varchar(100) COMMENT '电话号码',
	english_name varchar(100) COMMENT '英文名',
	extattr 	varchar(100) COMMENT '扩展属性',
	nickname	varchar(100) COMMENT '昵称',
	city varchar(100) COMMENT '城市',
	country varchar(100) COMMENT '国家',
	province varchar(100) COMMENT '省',
	language varchar(100) COMMENT '语言',
	remark varchar(100) COMMENT '备注',
	groupid BIGINT (20) COMMENT '用户所在的分组ID（兼容旧的用户分组接口）',
	subscribe_time BIGINT (20) COMMENT '关注时间戳',
	union_id varchar(100) COMMENT '只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id),
	UNIQUE KEY `WECHAT_MEMBER_ADT_INFO_U1`(`MEMBER_ID`)
) COMMENT = '用户附加信息表';

drop table IF EXISTS WECHAT_MEMBER_DEPARTMENT;
create table wechat_member_department(
	id BIGINT (20) NOT NULL auto_increment,
	member_id BIGINT (20) NOT NULL COMMENT '成员id,与成员表member_id对应',
	department_id  BIGINT (20) NOT NULL COMMENT '部门id,与部门表的id对应',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id),
	UNIQUE KEY `WECHAT_MEMBER_DEPARTMENT_U1`(`MEMBER_ID`,`DEPARTMENT_ID`)
) COMMENT = '通讯录成员、部门对应表';

drop table IF EXISTS WECHAT_MEMBER;
create table wechat_member(
	member_id BIGINT (20) NOT NULL auto_increment,
	name varchar (500) COMMENT '成员名称',
	account_id  BIGINT (20) COMMENT '公众号ID',
	member_order BIGINT (20) COMMENT '排序',
	status BIGINT (10) COMMENT '激活状态',
	enable BIGINT (10) COMMENT '启用状态',
	open_id	 varchar (100) COMMENT '用户唯一性标识',
	user_id 	varchar (100) COMMENT '成员id',
	avatar varchar (200) COMMENT '头像url',
	gender varchar (100) COMMENT '性别',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (member_id)
) COMMENT = '通讯录成员表，包括订阅号和服务号的粉丝';

drop table IF EXISTS WECHAT_MEMBER_TAG;
create table wechat_member_tag(
	id BIGINT (20) NOT NULL auto_increment,
	member_id BIGINT (20) NOT NULL COMMENT '成员id,与成员表member_id对应',
	tag_id  BIGINT (20) NOT NULL COMMENT '部门id,与标签表的id对应',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id),
	UNIQUE KEY `WECHAT_MEMBER_TAG_U1`(`MEMBER_ID`,`TAG_ID`)
) COMMENT = '通讯录成员、标签对应表';

drop table IF EXISTS WECHAT_MENU;
create table wechat_menu(
	id BIGINT (20) NOT NULL auto_increment,
	wechat_account_id BIGINT (20) COMMENT '微信公众号或者应用id',
	parent_menu_id  BIGINT (20) COMMENT '父菜单的id',
	state BIGINT (10) COMMENT '菜单的state标识',
	name varchar(100) COMMENT '菜单名称',
	type varchar(100) COMMENT '菜单内容类型',
	menu_key varchar(500) COMMENT '菜单按钮对应的key',
	url varchar(500) COMMENT '菜单按钮对应的url',
	seq BIGINT (10) COMMENT '菜单序号',
	is_published	varchar(10) COMMENT '是否发布',
	object_version_number BIGINT(20) ,
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	redirect_uri	varchar(500) COMMENT '重定向uri',
	scope varchar(100) COMMENT '微信权限认证域',
	PRIMARY KEY (id)
);

drop table IF EXISTS WECHAT_SUNECM_DATA;
create table WECHAT_SUNECM_DATA(
	sun_ecm_id BIGINT (20) NOT NULL auto_increment,
	batch_id varchar (500),
	contract_num  varchar (200),
	query_time varchar (50),
	file_name varchar(200),
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (sun_ecm_id)
);

drop table IF EXISTS WECHAT_TAG;
create table wechat_tag(
	id BIGINT (20) NOT NULL auto_increment,
	tag_id varchar (200) NOT NULL COMMENT '标签id',
	tag_name  varchar (255) COMMENT '标签名称',
	account_id BIGINT (20) NOT NULL COMMENT '公众号id',
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	PRIMARY KEY (id),
	UNIQUE KEY `WECHAT_TAG_U1`(`TAG_ID`,`ACCOUNT_ID`)
) COMMENT = '用户标签表';

drop table IF EXISTS WX_AUTO_RECOVER;
create table wx_auto_recover(
	wx_recover_id BIGINT (20) NOT NULL auto_increment,
	seq BIGINT (20),
	content  varchar (2000),
	re_content longtext,
	usable	varchar (2000),
	object_version_number BIGINT(20),
	request_id BIGINT(20),
	program_id BIGINT(20),
	created_by BIGINT(20),
	creation_date datetime,
	last_updated_by BIGINT(20),
	last_update_date datetime,
	last_update_login BIGINT(20),
	content_url	varchar (200),
	description	varchar (500),
	title	varchar (500),
	pic_url	varchar (500),
	PRIMARY KEY (wx_recover_id)
);

drop table IF EXISTS RESPONSE_MESSAGE;
CREATE TABLE `response_message` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `wechat_app_id` bigint(20) DEFAULT NULL COMMENT '微信应用Id',
  `msg_type` varchar(30) NOT NULL COMMENT '微信消息类型',
  `content` varchar(255) COMMENT '文本消息内容',
  `object_version_number` bigint(38) DEFAULT '1',
  `request_id` bigint(20) DEFAULT '-1',
  `program_id` bigint(20) DEFAULT '-1',
  `created_by` bigint(20) DEFAULT '-1',
  `creation_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `last_updated_by` bigint(20) DEFAULT '-1',
  `last_update_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `last_update_login` bigint(20) DEFAULT '-1',
  PRIMARY KEY (`id`)
) COMMENT = '微信回复消息/欢迎消息表';
