
package com.hand.hap.core.web.view.ui;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.hand.hap.core.web.view.XMap;

@JsonInclude(Include.NON_NULL)
public class ItemsMethod {
    private String name;
    private String map;
    private String defaultMessage;
    private String description;
    private String click;
    private String img;
    private String color;
    private String imgId;
    private String textId;
    private String message;
    private String iconColor;
    private String id;

    private static final String PROPERTITY_NAME = "name";
    private static final String PROPERTITY_MAP = "map";
    private static final String PROPERTITY_DEFAULTMESSAGE = "defaultMessage";
    private static final String PROPERTITY_DESCRIPTION = "description";
    private static final String PROPERTITY_CLICK = "click";
    private static final String PROPERTITY_IMG = "img";
    private static final String PROPERTITY_COLOR = "color";
    private static final String PROPERTITY_IMGID= "imgId";
    private static final String PROPERTITY_TEXTID = "textId";
    private static final String PROPERTITY_MESSAGE = "message";
    private static final String PROPERTITY_ICONCOLOR = "iconColor";
    private static final String PROPERTITY_ID = "id";

    public ItemsMethod() {
    }

    public static ItemsMethod parse(XMap view) {
        ItemsMethod itemsMethod = new ItemsMethod();
        if(view != null) {
            itemsMethod.setName(view.getString("name"));
            itemsMethod.setMap(view.getString("map"));
            itemsMethod.setDefaultMessage(view.getString("defaultMessage"));
            itemsMethod.setDescription(view.getString("description"));
            itemsMethod.setClick(view.getString("click"));
            itemsMethod.setImg(view.getString("img"));
            itemsMethod.setColor(view.getString("color"));
            itemsMethod.setImgId(view.getString("imgId"));
            itemsMethod.setTextId(view.getString("textId"));
            itemsMethod.setMessage(view.getString("message"));
            itemsMethod.setIconColor(view.getString("iconColor"));
            itemsMethod.setId(view.getString("id"));
            return itemsMethod;
        } else {
            return null;
        }
    }

    public XMap toXMap(String name) {
        XMap map = new XMap("h", "http://www.hand-china.com/hap", name);
        map.put("name", this.getName());
        map.put("map", this.getMap());
        map.put("defaultName", this.getDefaultMessage());
        map.put("description", this.getDescription());
        map.put("click", this.getClick());
        map.put("img", this.getImg());
        map.put("color", this.getColor());
        map.put("imgId", this.getImgId());
        map.put("textId", this.getTextId());
        map.put("message", this.getMessage());
        map.put("iconColor", this.getIconColor());
        map.put("id", this.getId());
        return map;
    }

    public String getName() {
        return this.name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public String getMap() {
        return this.map;
    }
    public void setMap(String map) {
        this.map = map;
    }

    public String getDefaultMessage() {return this.defaultMessage; }
    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }


    public String getDescription() {return this.description; }
    public void setDescription(String description) {
        this.description = description;
    }

    public String getClick() {return this.click; }
    public void setClick(String click) {this.click = click;}

    public String getImg() {return this.img; }
    public void setImg(String img) {this.img = img;}

    public String getColor() {return this.color; }
    public void setColor(String color) {this.color = color;}

    public String getImgId() {return this.imgId; }
    public void setImgId(String imgId) {this.imgId = imgId;}

    public String getTextId() {return this.textId; }
    public void setTextId(String textId) {this.textId = textId;}

    public String getMessage() {return this.message; }
    public void setMessage(String message) {this.message = message;}

    public String getIconColor() {return this.iconColor; }
    public void setIconColor(String iconColor) {this.iconColor = iconColor;}
    public String getId() {return this.id; }
    public void setId(String id) {this.id = id;}
}
