package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

@UITag
public class HlsQueryTab extends HlsPage {
    public static final String PROPERTITY_HLSQUERYTAB ="hlsQueryTab";
    public static final String PROPERTITY_HLSINPUTIMAGE = "inputImage";
    public static final String PROPERTITY_HLSSUGGESTMAXHEIGHT = "suggestMaxHeight";
    public static final String PROPERTITY_HLSITEMCOLOR = "itemColor";
    public static final String PROPERTITY_HLSITEMOVERCOLOR = "itemOverColor";
    public static final String PROPERTITY_HLSITEMOVERBACKGROUNDCOLOR = "itemOverBackgroundColor";
    public static final String PROPERTITY_HLSITEMBACKGROUNDCOLOR ="itemBackgroundColor";
    public static final String PROPERTITY_HLSITEMPADDING = "itemPadding";
    public static final String PROPERTITY_HLSFONTSIZE = "fontSize";
    public static final String PROPERTITY_HLSALWAYSSHOWALL = "alwaysShowALL";
    public static final String PROPERTITY_HLSITEMSELECTFUNCTION = "itemSelectFunction";
    public static final String PROPERTITY_HLSURL = "url";
    public static final String PROPERTITY_HLSQUERYID = "queryId";
    public static final String PROPERTITY_HLSQUERYTEXT = "queryText";


    public static HlsQueryTab createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
                PROPERTITY_HLSQUERYTAB);
        HlsQueryTab hlsQueryTab = new HlsQueryTab();
        hlsQueryTab.initPrototype(view);
        return hlsQueryTab;
    }
    public String getQueryId(){
        return getPrototype().getString(PROPERTITY_HLSQUERYID);
    }
    public String getQueryText(){
        return getPrototype().getString(PROPERTITY_HLSQUERYTEXT);
    }
    public String getItemBackgroundColor(){
        return getPrototype().getString(PROPERTITY_HLSITEMBACKGROUNDCOLOR);
    }
    public String getInputImage(){
        return getPrototype().getString(PROPERTITY_HLSINPUTIMAGE);
    }
    public String getUrl(){
        return getPrototype().getString(PROPERTITY_HLSURL);
    }
    public String getItemSelectFunction(){
        return getPrototype().getString(PROPERTITY_HLSITEMSELECTFUNCTION);
    }
    public String getSuggestMaxHeight(){
        return getPrototype().getString(PROPERTITY_HLSSUGGESTMAXHEIGHT);
    }
    public String getItemColor(){
        return getPrototype().getString(PROPERTITY_HLSITEMCOLOR);
    }
    public String getItemOverColor(){
        return getPrototype().getString(PROPERTITY_HLSITEMOVERCOLOR);
    }
    public String getItemOverBackgroundColor(){
        return getPrototype().getString(PROPERTITY_HLSITEMOVERBACKGROUNDCOLOR);
    }
    public String getItemPadding(){
        return getPrototype().getString(PROPERTITY_HLSITEMPADDING);
    }
    public String getfontSize(){
        return getPrototype().getString(PROPERTITY_HLSFONTSIZE);
    }
    public String getAlwaysShowALL(){
        return getPrototype().getString(PROPERTITY_HLSALWAYSSHOWALL);
    }



    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_HLSSUGGESTMAXHEIGHT,getSuggestMaxHeight());
        context.put(PROPERTITY_HLSITEMCOLOR,getItemColor());
        context.put(PROPERTITY_HLSITEMOVERCOLOR,getItemOverColor());
        context.put(PROPERTITY_HLSITEMOVERBACKGROUNDCOLOR,getItemOverBackgroundColor());
        context.put(PROPERTITY_HLSITEMPADDING,getItemPadding());
        context.put(PROPERTITY_HLSFONTSIZE,getfontSize());
        context.put(PROPERTITY_HLSALWAYSSHOWALL,getAlwaysShowALL());
        context.put(PROPERTITY_HLSITEMSELECTFUNCTION,getItemSelectFunction());
        context.put(PROPERTITY_HLSURL,getUrl());
        context.put(PROPERTITY_HLSINPUTIMAGE,getInputImage());
        context.put(PROPERTITY_HLSITEMBACKGROUNDCOLOR,getItemBackgroundColor());
        context.put(PROPERTITY_HLSQUERYID,getQueryId());
        context.put(PROPERTITY_HLSQUERYTEXT,getQueryText());
        context.addJsonConfig("itemBackgroundColor",getItemBackgroundColor());
        context.addJsonConfig("suggestMaxHeight",getSuggestMaxHeight());
        context.addJsonConfig("itemColor",getItemColor());
        context.addJsonConfig("itemOverColor",getItemOverColor());
        context.addJsonConfig("itemOverBackgroundColor",getItemOverBackgroundColor());
        context.addJsonConfig("itemPadding",getItemPadding());
        context.addJsonConfig("fontSize",getfontSize());
        context.addJsonConfig("alwaysShowALL",getAlwaysShowALL());
        context.addJsonConfig("itemSelectFunction",getItemSelectFunction());
        context.addJsonConfig("url",getUrl());
        context.addJsonConfig("queryId",getQueryId());
        context.addJsonConfig("queryText",getQueryText());
    }


}