/**
 * Copyright (C), 2018-2021
 * FileName: ClientUtils
 * Author:   lsy
 * Date:     2021/8/6 11:06
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * lishuangyi        修改时间           版本号              描述
 */
package com.hand.app.zhongDengWang.utils;

import com.hand.app.zhongDengWang.ws.login.WSLoginService;
import com.hand.app.zhongDengWang.ws.login.WSLoginServiceService;
import com.qq.weixin.mp.aes.AesException;
import com.rfp.sm.utils.SM2Utils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * 〈〉
 *
 * @author 27214
 * @create 2021/8/6
 * @since 1.0.0
 */
public class ClientUtils {

    public static byte[] getAttachmentZip(String attachmentZipPath) {
        InputStream is = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            is = new FileInputStream(attachmentZipPath);// pathStr 锟侥硷拷路锟斤拷
            byte[] b = new byte[1024];
            int n;
            while ((n = is.read(b)) != -1) {
                out.write(b, 0, n);
            }// end while
        } catch (Exception e) {
            //log.error(getText("TimingMmsService.error") + e.getMessage());
            //throw new Exception("System error,SendTimingMms.getBytesFromFile", e);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (Exception e) {
                    //log.error(e);// TODO
                }// end try
            }// end if
        }// end try

        return out.toByteArray();
    }


    public static byte[] getxmlFileContent(String xmlPath) throws TransformerFactoryConfigurationError, TransformerException, Exception {

        InputStream in = null;
        InputStreamReader reader = null;
        Document document = null;
        File file = new File(xmlPath);
        in = new FileInputStream(file);
        reader = new InputStreamReader(in, "UTF-8");
        //reader = new InputStreamReader(in);
        SAXReader saxReader = new SAXReader();
        try {
            document = saxReader.read(reader);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }


        javax.xml.transform.Transformer transformer = TransformerFactory.newInstance().newTransformer();
//        transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8") ;
        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(bos);
        transformer.transform(new DOMSource(parse(document)), streamResult);
        return bos.toByteArray();
    }

    /**
     * org.dom4j.Document   ->   org.w3c.dom.Document
     *
     * @param doc Document(org.dom4j.Document)
     * @return Document
     * @throws Exception
     */
    public static org.w3c.dom.Document parse(Document doc) throws Exception {
        if (doc == null) {
            return (null);
        }
        java.io.StringReader reader = new java.io.StringReader(doc.asXML());
        org.xml.sax.InputSource source = new org.xml.sax.InputSource(reader);
        javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory =
                javax.xml.parsers.DocumentBuilderFactory.newInstance();
        javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory.
                newDocumentBuilder();
        return (documentBuilder.parse(source));
    }

    /**
     * 将xml转化为Map集合
     *
     * @param request
     * @return
     */
    public static Map<String, String> xmlToMap(HttpServletRequest request) {
        Map<String, String> map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        InputStream ins = null;
        try {
            ins = request.getInputStream();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        Document doc = null;
        try {
            doc = reader.read(ins);
        } catch (DocumentException e1) {
            e1.printStackTrace();
        }
        org.dom4j.Element root = doc.getRootElement();
        @SuppressWarnings("unchecked")
        List<org.dom4j.Element> list = root.elements();
        for (org.dom4j.Element e : list) {
            map.put(e.getName(), e.getText());
        }
        try {
            ins.close();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        return map;
    }
}