package com.hand.app.hms.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/**
 * Created by Think-PC on 2018/7/2.
 */
@Controller
@RequestMapping(value = "/r/api")
public class RiskstormController extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(RiskstormController.class);
    @Autowired
    IHapInterfaceHeaderService headerService;

    @RequestMapping(value = "/app/riskQuery")
    @ResponseBody
    @Timed
    public JSONObject getRisk(HttpServletRequest request, @RequestBody(required = false) JSONObject params)throws HapApiException, IOException {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        logger.info("return hapInterfaceHeader:{}", hapInterfaceHeader);
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        String data =  this.get(url,hapInterfaceHeader,params);
        return JSONObject.parseObject(data.toString().replaceAll("null", "\"\""));
    }

    private String get(String url, HapInterfaceHeader headerAndLineDTO, JSONObject params) {
        String resultData = "";
        //风暴接口 替换组织机构代码
        if (url.indexOf("{companyOrg}") != -1) {
            url = url.replace("{companyOrg}", params.getString("companyOrg"));
        }
        // TODO get请求把参数拼在url后面，根据自己需求更改
        if (params != null && params.size() > 0) {
            url += "?";
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                if (key == "companyOrg") {
                } else {
                    url += key + "=" + entry.getValue() + "&";
                }
            }
            url = url.substring(0, url.length() - 1);
        }
        logger.info("request url:{}", url);
        HttpURLConnection httpURLConnection1 = null;

        try {
            URL e1 = new URL(url);
            httpURLConnection1 = (HttpURLConnection)e1.openConnection();
            httpURLConnection1.setRequestMethod("GET");
            if(headerAndLineDTO.getRequestAccept() != null) {
                httpURLConnection1.setRequestProperty("Accept", headerAndLineDTO.getRequestAccept());
            }
            httpURLConnection1.connect();
            HapInvokeInfo.HTTP_RESPONSE_CODE.set(Integer.valueOf(httpURLConnection1.getResponseCode()));
            int responseCode1 = httpURLConnection1.getResponseCode();
            if(responseCode1 != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + httpURLConnection1.getResponseCode());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection1.getInputStream(), "utf-8"));
            StringBuilder results = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                results.append(line);
            }
            reader.close();
            resultData = results.toString();
            httpURLConnection1.disconnect();
        } catch (MalformedURLException var14) {
            var14.printStackTrace();
            this.logger.error(var14.getMessage());
        } catch (IOException var15) {
            var15.printStackTrace();
            this.logger.error(var15.getMessage());
        } finally {
            if(httpURLConnection1 != null) {
                httpURLConnection1.disconnect();
            }
        }
        this.logger.info("responseData:{}", resultData);
        return resultData;
    }
}
