package com.hand.app.esign.controllers;

import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.app.esign.dto.OrganSignInfo;
import com.hand.app.esign.dto.SignInfo;
import com.hand.app.esign.service.IOrganSignInfoService;
import com.hand.app.esign.service.ISignInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2018/1/17
 * Time: 13:50
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class SignController extends BaseController {
    @Autowired
    private ISignInfoService signService;
    @Autowired
    private IOrganSignInfoService organSignService;
    private Logger logger = LoggerFactory.getLogger(getClass());

    @ResponseBody
    @RequestMapping("/app/sign/pdf")
    public ResponseData signPdf(HttpServletRequest request, @RequestBody SignInfo signInfo) {
        ResponseData responseData;
        try {
            responseData = signService.pdfSign(createRequestContext(request), signInfo);
        } catch (Exception e) {
            logger.error("something error!", e);
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error: " + e.getMessage());
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping("/app/sign/pdfByFile")
    public ResponseData signPdfByFile(HttpServletRequest request, @RequestBody SignInfo signInfo) {
        ResponseData responseData;
        try {
            responseData = signService.pdfSignByFile(createRequestContext(request), signInfo);
        } catch (Exception e) {
            logger.error("something error!", e);
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error: " + e.getMessage());
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping("/app/sign/pdfByOrgan")
    public ResponseData signPdfByOrgan(HttpServletRequest request, @RequestBody OrganSignInfo organsignInfo) {
        ResponseData responseData;
        try {
            responseData = organSignService.pdfSignByOrgan(createRequestContext(request), organsignInfo);
        } catch (Exception e) {
            logger.error("something error!", e);
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error: " + e.getMessage());
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping("/app/sign/register")
    public Map<String, Object> getUserAccountOrRegister(HttpServletRequest request,
                                                        @RequestBody SignInfo signInfo) {
        return signService.getUserAccountOrRegister(createRequestContext(request), signInfo);

    }

    @ResponseBody
    @RequestMapping("/app/sign/registerByOrgan")
    public Map<String, Object> getUserAccountOrRegisterByOrgan(HttpServletRequest request,
                                                        @RequestBody OrganSignInfo organsignInfo) {
        return organSignService.getUserAccountOrRegisterByOrgan(createRequestContext(request), organsignInfo);

    }
}
